// FileCFGDlg.cpp : implementation file
//

#include "stdio.h"
#include "stdlib.h"
#include "string.h"
#include "stdafx.h"
#include "FileCFG.h"
#include "FileCFGDlg.h"
#include "FileArea.h"
#include "tipdlg.h"
#include <ctype.h>

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CFileCFGDlg dialog

CFileCFGDlg::CFileCFGDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CFileCFGDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CFileCFGDlg)
	//}}AFX_DATA_INIT
	// Note that LoadIcon does not require a subsequent DestroyIcon in Win32
	m_hIcon = AfxGetApp()->LoadIcon(IDR_MAINFRAME);
}

void CFileCFGDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CFileCFGDlg)
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CFileCFGDlg, CDialog)
	//{{AFX_MSG_MAP(CFileCFGDlg)
	ON_WM_SYSCOMMAND()
	ON_WM_DESTROY()
	ON_WM_PAINT()
	ON_WM_QUERYDRAGICON()
	ON_BN_CLICKED(IDC_BUTTON_EXIT, OnButtonExit)
	ON_BN_CLICKED(IDC_BUTTON_REINDEX, OnButtonReindex)
	ON_BN_CLICKED(IDC_BUTTON_FILE_AREAS, OnButtonFileAreas)
	ON_WM_CREATE()
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CFileCFGDlg message handlers

BOOL CFileCFGDlg::OnInitDialog()
{
	CDialog::OnInitDialog();

	// Add "About..." menu item to system menu.

	// IDM_ABOUTBOX must be in the system command range.
	ASSERT((IDM_ABOUTBOX & 0xFFF0) == IDM_ABOUTBOX);
	ASSERT(IDM_ABOUTBOX < 0xF000);

	CMenu* pSysMenu = GetSystemMenu(FALSE);
	CString strAboutMenu;
	strAboutMenu.LoadString(IDS_ABOUTBOX);
	if (!strAboutMenu.IsEmpty())
	{
		pSysMenu->AppendMenu(MF_SEPARATOR);
		pSysMenu->AppendMenu(MF_STRING, IDM_ABOUTBOX, strAboutMenu);
	}

	// Set the icon for this dialog.  The framework does this automatically
	//  when the application's main window is not a dialog
	SetIcon(m_hIcon, TRUE);			// Set big icon
	SetIcon(m_hIcon, FALSE);		// Set small icon

	// TODO: Add extra initialization here
	if( !getenv("PROBOARD") ){
		MessageBox("PROBOARD environment not set!", "FileCFG/32",MB_ICONERROR|MB_OK);
		OnOK();
	}

	strcpy(m_SysPath, getenv("PROBOARD"));

	return TRUE;  // return TRUE  unless you set the focus to a control
}

void CFileCFGDlg::OnSysCommand(UINT nID, LPARAM lParam)
{
	if ((nID & 0xFFF0) == IDM_ABOUTBOX)
	{
		CAboutDlg dlgAbout;
		dlgAbout.DoModal();
	}
	else
	{
		CDialog::OnSysCommand(nID, lParam);
	}
}

void CFileCFGDlg::OnDestroy()
{
	WinHelp(0L, HELP_QUIT);
	CDialog::OnDestroy();
}

// If you add a minimize button to your dialog, you will need the code below
//  to draw the icon.  For MFC applications using the document/view model,
//  this is automatically done for you by the framework.

void CFileCFGDlg::OnPaint()
{
	if (IsIconic())
	{
		CPaintDC dc(this); // device context for painting

		SendMessage(WM_ICONERASEBKGND, (WPARAM) dc.GetSafeHdc(), 0);

		// Center icon in client rectangle
		int cxIcon = GetSystemMetrics(SM_CXICON);
		int cyIcon = GetSystemMetrics(SM_CYICON);
		CRect rect;
		GetClientRect(&rect);
		int x = (rect.Width() - cxIcon + 1) / 2;
		int y = (rect.Height() - cyIcon + 1) / 2;

		// Draw the icon
		dc.DrawIcon(x, y, m_hIcon);
	}
	else
	{
		CDialog::OnPaint();
	}
}

// The system calls this to obtain the cursor to display while the user drags
//  the minimized window.
HCURSOR CFileCFGDlg::OnQueryDragIcon()
{
	return (HCURSOR) m_hIcon;
}

void CFileCFGDlg::OnButtonExit()
{
	OnOK();
}

// This is the reindexing function:
//
// it uses the ProBoard path to locate the file
// area configuration, reads it area by area and
// rebuilds the FILES.BBS index.
void CFileCFGDlg::OnButtonReindex()
{
	CProgressDlg *dlg;
	CFile         idx, src, bbs;
	TFileArea     area;
	char	      idxPath[_MAX_PATH],
			      srcPath[_MAX_PATH];
	int           n;
	ushort        nArea = 0;

	sprintf(idxPath, "%s\\FILESIDX.PB", m_SysPath);
	sprintf(srcPath, "%s\\FILECFG.PRO", m_SysPath);

	if(!src.Open(srcPath, CFile::modeRead|CFile::shareDenyWrite))
		return;
	if(!idx.Open(idxPath, CFile::modeCreate|CFile::modeWrite|CFile::shareDenyWrite)){
		src.Close();
		return;
	}
	n = int(src.GetLength() / sizeof(TFileArea));

	dlg = new CProgressDlg;
	dlg->Create(this);
	dlg->SetRange(0, n);
	dlg->SetStep(1);

	n = src.Read(&area, UINT(sizeof(area)));
	while( n == sizeof(area) ){
		nArea++;
		if( '\0' != area.name[0] ){
			CString name = area.name;
			name.AnsiToOem();
			dlg->SetStatus(name);
			MakeIndex(nArea, area, idx);
		}
		dlg->StepIt();
		n = src.Read(&area, UINT(sizeof(area)));
	}
	delete dlg;
}

void CFileCFGDlg::MakeIndex(ushort nArea, TFileArea &area, CFile &idx)
{
	CStdioFile bbs;
	BOOL       more;
	CString    line;

	if(!bbs.Open(area.listpath, CFile::typeText|CFile::modeRead|CFile::shareDenyWrite))
		return;

	more = bbs.ReadString(line);
	while( more ){
		CString name = line.SpanExcluding(" \t");
		if(!name.IsEmpty() && !strchr(";!+", name[0]) && isprint(name[0]) ){
			// we have a file name, write it
			TFileIndex index;
			name.MakeUpper();
			strcpy(index.name, LPCTSTR(name));
			index.area = nArea;
			idx.Write(&index, sizeof(index));
		}
		more = bbs.ReadString(line);
	}
	bbs.Close();
}

void CFileCFGDlg::OnButtonFileAreas()
{
	CFileArea *dlg = new CFileArea;

	if( dlg ){
		dlg->DoModal();
		delete dlg;
	}
}


int CFileCFGDlg::OnCreate(LPCREATESTRUCT lpCreateStruct) 
{
	theApp.ShowSplashScreen();
	theApp.ShowTipAtStartup();
	return CDialog::OnCreate(lpCreateStruct);
}
