// FileArea.h : header file
//
#include "proboard.h"
#include "progdlg.h"
#include "areatools.h"

/////////////////////////////////////////////////////////////////////////////
// CFileArea dialog

class CFileArea : public CDialog
{
// Construction
public:
	CFileArea(CWnd* pParent = NULL);   // standard constructor

// Dialog Data
	//{{AFX_DATA(CFileArea)
	enum { IDD = IDD_DIALOG_FILE_AREAS };
	CListBox	m_ListBox;
	//}}AFX_DATA


// Overrides
	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CFileArea)
	protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support
	//}}AFX_VIRTUAL

// Implementation
protected:

	// ProBoard system directory
	char m_SysPath[_MAX_PATH];
	// the string to show if there's no area name
	static char *m_NoText;
	// data has not been saved flag
	BOOL shouldSave;
	// do we have an initialized find dialog
	BOOL m_FindDlgInited;
	// the current index of the match
	int m_FindIndex;
	// the toolbar for the list box
	CAreaTools m_ToolBar;
	// the anchor for the group move
	int m_AnchorIndex;
	// the title string for the message boxes
	CString m_Title;
	
	BOOL LoadData();
	BOOL SaveData();
	void SetNumberData();
	void OnCancel();	// override the default
	void MoveSorted(BOOL ascending);
	
	// Generated message map functions
	//{{AFX_MSG(CFileArea)
	afx_msg void OnMenuHelpAbout();
	afx_msg void OnMenuExit();
	afx_msg LONG OnFindCall(WPARAM, LPARAM);
	virtual BOOL OnInitDialog();
	afx_msg void OnMenuLoad();
	afx_msg void OnMenuSelectAll();
	afx_msg void OnMenuUnselect();
	afx_msg void OnMenuSwap();
	afx_msg void OnMenuSave();
	afx_msg void OnMenuClear();
	afx_msg void OnMenuPack();
	afx_msg void OnMenuDelete();
	afx_msg void OnMenuInsert();
	afx_msg void OnMenuClone();
	afx_msg void OnMenuStardate();
	afx_msg void OnSelchangeListFileAreas();
	afx_msg void OnButtonMoveDown();
	afx_msg void OnButtonMoveUp();
	afx_msg void OnButtonFind();
	afx_msg int OnVKeyToItem(UINT nKey, CListBox* pListBox, UINT nIndex);
	afx_msg void OnMenuEdit();
	afx_msg void OnContextMenu(CWnd* pWnd, CPoint point);
	afx_msg void OnMenuSelectbyGroup();
	afx_msg void OnMenuSelectbyLevel();
	afx_msg void OnMenuTipOfDay();
	afx_msg void OnMenuSelectbyType();
	afx_msg void OnButtonGlobal();
	afx_msg void OnButtonMoveSelected();
	afx_msg void OnButtonSortSelected();
	afx_msg void OnMenuSortAscending();
	afx_msg void OnMenuSortDescending();
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};

static UINT WM_FIND = ::RegisterWindowMessage(FINDMSGSTRING);

