// FileArea.cpp : implementation file
//

#include "stdafx.h"
#include "FileCFG.h"
#include "FileArea.h"
#include "PropFileLoc.h"
#include "PropFileFlag.h"
#include "PropFileGroup.h"
#include "PropSecurity.h"
#include "SelectGroup.h"
#include "SelectLevel.h"
#include "SelectType.h"
#include "GlobalFile.h"
#include "SortWait.h"
#include "tipdlg.h"
#include <string.h>
#include <stdlib.h>

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

const int _nHugeValues = 32000;

/////////////////////////////////////////////////////////////////////////////
// CFileArea dialog

char *CFileArea::m_NoText = "<empty definition>";

CFileArea::CFileArea(CWnd* pParent /*=NULL*/)
	: CDialog(CFileArea::IDD, pParent)
{
	//{{AFX_DATA_INIT(CFileArea)
	//}}AFX_DATA_INIT
}

void CFileArea::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CFileArea)
	DDX_Control(pDX, IDC_LIST_FILE_AREAS, m_ListBox);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CFileArea, CDialog)
	//{{AFX_MSG_MAP(CFileArea)
	ON_COMMAND(IDR_MENU_HELP_ABOUT, OnMenuHelpAbout)
	ON_COMMAND(IDR_MENU_EXIT, OnMenuExit)
	ON_REGISTERED_MESSAGE(WM_FIND, OnFindCall)
	ON_COMMAND(IDR_MENU_LOAD, OnMenuLoad)
	ON_COMMAND(IDR_MENU_SELECT_ALL, OnMenuSelectAll)
	ON_COMMAND(IDR_MENU_UNSELECT, OnMenuUnselect)
	ON_COMMAND(IDR_MENU_SWAP, OnMenuSwap)
	ON_COMMAND(IDR_MENU_SAVE, OnMenuSave)
	ON_COMMAND(IDR_MENU_CLEAR, OnMenuClear)
	ON_COMMAND(IDR_MENU_PACK, OnMenuPack)
	ON_COMMAND(IDR_MENU_DELETE, OnMenuDelete)
	ON_COMMAND(IDR_MENU_INSERT, OnMenuInsert)
	ON_COMMAND(IDR_MENU_CLONE, OnMenuClone)
	ON_COMMAND(IDR_MENU_STARDATE, OnMenuStardate)
	ON_LBN_SELCHANGE(IDC_LIST_FILE_AREAS, OnSelchangeListFileAreas)
	ON_COMMAND(IDR_MENU_MOVE_DOWN, OnButtonMoveDown)
	ON_COMMAND(IDR_MENU_MOVE_UP, OnButtonMoveUp)
	ON_BN_CLICKED(IDC_BUTTON_FIND, OnButtonFind)
	ON_WM_VKEYTOITEM()
	ON_COMMAND(IDR_MENU_POPUP_EDIT, OnMenuEdit)
	ON_WM_CONTEXTMENU()
	ON_COMMAND(IDR_MENU_SELECTBY_GROUP, OnMenuSelectbyGroup)
	ON_COMMAND(IDR_MENU_SELECTBY_LEVEL, OnMenuSelectbyLevel)
	ON_COMMAND(IDR_MENU_TIP_OF_DAY, OnMenuTipOfDay)
	ON_COMMAND(IDR_MENU_SELECTBY_TYPE, OnMenuSelectbyType)
	ON_BN_CLICKED(IDC_BUTTON_GLOBAL, OnButtonGlobal)
	ON_BN_CLICKED(IDC_BUTTON_MOVE_SELECTED, OnButtonMoveSelected)
	ON_BN_CLICKED(IDC_BUTTON_SORT_SELECTED, OnButtonSortSelected)
	ON_COMMAND(IDR_MENU_SORT_ASCENDING, OnMenuSortAscending)
	ON_COMMAND(IDR_MENU_SORT_DESCENDING, OnMenuSortDescending)
	ON_BN_CLICKED(IDC_BUTTON_EXIT, OnMenuExit)
	ON_BN_CLICKED(IDC_BUTTON_SWAP, OnMenuSwap)
	ON_BN_CLICKED(IDC_BUTTON_SAVE, OnMenuSave)
	ON_COMMAND(IDR_MENU_FIND_TEXT, OnButtonFind)
	ON_COMMAND(IDR_MENU_POPUP_CLEAR, OnMenuClear)
	ON_COMMAND(IDR_MENU_POPUP_CLONE, OnMenuClone)
	ON_COMMAND(IDR_MENU_POPUP_DELETE, OnMenuDelete)
	ON_COMMAND(IDR_MENU_POPUP_INSERT, OnMenuInsert)
	ON_LBN_DBLCLK(IDC_LIST_FILE_AREAS, OnMenuEdit)
	ON_BN_CLICKED(IDC_BUTTON_EDIT, OnMenuEdit)
	ON_COMMAND(IDR_MENU_EDIT, OnMenuEdit)
	ON_COMMAND(ID_BUTTON_TB_CLEAR, OnMenuClear)
	ON_COMMAND(ID_BUTTON_TB_DELETE, OnMenuDelete)
	ON_COMMAND(ID_BUTTON_TB_MOVEDOWN, OnButtonMoveDown)
	ON_COMMAND(ID_BUTTON_TB_MOVEUP, OnButtonMoveUp)
	ON_COMMAND(ID_BUTTON_TB_NEW, OnMenuInsert)
	ON_COMMAND(ID_BUTTON_TB_CLONE, OnMenuClone)
	ON_COMMAND(IDR_MENU_GLOBAL, OnButtonGlobal)
	ON_COMMAND(IDR_MENU_MOVE, OnButtonMoveSelected)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()


/////////////////////////////////////////////////////////////////////////////
// CFileArea message handlers

void CFileArea::OnMenuHelpAbout() 
{
	CAboutDlg dlg;
	dlg.DoModal();
}

void CFileArea::OnMenuExit() 
{
	if( shouldSave ){
		CString msg;

		msg.LoadString(IDS_SHOULD_SAVE);
		switch(MessageBox(msg, m_Title,MB_ICONQUESTION|MB_YESNOCANCEL))
		{
			case IDCANCEL: return;	// don't quit yet
			case IDYES   : OnMenuSave(); // fall-through
			case IDNO    : break;
		}
	}
	OnOK();
}

BOOL CFileArea::OnInitDialog() 
{
	CDialog::OnInitDialog();

	// this should always work (checked by program already)
	strcpy(m_SysPath, getenv("PROBOARD"));
	m_FindDlgInited = FALSE;

	// load the common caption for the message boxes
	m_Title.LoadString(IDS_TITLE);

	// load the toolbar icons
	CRect rect;
	GetDlgItem(IDC_STATIC_TOOLBAR_FRAME)->GetWindowRect(&rect);
	ScreenToClient(&rect);
	rect.DeflateRect(1, 1);
	m_ToolBar.Create(WS_VISIBLE|WS_CHILD|CCS_NODIVIDER|CCS_NORESIZE,
					 rect, this, IDB_BITMAP_TOOLBAR);
	LoadData();

	return FALSE;	// because the list box is focused
}


BOOL CFileArea::LoadData()
{
	CFile         file;
	TFileArea     area;
	CProgressDlg *bar;
	UINT          bytes;
	short         nAreas;
	char          path[_MAX_PATH];	

	sprintf(path, "%s\\FILECFG.PRO", m_SysPath);
	if(!file.Open(path,CFile::modeRead|CFile::shareDenyWrite))
		return FALSE;

	nAreas = short(file.GetLength() / sizeof(TFileArea));
	
	// conservative estimate: 40 characters/area
	if(LB_ERRSPACE == m_ListBox.InitStorage(nAreas, UINT(nAreas)*40)){
		file.Close();
		return FALSE;
	}

	bar = new CProgressDlg;
	bar->Create(this);
	bar->SetRange(0, nAreas);
	bar->SetStep(1);

	bytes = file.Read(&area, sizeof(area));
	while( bytes == sizeof(TFileArea) ){
		if( '\0' == area.name[0] ){
			bar->SetStatus("<empty area>");
			m_ListBox.AddString(m_NoText);
		}
		else{
			CString name = area.name;
			name.OemToAnsi();
			bar->SetStatus(name);
			m_ListBox.AddString(name);
		}
		bar->StepIt();
		bytes = file.Read(&area, sizeof(area));
	}
	file.Close();

	// set the internal area numbers
	SetNumberData();
	shouldSave = FALSE;
	GotoDlgCtrl(GetDlgItem(IDC_LIST_FILE_AREAS));
	m_ListBox.SetSel(0, TRUE);
	delete bar;
	return TRUE;
}

// set the internal numbers to match the list
void CFileArea::SetNumberData()
{
	for(int i = 0; i < m_ListBox.GetCount(); ++i)
		m_ListBox.SetItemData(i, DWORD(i));
}

// load the data from the file (dispose of current)
void CFileArea::OnMenuLoad() 
{
	if( shouldSave ){
		CString msg;
		msg.LoadString(IDS_PROMPT_SAVE);
		switch(MessageBox(msg,m_Title,MB_ICONQUESTION|MB_YESNOCANCEL)){
			case IDCANCEL: return;
			case IDYES   : OnMenuSave();
			case IDNO    : break;
		}
	}

	m_ListBox.ResetContent();
	if( !LoadData() ){
		CString msg;
		msg.LoadString(IDS_ERROR_LOAD);
		MessageBox(msg,m_Title, MB_ICONERROR|MB_OK);
	}
}

// select all items in the list
void CFileArea::OnMenuSelectAll() 
{
	m_ListBox.SelItemRange(TRUE, 0, m_ListBox.GetCount()-1);
	OnSelchangeListFileAreas();
}

// deselect all items in the list
void CFileArea::OnMenuUnselect() 
{
	m_ListBox.SelItemRange(FALSE, 0, m_ListBox.GetCount()-1);
	OnSelchangeListFileAreas();
}

// swap two areas
void CFileArea::OnMenuSwap() 
{
	int   select[2];
	DWORD data;
	char  buf[2][80];
	
	if( 2 != m_ListBox.GetSelCount() ){
		CString msg;

		msg.LoadString(IDS_SWAP_PROBLEM);
		MessageBox(msg,m_Title, MB_ICONINFORMATION);
	}
	else{
		m_ListBox.GetSelItems(2, LPINT(select));
		m_ListBox.GetText(select[0], buf[0]);
		m_ListBox.GetText(select[1], buf[1]);
		data = m_ListBox.GetItemData(select[1]);
		m_ListBox.DeleteString(select[1]);
		m_ListBox.InsertString(select[1], buf[0]);
		m_ListBox.SetItemData(select[1], m_ListBox.GetItemData(select[0]));
		m_ListBox.DeleteString(select[0]);
		m_ListBox.InsertString(select[0], buf[1]);
		m_ListBox.SetItemData(select[0], data);
		m_ListBox.SetCaretIndex(select[1], FALSE);
		m_ListBox.SetSel(select[0], TRUE);
		m_ListBox.SetSel(select[1], TRUE);
		shouldSave = TRUE;
	}
}


// dump the list to the file
void CFileArea::OnMenuSave() 
{
	char          in[_MAX_PATH], out[_MAX_PATH];
	char         *statText = "<empty area>";
	CFile         fin, fout;
	DWORD         maxCount;
	TFileArea     area;
	CProgressDlg *bar;
	CString       msg;

	sprintf(in, "%s\\FILECFG.PRO", m_SysPath);
	sprintf(out, "%s\\FILECFG.BIN", m_SysPath);
	if(!fin.Open(in, CFile::modeRead|CFile::shareDenyWrite)){
		msg.LoadString(IDS_ERROR_OPEN);
		MessageBox(msg, m_Title, MB_ICONERROR|MB_OK);
		return;
	}
	if(!fout.Open(out, CFile::modeCreate|CFile::modeWrite)){
		fin.Close();
		msg.LoadString(IDS_ERROR_CREATE);
		MessageBox(msg, m_Title, MB_ICONERROR|MB_OK);
		return;
	}

	maxCount = fin.GetLength() / sizeof(TFileArea);
	
	bar = new CProgressDlg;
	bar->Create(this);
	bar->SetRange(0, m_ListBox.GetCount());
	bar->SetStep(1);

	for(int i = 0; i < m_ListBox.GetCount(); ++i){
		DWORD item = m_ListBox.GetItemData(i);
		// see if we have a cloned area
		if( item > _nHugeValues ) item -= _nHugeValues;

		// currently not in the file, dump it
		if( item >= maxCount ){
			memset(&area, 0, sizeof(area));
			bar->SetStatus(statText);
		}
		else{
			fin.Seek(item * sizeof(TFileArea), CFile::begin);
			fin.Read(&area, sizeof(area));
			if( '\0' == area.name[0] )
				bar->SetStatus(statText);
			else{
				CString name = area.name;
				name.OemToAnsi();
				bar->SetStatus(name);
			}
		}
		fout.Write(&area, sizeof(area));
		bar->StepIt();
	}

	fin.Close();
	fout.Close();

	CFile::Remove(in);
	CFile::Rename(out, in);
	SetNumberData();
	delete bar;
	shouldSave = FALSE;
}

// clears the current area(s): set string to no
// text and the ID number to high (as if it's
// not in the original file)
void CFileArea::OnMenuClear() 
{
	int  count = m_ListBox.GetSelCount();
	int *buf = new int [count];

	if( !buf ){
		return;
	}

	m_ListBox.GetSelItems(count, buf);
	for(int i = 0; i < count; ++i){
		m_ListBox.DeleteString(buf[i]);
		m_ListBox.InsertString(buf[i], m_NoText);
		m_ListBox.SetItemData(buf[i], _nHugeValues);
	}
	m_ListBox.SetSel(buf[0], TRUE);
	GotoDlgCtrl(GetDlgItem(IDC_LIST_FILE_AREAS));
	shouldSave = TRUE;
	delete buf;
}


// removes all empty areas from the list
void CFileArea::OnMenuPack() 
{
	int  count = 0;
	char buf[80];

	for(int i = 0; i < m_ListBox.GetCount(); ++i){
		m_ListBox.GetText(i, buf);
		if( !stricmp(m_NoText, buf) ){
			m_ListBox.DeleteString(i);
			i--;
			count++;
		}
	}
	OnMenuUnselect();
	m_ListBox.SetCaretIndex(0, FALSE);
	m_ListBox.SetSel(0, TRUE);

	if( count ){
		sprintf(buf, "Removed %d areas from the list.", count);
		shouldSave = TRUE;
	}
	else
		strcpy(buf, "No areas were removed from the list.");
	
	MessageBox(buf, m_Title, MB_ICONINFORMATION|MB_OK);
}

// delete current (or selected) items
void CFileArea::OnMenuDelete() 
{
	CString  msg;
	int      n = m_ListBox.GetSelCount();
	int     *buf;

	if( 1 < n ){
		msg.LoadString(IDS_WARN_DELETE);
		if(IDYES != MessageBox(msg, m_Title, MB_ICONQUESTION|MB_YESNO))
			return;
	}

	buf = new int [n];
	if( buf ){
		m_ListBox.GetSelItems(n, buf);
		for( int i = 0; i < n; ++i ){
			m_ListBox.DeleteString(buf[i] - i);
		}
		if( buf[0] >= m_ListBox.GetCount() )
			m_ListBox.SetSel(m_ListBox.GetCount()-1, TRUE);
		else
			m_ListBox.SetSel(buf[0], TRUE);
		GotoDlgCtrl(GetDlgItem(IDC_LIST_FILE_AREAS));
		shouldSave = TRUE;
		delete buf;
	}
}

// inserts an area at the current position
void CFileArea::OnMenuInsert() 
{
	int index = 0;

	if( 10000 == m_ListBox.GetCount() ){
		CString msg;
		msg.LoadString(IDS_MAX_AREAS);
		MessageBox(msg, m_Title, MB_ICONEXCLAMATION|MB_OK);
		return;
	}
	
	if( m_ListBox.GetCount() ) m_ListBox.GetSelItems(1, &index);
	m_ListBox.InsertString(index, m_NoText);
	m_ListBox.SetItemData(index, _nHugeValues);
	m_ListBox.SetSel(index, TRUE);
	m_ListBox.SetSel(index+1, FALSE);
	GotoDlgCtrl(GetDlgItem(IDC_LIST_FILE_AREAS));
	shouldSave = TRUE;
}

// clone the currently selected area
void CFileArea::OnMenuClone() 
{
	char  buf[80];
	int   index;

	if( 1 != m_ListBox.GetSelCount() ){
		CString msg;
		msg.LoadString(IDS_ERROR_CLONE);
		MessageBox(msg,m_Title,MB_OK|MB_ICONSTOP);
		return;
	}
	m_ListBox.GetSelItems(1, &index);
	m_ListBox.GetText(index, buf);
	m_ListBox.InsertString(index+1, buf);
	m_ListBox.SetItemData(index+1, _nHugeValues + m_ListBox.GetItemData(index));
	m_ListBox.SetCaretIndex(index+1, FALSE);
	m_ListBox.SetSel(index, FALSE);
	m_ListBox.SetSel(index+1, TRUE);
	GotoDlgCtrl(GetDlgItem(IDC_LIST_FILE_AREAS));
	shouldSave = TRUE;
}

// display current stardate
void CFileArea::OnMenuStardate() 
{
	char       s[80];
	CTime      t = CTime::GetCurrentTime();
	struct tm *tp = t.GetLocalTm();
	UINT       perCent;

	perCent = (UINT(tp->tm_hour)*3600
			  + tp->tm_min*60 + tp->tm_sec);
	perCent = perCent * 100 / 86400;

	sprintf(s, "Today's stardate is %02d%02d%03d.%02d",
		((tp->tm_year + 1900) / 100) + 1,
		(tp->tm_year + 1900) % 100,
		tp->tm_yday, (int)perCent);

	MessageBox(s, m_Title, MB_OK);
}

// called whenever the selection changes
// enable or disable the buttons here
void CFileArea::OnSelchangeListFileAreas() 
{
	CMenu *menu = GetMenu();

	// adjust the last selected item which will be
	// used as an anchor for the group move/sort
	// this will be the index where the items will be
	// moved to
	if( 0 == m_ListBox.GetSelCount() ){
		m_AnchorIndex = -1;
	}
	else{
		m_AnchorIndex = m_ListBox.GetCaretIndex();
	}

	// more than one item is selected
	if( 1 < m_ListBox.GetSelCount() ){
		if( 2 == m_ListBox.GetSelCount() ){
			GetDlgItem(IDC_BUTTON_SWAP)->EnableWindow(TRUE);
			menu->EnableMenuItem(IDR_MENU_SWAP, MF_ENABLED);
		}
		else{
			GetDlgItem(IDC_BUTTON_SWAP)->EnableWindow(FALSE);
			menu->EnableMenuItem(IDR_MENU_SWAP, MF_GRAYED);
		}
		GetDlgItem(IDC_BUTTON_SORT_SELECTED)->EnableWindow(TRUE);
		GetDlgItem(IDC_BUTTON_MOVE_SELECTED)->EnableWindow(TRUE);
		GetDlgItem(IDC_BUTTON_GLOBAL)->EnableWindow(TRUE);
		GetDlgItem(IDC_BUTTON_EDIT)->EnableWindow(FALSE);
		menu->EnableMenuItem(IDR_MENU_MOVE_UP, MF_GRAYED);
		menu->EnableMenuItem(IDR_MENU_MOVE_DOWN, MF_GRAYED);
		menu->EnableMenuItem(IDR_MENU_MOVE, MF_ENABLED);
		menu->EnableMenuItem(IDR_MENU_SORT_ASCENDING, MF_ENABLED);
		menu->EnableMenuItem(IDR_MENU_SORT_DESCENDING, MF_ENABLED);
		menu->EnableMenuItem(IDR_MENU_GLOBAL, MF_ENABLED);
		menu->EnableMenuItem(IDR_MENU_EDIT, MF_GRAYED);
		menu->EnableMenuItem(IDR_MENU_CLONE, MF_GRAYED);
	}
	else{ // one or none items are selected
		GetDlgItem(IDC_BUTTON_SORT_SELECTED)->EnableWindow(FALSE);
		GetDlgItem(IDC_BUTTON_MOVE_SELECTED)->EnableWindow(FALSE);
		GetDlgItem(IDC_BUTTON_GLOBAL)->EnableWindow(FALSE);
		GetDlgItem(IDC_BUTTON_SWAP)->EnableWindow(FALSE);
		GetDlgItem(IDC_BUTTON_EDIT)->EnableWindow(TRUE);
		menu->EnableMenuItem(IDR_MENU_MOVE, MF_GRAYED);
		menu->EnableMenuItem(IDR_MENU_SORT_ASCENDING, MF_GRAYED);
		menu->EnableMenuItem(IDR_MENU_SORT_DESCENDING, MF_GRAYED);
		menu->EnableMenuItem(IDR_MENU_GLOBAL, MF_GRAYED);
		menu->EnableMenuItem(IDR_MENU_MOVE_UP, MF_ENABLED);
		menu->EnableMenuItem(IDR_MENU_MOVE_DOWN, MF_ENABLED);
		menu->EnableMenuItem(IDR_MENU_SWAP, MF_GRAYED);
		menu->EnableMenuItem(IDR_MENU_EDIT, MF_ENABLED);
		menu->EnableMenuItem(IDR_MENU_CLONE, MF_ENABLED);

		// adjust the find item
		m_ListBox.GetSelItems(1, &m_FindIndex);
	}
}

// move currently selected area down
void CFileArea::OnButtonMoveDown() 
{
	int index;

	if( 1 == m_ListBox.GetSelCount() ){
		m_ListBox.GetSelItems(1, &index);
		if( index < m_ListBox.GetCount() - 1 ){
			char  buf[80];
			DWORD data;
			
			data = m_ListBox.GetItemData(index);
			m_ListBox.GetText(index, buf);
			m_ListBox.DeleteString(index);
			m_ListBox.InsertString(index+1, buf);
			m_ListBox.SetItemData(index+1, data);
			m_ListBox.SetCaretIndex(index+1, FALSE);
			m_ListBox.SetSel(index+1, TRUE);
			GotoDlgCtrl(GetDlgItem(IDC_LIST_FILE_AREAS));
			shouldSave = TRUE;
		}
	}
}

// moves one area up in the list
void CFileArea::OnButtonMoveUp() 
{
	int index;

	if( 1 == m_ListBox.GetSelCount() ){
		m_ListBox.GetSelItems(1, &index);
		if( 0 != index ){
			char  buf[80];
			DWORD data;

			m_ListBox.GetText(index, buf);
			data = m_ListBox.GetItemData(index);
			m_ListBox.DeleteString(index);
			m_ListBox.InsertString(index-1, buf);
			m_ListBox.SetItemData(index-1, data);
			m_ListBox.SetCaretIndex(index-1, FALSE);
			m_ListBox.SetSel(index-1, TRUE);
			GotoDlgCtrl(GetDlgItem(IDC_LIST_FILE_AREAS));
			shouldSave = TRUE;
		}
	}
}

// initialize the find dialog
void CFileArea::OnButtonFind() 
{
	
	if( FALSE == m_FindDlgInited ){
		CFindReplaceDialog *p = new CFindReplaceDialog;
		p->Create(TRUE, "", NULL, FR_DOWN|FR_HIDEWHOLEWORD, this);
		m_FindDlgInited = TRUE;
	}
	else MessageBeep(MB_ICONHAND);
}

// the callback function
LONG CFileArea::OnFindCall(WPARAM, LPARAM lParam)
{
	CFindReplaceDialog *p;
	static char lastRequest[80] = "";

	p = CFindReplaceDialog::GetNotifier(lParam);
	if( !p ) return 0;

	if( p->IsTerminating() ){
		p->DestroyWindow();
		m_FindDlgInited = FALSE;
		return 1;
	}

	// ok, we have a find criteria, use it
	int     i, nInc, anchor;
	char    buf[80];
	CString criteria = p->GetFindString(), match;

	// this is a new search
	if( 0 != criteria.Compare(lastRequest) ){
		strcpy(lastRequest, LPCTSTR(criteria));
		if( p->SearchDown() ) m_FindIndex = -1;
		else m_FindIndex = m_ListBox.GetCount();
	}

	// set the anchors
	if( p->SearchDown() ){
		if( m_ListBox.GetCount() <= m_FindIndex ) m_FindIndex = -1;
		i = m_FindIndex + 1;
		nInc = 1;
		anchor = m_ListBox.GetCount();
	}
	else{
		if( -1 == m_FindIndex ) m_FindIndex = m_ListBox.GetCount();
		i = m_FindIndex - 1;
		nInc = -1;
		anchor = -1;
	}

	// don't want case-sensitive, make it uppercase
	if( !p->MatchCase() ) criteria.MakeUpper();

	// scan through the whole list now
	for( ; i != anchor; i += nInc ){

		if( p->SearchDown() ){
			if( i == m_ListBox.GetCount() ) i = 0;
		}
		else{
			if( -1 == i ) i = m_ListBox.GetCount() - 1;
		}

		m_ListBox.GetText(i, buf);
		match = buf;
		if( !p->MatchCase() ) match.MakeUpper();

		if( -1 != match.Find(LPCTSTR(criteria)) ){
			m_FindIndex = i;
			m_ListBox.SetCaretIndex(i, FALSE);
			m_ListBox.SetSel(i, !m_ListBox.GetSel(i));
			GotoDlgCtrl(GetDlgItem(IDC_LIST_FILE_AREAS));
			return 1;
		}
	}

	//if we got here, there was no match
	criteria = p->GetFindString();	// restore the case (hehehe)
	char msg[255];

	sprintf(msg, "Could not find the string '%s'.", LPCTSTR(criteria));
	MessageBox(msg, m_Title, MB_OK|MB_ICONEXCLAMATION);
	return 0;
}

// process keys from the list box
int CFileArea::OnVKeyToItem(UINT nKey, CListBox* pListBox, UINT nIndex) 
{
	switch( nKey ){
		case VK_BACK  : OnMenuClear();  return -2;
		case VK_INSERT: OnMenuInsert(); return -2;
		case VK_DELETE: OnMenuDelete(); return -2;
		case VK_RETURN: OnMenuEdit();   return -2;
		default: break;
	}
	return CDialog::OnVKeyToItem(nKey, pListBox, nIndex);
}

// override to trap the Escape button
void CFileArea::OnCancel()
{
	OnMenuExit();
}

// edit the current selection in the list, if any
void CFileArea::OnMenuEdit() 
{
	int        index;
	DWORD      areaNum;
	TFileArea  area;
	CFile      file;
	char       path[_MAX_PATH];
	CString    msg;
	
	if( 1 != m_ListBox.GetSelCount() ){
		msg.LoadString(IDS_ERROR_NO_SELECT);
		MessageBox(msg, m_Title, MB_OK|MB_ICONEXCLAMATION);
		return;
	}

	m_ListBox.GetSelItems(1, &index);
	areaNum = m_ListBox.GetItemData(index);
	// is this area has been added, save to disk first
	if( _nHugeValues <= areaNum ){
		msg.LoadString(IDS_SAVE_FIRST);
		if( IDOK != MessageBox(msg, m_Title,MB_YESNO|MB_ICONQUESTION) )
			return;
		OnMenuSave();
		areaNum = m_ListBox.GetItemData(index);
	}
	// now load the area definition from the file
	sprintf(path, "%s\\FILECFG.PRO", m_SysPath);
	if(!file.Open(path,CFile::modeRead|CFile::shareDenyWrite)){
		msg.LoadString(IDS_ERROR_LOAD);
		MessageBox(msg, m_Title,MB_OK|MB_ICONSTOP);
		return;
	}
	file.Seek(areaNum * sizeof(TFileArea), CFile::begin);
	file.Read(&area, sizeof(area));
	file.Close();

	// now create the property sheet and display it
	CPropFileLoc   filePage;
	CPropFileFlag  flagPage;
	CPropFileGroup groupPage;
	CPropSecurity  securityPage;

	// remove the help button from the pages
	filePage.m_psp.dwFlags &= ~PSP_HASHELP;
	flagPage.m_psp.dwFlags &= ~PSP_HASHELP;
	groupPage.m_psp.dwFlags &= ~PSP_HASHELP;
	securityPage.m_psp.dwFlags &= ~PSP_HASHELP;

	// move data to the pages
	filePage.m_AreaName = area.name;
	filePage.m_AreaName.OemToAnsi();
	filePage.m_FileListPath = area.listpath;
	filePage.m_FileLocation = area.filepath;
	filePage.m_DateFormat = area.dateFormat;
	flagPage.m_CDROM = area.copyLocal;
	flagPage.m_Free = area.free;
	flagPage.m_Tops = BOOL(!area.notops);
	flagPage.m_MaxFiles = area.maxfiles;
	flagPage.m_MaxBytes = area.maxkb;
	securityPage.m_Age = area.minAge;
	securityPage.m_Level = area.level;
	// must implement security flags here
	if( 0 != area.groups[0] ){
		groupPage.m_CheckGroup1 = TRUE;
		groupPage.m_Value1 = area.groups[0] - 1;
	}
	if( 0 != area.groups[1] ){
		groupPage.m_CheckGroup2 = TRUE;
		groupPage.m_Value2 = area.groups[1] - 1;
	}
	if( 0 != area.groups[2] ){
		groupPage.m_CheckGroup3 = TRUE;
		groupPage.m_Value3 = area.groups[2] - 1;
	}
	if( 0 != area.groups[3] ){
		groupPage.m_CheckGroup4 = TRUE;
		groupPage.m_Value4 = area.groups[3] - 1;
	}
	groupPage.m_AllGroups = area.allGroups;
	
	// add the pages to the property sheet
	CPropertySheet propSheet(area.name);
	propSheet.m_psh.dwFlags |= PSH_NOAPPLYNOW;
	propSheet.m_psh.dwFlags &= ~PSH_HASHELP;
	propSheet.AddPage(&filePage);
	propSheet.AddPage(&securityPage);
	propSheet.AddPage(&flagPage);
	propSheet.AddPage(&groupPage);

	if( IDOK == propSheet.DoModal() ){
		filePage.m_AreaName.AnsiToOem();
		strcpy(area.name, filePage.m_AreaName);
		strcpy(area.listpath, filePage.m_FileListPath);
		strcpy(area.filepath, filePage.m_FileLocation);
		area.dateFormat = filePage.m_DateFormat;
		area.copyLocal = flagPage.m_CDROM;
		area.free = flagPage.m_Free;
		area.notops = !flagPage.m_Tops;
		area.maxfiles = flagPage.m_MaxFiles;
		area.maxkb = flagPage.m_MaxBytes;
		area.minAge = securityPage.m_Age;
		area.level = securityPage.m_Level;
		area.allGroups = groupPage.m_AllGroups;

		if( TRUE == groupPage.m_CheckGroup1 )
			area.groups[0] = (uchar)groupPage.m_Value1 + 1;
		else area.groups[0] = 0;
		if( TRUE == groupPage.m_CheckGroup2 )
			area.groups[1] = (uchar)groupPage.m_Value2 + 1;
		else area.groups[1] = 0;
		if( TRUE == groupPage.m_CheckGroup3 )
			area.groups[2] = (uchar)groupPage.m_Value3 + 1;
		else area.groups[2] = 0;
		if( TRUE == groupPage.m_CheckGroup4 )
			area.groups[3] = (uchar)groupPage.m_Value4 + 1;
		else area.groups[3] = 0;

		if(!file.Open(path,CFile::typeBinary|CFile::modeWrite)){
			msg.LoadString(IDS_ERROR_SAVE);
			MessageBox(msg, m_Title, MB_OK|MB_ICONSTOP);
			return;
		}
		file.Seek(areaNum * sizeof(TFileArea), CFile::begin);
		file.Write(&area, sizeof(area));
		file.Close();
		m_ListBox.DeleteString(areaNum);
		if( '\0' == area.name[0] ) m_ListBox.InsertString(areaNum, m_NoText);
		else m_ListBox.InsertString(areaNum, area.name);
		m_ListBox.SetItemData(areaNum, areaNum);
		m_ListBox.SetCaretIndex(areaNum, FALSE);
		m_ListBox.SetSel(areaNum, TRUE);
		GotoDlgCtrl(GetDlgItem(IDC_LIST_FILE_AREAS));
	}
}

void CFileArea::OnContextMenu(CWnd*, CPoint point) 
{
	CPoint local = point;
	ScreenToClient(&local);
	if( GetDlgItem(IDC_LIST_FILE_AREAS) == ChildWindowFromPoint(local) ){
		UINT  nEnable = MF_GRAYED;
		CMenu menu;

		menu.LoadMenu(IDR_MENU_LIST_POPUP);
		CMenu *popup = menu.GetSubMenu(0);
		ASSERT(NULL != popup);

		if( 1 == m_ListBox.GetSelCount() ) nEnable = MF_ENABLED;
		popup->EnableMenuItem(IDR_MENU_POPUP_CLONE, nEnable);
		popup->EnableMenuItem(IDR_MENU_POPUP_EDIT, nEnable);
		popup->TrackPopupMenu(TPM_LEFTALIGN|TPM_RIGHTBUTTON, point.x, point.y, this);
	}
}

void CFileArea::OnMenuSelectbyGroup() 
{
	CString msg;
	if( shouldSave ){
		msg.LoadString(IDS_SAVE_FIRST);
		if( IDOK != MessageBox(msg,m_Title,MB_YESNO|MB_ICONQUESTION) )
			return;
		OnMenuSave();
	}

	CSelectGroup *dlg = new CSelectGroup;
	if( dlg ){
		if( IDOK == dlg->DoModal() ){
			if( -1 == dlg->m_GroupNum && !dlg->m_SelectAll ){
				msg.LoadString(IDS_INVALID_GROUP);
				MessageBox(msg, m_Title,MB_OK|MB_ICONEXCLAMATION);
			}
			else{
				CFile file;
				char  path[_MAX_PATH];
				
				sprintf(path, "%s\\FILECFG.PRO", getenv("PROBOARD"));
				if( !file.Open(path,CFile::modeRead|CFile::typeBinary|CFile::shareDenyWrite) ){
					msg.LoadString(IDS_ERROR_LOAD);
					MessageBox(msg, m_Title,MB_OK|MB_ICONSTOP);
				}
				else{
					TFileArea area;

					OnMenuUnselect();
					UINT nBytes = file.Read(&area, sizeof(area));

					for(int i = 0; nBytes == sizeof(area); ++i){
						if( dlg->m_SelectAll && area.allGroups )
							m_ListBox.SetSel(i, TRUE);
						else if( dlg->m_GroupNum != -1 ) {
							for( int j = 0; j < 4; ++j ){
								if( area.groups[j] == dlg->m_GroupNum + 1 ){
									m_ListBox.SetSel(i, TRUE);
									break;
								}
							}
						}
						nBytes = file.Read(&area, sizeof(area));
					}
					file.Close();
				}
			}
		}
		delete dlg;
	}
	// see if we need to adjust the buttons and commands
	OnSelchangeListFileAreas();
	m_ListBox.SetCaretIndex(m_ListBox.GetCaretIndex(), 0);
}

void CFileArea::OnMenuSelectbyLevel() 
{
	CString msg;

	if( shouldSave ){
		msg.LoadString(IDS_SAVE_FIRST);
		if( IDOK != MessageBox(msg,m_Title,MB_YESNO|MB_ICONQUESTION) )
			return;
		OnMenuSave();
	}

	CSelectLevel *dlg = new CSelectLevel;
	if( dlg ){
		if( IDOK == dlg->DoModal() ){
			CFile     file;
			TFileArea area;
			char      path[_MAX_PATH];

			sprintf(path, "%s\\FILECFG.PRO", getenv("PROBOARD"));
			if( !file.Open(path, CFile::modeRead|CFile::typeBinary|CFile::shareDenyWrite) ){
				msg.LoadString(IDS_ERROR_LOAD);
				MessageBox(msg,m_Title,MB_OK|MB_ICONSTOP);

			}
			else{
				OnMenuUnselect();
				UINT nBytes = file.Read(&area, sizeof(area));
				for(int i = 0; nBytes == sizeof(area); ++i){
					if( area.level == dlg->m_Level ){
						m_ListBox.SetSel(i, TRUE);
					}
					else if( area.level < dlg->m_Level ){
						if( 1 == dlg->m_MatchLevel ) m_ListBox.SetSel(i, TRUE);
					}
					else{
						if( 2 == dlg->m_MatchLevel ) m_ListBox.SetSel(i, TRUE);
					}
					nBytes = file.Read(&area, sizeof(area));
				}
				file.Close();
			}
		}
		delete dlg;
	}
	// see if we need to adjust the buttons and commands
	OnSelchangeListFileAreas();
	m_ListBox.SetCaretIndex(m_ListBox.GetCaretIndex(), 0);
}

void CFileArea::OnMenuTipOfDay() 
{
	CTipDlg dlg;
	dlg.DoModal();
}

void CFileArea::OnMenuSelectbyType() 
{
	CString msg;

	if( shouldSave ){
		msg.LoadString(IDS_SAVE_FIRST);
		if( IDOK != MessageBox(msg,m_Title,MB_YESNO|MB_ICONQUESTION) )
			return;
		OnMenuSave();
	}

	CSelectType *dlg = new CSelectType;
	if( dlg ){
		if( IDOK == dlg->DoModal() ){
			CFile     file;
			TFileArea area;
			char      path[_MAX_PATH];

			sprintf(path, "%s\\FILECFG.PRO", getenv("PROBOARD"));
			if( !file.Open(path, CFile::modeRead|CFile::typeBinary|CFile::shareDenyWrite) ){
				msg.LoadString(IDS_ERROR_LOAD);
				MessageBox(msg,m_Title,MB_OK|MB_ICONSTOP);

			}
			else{
				OnMenuUnselect();
				UINT nBytes = file.Read(&area, sizeof(area));
				for(int i = 0; nBytes == sizeof(area); ++i){
					BOOL mustSelect = FALSE;
					
					// the flags have three states: on/off/don't care
					// we also have two boolean operations: or/and

					// we want CD-ROM areas, and this is one
					// or non-CDROM areas and this is one
					if( (0 == dlg->m_CDROM && area.copyLocal) ||
					    (1 == dlg->m_CDROM && !area.copyLocal) )
					{
						mustSelect = TRUE;
					}
					
					// we want free areas and this is one
					// or non-free areas (and this is one)
					if( (0 == dlg->m_Free && area.free) ||
					    (1 == dlg->m_Free && !area.free) )
					{
						// AND mode, no previous match and no ignore on first
						if( 1 == dlg->m_Or && !mustSelect && 2 != dlg->m_CDROM)
						{
							;// skip
						}
						else mustSelect = TRUE;
					}
					
					// we want areas included in tops and this is one
					// or excluded from the tops and this is one
					if( (0 == dlg->m_Tops && !area.notops) ||
					    (1 == dlg->m_Tops && area.notops) )
					{
						// AND mode, no previous match and no ignore on either of first 2
						if( 1 == dlg->m_Or && !mustSelect &&
							2 != dlg->m_CDROM && 2 != dlg->m_Free)
						{
							; // skip
						}
						else mustSelect = TRUE;
					}
					
					if( mustSelect ) m_ListBox.SetSel(i, TRUE);
					nBytes = file.Read(&area, sizeof(area));
				}
				file.Close();
			}
		}
		delete dlg;
	}
	// see if we need to adjust the buttons and commands
	OnSelchangeListFileAreas();
	m_ListBox.SetCaretIndex(m_ListBox.GetCaretIndex(), 0);
}

// global changes (must have areas selected)
void CFileArea::OnButtonGlobal() 
{
	CString     msg;
	CGlobalFile dlg;

	if( shouldSave ){
		msg.LoadString(IDS_SAVE_FIRST);
		if( IDOK != MessageBox(msg, m_Title, MB_YESNO|MB_ICONQUESTION) )
			return;
		OnMenuSave();
	}

	if( IDOK == dlg.DoModal() ){
		CFile file;
		char  path[_MAX_PATH];

		sprintf(path, "%s\\FILECFG.PRO", getenv("PROBOARD"));
		if( !file.Open(path, CFile::modeReadWrite|CFile::typeBinary|CFile::shareDenyWrite) ){
			msg.LoadString(IDS_ERROR_LOAD);
			MessageBox(msg, m_Title, MB_OK|MB_ICONSTOP);
			return;
		}

		CProgressDlg progress;
		progress.Create(this);
		progress.SetRange(0, m_ListBox.GetCount());
		progress.SetStep(1);

		for( int i = 0; i < m_ListBox.GetCount(); ++i ){
			CString name;
			m_ListBox.GetText(i, name);
			progress.SetStatus(name);
			progress.StepIt();

			if( m_ListBox.GetSel(i) ){
				TFileArea area;
				CString   s;
				int       nPos;

				file.Seek((long)i * sizeof(area), CFile::begin);
				file.Read(&area, sizeof(TFileArea));


				// check the replacement texts
				if( dlg.m_CheckListEdit ){
					s = area.listpath;
					nPos = s.Find(dlg.m_ListReplace);
					if( -1 != nPos ){
						CString slp = s.Left(nPos);
						slp += dlg.m_ListWith;
						slp += s.Right(s.GetLength() - nPos - dlg.m_ListReplace.GetLength());
						strncpy(area.listpath, slp, sizeof(area.listpath));
						area.listpath[sizeof(area.listpath)-1] = '\0';
					}
				}
				if( dlg.m_CheckFileLocation ){
					s = area.filepath;
					nPos = s.Find(dlg.m_LocationReplace);
					if( -1 != nPos ){
						CString slp = s.Left(nPos);
						slp += dlg.m_LocationWith;
						slp += s.Right(s.GetLength() - nPos - dlg.m_LocationReplace.GetLength());
						strncpy(area.filepath, slp, sizeof(area.filepath));
						area.filepath[sizeof(area.filepath)-1] = '\0';
					}
				}

				// check the access control restrictions
				if( dlg.m_CheckMinAge ) area.minAge = dlg.m_MinAge;
				if( dlg.m_CheckMaxFiles ) area.maxfiles = dlg.m_MaxFiles;
				if( dlg.m_CheckMaxBytes ) area.maxkb = dlg.m_MaxBytes;
				if( dlg.m_CheckLevel ) area.level = dlg.m_Level;

				// check the flag settings
				if( 2 != dlg.m_AllGroups ) area.allGroups = dlg.m_AllGroups;
				if( 2 != dlg.m_CDROM ) area.copyLocal = dlg.m_CDROM;
				if( 2 != dlg.m_Tops ) area.notops = !dlg.m_Tops;
				if( 2 != dlg.m_Free ) area.free = dlg.m_Free;

				// check for new group numbers
				if( dlg.m_CheckGroup1 ) area.groups[0] = (uchar)dlg.m_Group1 + 1;
				if( dlg.m_CheckGroup2 ) area.groups[1] = (uchar)dlg.m_Group2 + 1;
				if( dlg.m_CheckGroup3 ) area.groups[2] = (uchar)dlg.m_Group3 + 1;
				if( dlg.m_CheckGroup4 ) area.groups[3] = (uchar)dlg.m_Group4 + 1;

				file.Seek((long)i * sizeof(area), CFile::begin);
				file.Write(&area, sizeof(TFileArea));
			}
		}
		file.Close();
	}
}

void CFileArea::OnButtonMoveSelected() 
{
	int index = m_AnchorIndex;

	if( -1 == m_AnchorIndex ){
		CString msg, title;

		msg.LoadString(IDS_MOVE_SELECTED);
		title.LoadString(IDS_TITLE);
		MessageBox(msg, title, MB_OK|MB_ICONEXCLAMATION);
		return;
	}

	for( int i = 0; i < m_ListBox.GetCount(); ++i ){
		if( m_ListBox.GetSel(i) ){	// the item is selected
			// move it to the index position
			CString text;
			DWORD data;
			
			data = m_ListBox.GetItemData(i);
			m_ListBox.GetText(i, text);
			m_ListBox.DeleteString(i);
			if( i < index ){
				index--;	// adjust insertion point
				m_AnchorIndex--;	// adjust focus
			}
			m_ListBox.InsertString(index, text);
			m_ListBox.SetItemData(index, data);
			--i;		// will get ++ to the same item
			++index;	// index moves to next position
		}
	}
	// indicate changes have been made, focus, etc.
	shouldSave = TRUE;
	m_ListBox.SetCaretIndex(m_AnchorIndex, 0);
	m_ListBox.SetSel(m_AnchorIndex, TRUE);
	m_AnchorIndex = -1;
	GotoDlgCtrl(GetDlgItem(IDC_LIST_FILE_AREAS));
	OnSelchangeListFileAreas();
}

// pop up a menu to prompt for the direction and
// excute the necessary routine
void CFileArea::OnButtonSortSelected() 
{
	CMenu menu;
	CRect rect;

	GetDlgItem(IDC_BUTTON_SORT_SELECTED)->GetWindowRect(&rect);
	menu.LoadMenu(IDR_MENU_SORT_POPUP);
	CMenu *popup = menu.GetSubMenu(0);
	ASSERT(NULL != popup);

	popup->TrackPopupMenu(TPM_RIGHTALIGN|TPM_RIGHTBUTTON,
			rect.TopLeft().x, rect.BottomRight().y, this);
}

void CFileArea::MoveSorted(BOOL ascending)
{
	CSortWait prog;
	int       index = m_AnchorIndex;

	if( -1 == m_AnchorIndex ){
		CString msg, title;

		msg.LoadString(IDS_MOVE_SELECTED);
		title.LoadString(IDS_TITLE);
		MessageBox(msg, title, MB_OK|MB_ICONEXCLAMATION);
		return;
	}

	prog.Create(this);
	prog.m_Progress.SetRange(0, m_ListBox.GetCount() - 1);

	for( int i = 0; i < m_ListBox.GetCount(); ++i ){

		prog.StepIt();

		if( m_ListBox.GetSel(i) ){	// the item is selected
			// move it to the index position, 
			CString text;
			DWORD data;
			
			data = m_ListBox.GetItemData(i);
			m_ListBox.GetText(i, text);
			m_ListBox.DeleteString(i);
			if( i < index ){
				index--;	// adjust insertion point
				m_AnchorIndex--;	// adjust focus
			}

			// find a place to insert the string between
			// the starting position m_AnchorIndex and the
			// last point of insertion, index. This depends
			// on the value of 'ascending'
			for( int j = m_AnchorIndex; j <= index; ++j ){
				CString curText;
				m_ListBox.GetText(j, curText);
				int nStat = text.CompareNoCase(curText);

				if( (j == index) ||
					(1 == nStat && !ascending) ||
					(-1 == nStat && ascending) ||
					(0 == nStat) )
				{
					m_ListBox.InsertString(j, text);
					m_ListBox.SetItemData(j, data);
					break;
					
				}
			}
			--i;		// will get ++ to the same item
			++index;	// index moves to next position
		}
	}
	// indicate changes have been made, focus, etc.
	shouldSave = TRUE;
	m_ListBox.SetCaretIndex(m_AnchorIndex, 0);
	m_ListBox.SetSel(m_AnchorIndex, TRUE);
	m_AnchorIndex = -1;
	GotoDlgCtrl(GetDlgItem(IDC_LIST_FILE_AREAS));
	OnSelchangeListFileAreas();
}

// the simple handlers for the menu commands
// the both call the sorting routine with direction
void CFileArea::OnMenuSortAscending() 
{
	MoveSorted(TRUE);
}

void CFileArea::OnMenuSortDescending() 
{
	MoveSorted(FALSE);
}

