// AreaTools.cpp : implementation file
//

#include "stdafx.h"
#include "FileCFG.h"
#include "AreaTools.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CAreaTools

CAreaTools::CAreaTools():
	m_pTButtons(NULL)
{
}

CAreaTools::~CAreaTools()
{
	if( m_pTButtons ) delete m_pTButtons;
}


BEGIN_MESSAGE_MAP(CAreaTools, CToolBarCtrl)
	//{{AFX_MSG_MAP(CAreaTools)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

BOOL CAreaTools::Create(DWORD dwStyle, const RECT &rect, CWnd *pParent, UINT nID)
{
	static const int nButtons = 6;

	BOOL bRet = CToolBarCtrl::Create(dwStyle, rect, pParent, nID);

	// load the bitmap
	VERIFY(-1 != AddBitmap(6, IDB_BITMAP_TOOLBAR));
	// load the buttons
	m_pTButtons = new TBBUTTON[nButtons];
	for(int nIndex = 0; nIndex < nButtons; ++nIndex){
		m_pTButtons[nIndex].iString = NULL;
		m_pTButtons[nIndex].fsState = TBSTATE_ENABLED;
		m_pTButtons[nIndex].fsStyle = TBSTYLE_BUTTON;
		m_pTButtons[nIndex].dwData = 0;
		m_pTButtons[nIndex].iBitmap = nIndex;
		m_pTButtons[nIndex].idCommand = ID_TOOLBAR_COMMAND + nIndex;
	}
	VERIFY(0 != AddButtons(nButtons, m_pTButtons));

	return bRet;
}