(*********************************************************************)
(*********************************************************************)
(** FCTEST.PAS - Test unit for the TASP Development Delphi ***********)
(** (tnx Borland!!!) File Copy Component. ****************************)
(*********************************************************************)
(*********************************************************************)
(*                                                             *******)
(* The TASP Filecopy Component is a product of:                *******)
(*                                                             *******)
(* Daniel J. Karnes                                            *******)
(* 9942 W. Broadway Suite 209                                  *******)
(* Anaheim, CA 92804                                           *******)
(*                                                             *******)
(* Email: TASP@TASP.NET  or  TASPEngr@AOL.COM                  *******)
(*                                                             *******)
(* FCTEST and FILECOPY are distributed as try-before-you-buy   *******)
(* SHAREWARE. Registration is expected if you continue using   *******)
(* this TASP Development product beyond a free 7 days period   *******)
(* of evaluation. Please support SHAREWARE and we'll all win!  *******)
(*                                                             *******)
(* REGISTRATION FEES:                                          *******)
(*                                                             *******)
(* $15.00 - Single user. NON COMMERCIAL.                       *******)
(*                                                             *******)
(* $27.00 - Shareware author's license.                        *******)
(*                                                             *******)
(* $79.00 - Commercial license.                                *******)
(*                                                             *******)
(* All others must email for a quote before using.             *******)
(*                                                             *******)
(* Please register today! You'll get a laser printed manual    *******)
(* and reference along with a registered copy of the product   *******)
(* (no nagware notice and more features & speed!) on disk or   *******)
(* via email if you specify.                                   *******)
(*                                                             *******)
(* Send registrations to:                                      *******)
(*                                                             *******)
(* Daniel J. Karnes                                            *******)
(* 9942 W. Broadway Suite 209                                  *******)
(* Anaheim, CA 92804                                           *******)
(*                                                             *******)
(* *** IF EVERYONE SUPPORTS SHAREWARE WE'LL ALL MAKE OUT!! *** *******)
(*                                                             *******)
(*******                                                       *******)
(*******           DISCLAIMER AND COPYRIGHT NOTICE             *******)
(*******                                                       *******)
(*                                                             *******)
(* Using this example program or any other part of this        *******)
(* software is agreeing to not holding the author thereof to   *******)
(* any form of warranty or guarantee whether expressed or      *******)
(* implied. Continuing to use this example program or any      *******)
(* part of the accompanying software is also agreement that    *******)
(* compiling and or implementing any part of this program is   *******)
(* an action that any user will be undertaking at the users    *******)
(* own personal risk and liability.                            *******)
(*                                                             *******)
(* Any user of this example program or any other part of this  *******)
(* original distribution is expressely agreeing to all terms   *******)
(* and conditions stated by the author if the user implements  *******)
(* any part of this software in any way.                       *******)
(*                                                             *******)
(* WHEW! And my attorney even likes it! ;)  I just hope that   *******)
(* *you* like the software!                                    *******)
(*                                                             *******)
(* Let me know if you like it. (the SOFTWARE!) Think it sucks  *******)
(* Or want more!                                               *******)
(*                                                             *******)
(* djk@TASP.NET / TASP@TASP.NET / TASPEngr@AOL.COM             *******)
(*                                                             *******)
(* Send registrations to:                                      *******)
(*                                                             *******)
(* Daniel J. Karnes                                            *******)
(* 9942 W. Broadway Suite 209                                  *******)
(* Anaheim, CA 92804                                           *******)
(*                                                             *******)
(* Of course comments and suggestions are solicited!           *******)
(*                                                             *******)
(*********************************************************************)
(*********************************************************************)
(*********************************************************************)
(*********************************************************************)

UNIT Fctest;

INTERFACE

USES
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, Filecopy;

TYPE
  TTestProgram = Class(TForm)
    FileCopy1: TFileCopy;
    procedure FormActivate(Sender: TObject);
    procedure FormCloseQuery(Sender: TObject; var CanClose: Boolean);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
  private
    { Private declarations }
  public
    { Public declarations }
    procedure FComplete(var Sender : TObject); message fc_CopyComplete;
    procedure FCError(var Message : TMessage); message fc_ErrorDetected;
  end;

VAR TestProgram: TTestProgram;

CONST
  RegisterTASPFileCopyToday : TCloseAction = caFree; {NOT!}

IMPLEMENTATION

{$R *.DFM}

Procedure TTestProgram.FormActivate(Sender: TObject);
BEGIN
  FileCopy1.Source:=('c:\temp\source.zip');  { set the source file }
  FileCopy1.Target:=('c:\temp\target.zip');  { set the target file }
   MyFrigginHandle:=(Handle);       { let FileCopy know your windows handle! }
  FileCopy1.SaveAttribs:=(True);    { manually set some properties..}
  FileCopy1.CheckDiskSpace:=(True); { " " }
  FileCopy1.CRCCheck:=(True);       { " " }
  FileCopy1.HourGlass:=(True);      { " " }
  FileCopy1.CopyFiles(Sender);      { call the copy routines! }
END;

Procedure TTestProgram.FComplete(var Sender : TObject);
BEGIN
  Close;                            { one guess.. }
END;

Procedure TTestProgram.FormCloseQuery(Sender: TObject; var CanClose: Boolean);
BEGIN
  CanClose:=(RegisterTASPFileCopyToday=caFree); {good idea!}
END;

Procedure TTestProgram.FormClose(Sender: TObject; var Action: TCloseAction);
BEGIN
  Action:=(RegisterTASPFileCopyToday); {another good idea!}
END;

Procedure TTestProgram.FCError(var Message : TMessage);
Var s : String;
BEGIN

s:='';

  CASE Message.wParam OF

    1 : begin
         s:='File Already Exists!';
        end;
    2 : begin
          s:='Disk Full.';
        end;
    3 : begin
          s:='CRC Test Failed.';
        end;
    4 : begin
          s:='Source file not found!';
        end;
    5 : begin
          s:='Target file already exists!';
        end;

 end;

IF (s>'') THEN
BEGIN
 MessageBeep(mb_IconAsterisk);
 MessageDlg(s,mtError,[mbOk],0);
 Halt(2);
END;

END;

END.
