/*****************************************************************************/
/*  FBclean   OS/2-Rexx   Makes a Batch to delete old Files of Your FileBase */
/*    needs in same DIR:  larc.bb2                                           */
/*          in PATH DIR:  unzip unarj Lh2 Arc2 Zoo Rar2                      */
/*  FileBaseClean Usage:  FBclean [DIRectory] [DIR] ...  >> delZIP.cmd       */
/*****************************************************************************/
        verboseListBOOL = 1
       recursivDIRsBOOL = 1
        sameNameMinimum = 3
       sameFilesMinimum = 70/100
/******************************************************************************
 *      verboseListBOOL:  if =1 then files of <ZIP>File are listed
 *     recursivDIRsBOOL:  if =1 then all sub-directories are proved!
 *      sameNameMinimum:  Minimum same first letters of two <ZIP>Names
 *                        for to indicate to test these two <ZIP>Files
 *     sameFilesMinimum:  Minimum % same files indicating ":del <ZIP>File"
 *                 <ZIP>  is any file of which FBclean knows how to list it!
 *****************************************************************************/
if rxfuncquery('SysLoadFuncs')=1 then do; call RxFuncAdd "SysLoadFuncs", "REXXUTIL", "SysLoadFuncs"; call SysLoadFuncs; end
   delZIP_BATCH = stdout    /*    SysTempFileName( "C:\delZIP??.cmd" )       */
                            /*    delZIP_BATCH:  resulting Batch-File        */
   SIGNAL on ERROR name ErrorSUBR
   address 'CMD' '@echo off'
   if recursivDIRsBOOL=1 then sftOpt='FST' ; else sftOpt='FT'
   parse source . . thisRexx ; thisPath=filespec('D',thisRexx)||filespec('P',thisRexx)
   ret = LarcBB2_PROC( thisPath||'larc.bb2') ; if ret<>0 then do ; call lineout stderr, ' ERROR larc.bb2: ' ret ; SIGNAL cleanupMARKE ; end
   arg Verzeichnisse ; Verzeichnisse = strip( Verzeichnisse)
   if pos('?',Verzeichnisse)>0 | pos('-H',Verzeichnisse)>0 | pos('/H',Verzeichnisse)>0 then do ; call lineout stderr, 'Help: Top of 'thisRexx ; return 0 ; end
   k=0 ; verz.0=0
   do while Verzeichnisse<>''
      k=k+1
      parse var Verzeichnisse verz.k Verzeichnisse
      verz.0=k
   end
   if verz.0=0 then do ; verz.0=1 ; verz.1= directory() ; end
   key. = d2c( 255) ; key.0=0
   do i=1 to verz.0
      verz.i = strip(verz.i)
      verz.i = strip(verz.i, 'T','\') || '\*'
      call SysFileTree verz.i , '_pnam.' , sftOpt
      do j=1 to _pnam.0
         parse var _pnam.j _dati sizy attry _pnam.j
         if left(_dati,2)<70 then _dati = '20' || _dati ; else _dati = '19' || _dati
         _pnam.j = strip(_pnam.j)
         _zipy = whatArcPROC( _pnam.j)
         if _zipy > 0 then do
            _fnam = translate( filespec( 'N', _pnam.j))
            do k=1 to key.0+1
               if _fnam < key.k.fnam then do
                  call insertkeyPROC k, _zipy, _dati, _fnam, _pnam.j
                  leave k
               end
            end
         end
      end
   end
   do i=1 to key.0 ; call listinPROC i, key.i.arcN ; end
   do i=1 to key.0-1
      key.i.max =0
      if key.i.delBOOL then NOP
      else do
         do j=i+1 to key.0
            if key.j.delBOOL then iterate j
            key.j.same = 0
            if left(key.i.fnam, sameNameMinimum)<>left(key.j.fnam, sameNameMinimum) then leave j
            else do
               do k=1 to key.i.znam.0
                  do l=1 to key.j.znam.0
                     if key.i.znam.k = key.j.znam.l then do
                        key.j.same = key.j.same+2
                        leave l
                     end
                  end
               end
            end
            if key.i.max<key.j.same then key.i.max=key.j.same
         end
         do j=i+1 to key.0
            if key.j.same = key.i.max then do
               if key.j.delBOOL then iterate j
               gesamt = (key.i.znam.0+key.j.znam.0) ; if gesamt=0 then gesamt=1
               if sameFilesMinimum <= key.j.same/gesamt then do
                  call linyOutPROC delZIP_BATCH, i, j
               end
               leave j
            end
         end
      end
   end
cleanupMARKE:
   if stream( delZIP_BATCH, 'C', 'query exists')<>'' then do
      call lineout delZIP_BATCH
      call lineout stderr, '         FBclean: ' date('E') time() delZIP_BATCH
   end
   call beep 1111, 111
   address 'CMD' '@echo on'
return 0

ErrorSUBR:
   call lineout stderr, '      Linenumber: ' sigl
   call lineout stderr, '       Errorname: ' condition('C')
   call lineout stderr, 'Errordescription: ' condition('D')
   if stream( delZIP_BATCH, 'C', 'query exists')<>'' then do
      call lineout delZIP_BATCH
      call lineout stderr, '         FBclean: ' date('E') time() delZIP_BATCH
   end
   call beep 411, 211
   call beep 211, 211
   address 'CMD' '@echo on'
EXIT 99

linyOutPROC: procedure expose verboseListBOOL key.
   arg delZIP_BATCH, i, j
   same = key.j.same
   gesamt = key.i.znam.0 + key.j.znam.0
   call lineout delZIP_BATCH, ':'
   if key.j.dati < key.i.dati then do
      call lineout delZIP_BATCH, ':WARNING FileNames indicate:  del' key.i.Pnam
      some=i ; i=j ; j=some
   end
   key.i.delBOOL =1
   parse var key.i.dati year '/' month '/' day '/' zeit
   daty.i = day||'.'||month||'.'||right(year,2)
   parse var key.j.dati year '/' month '/' day '/' zeit
   daty.j = day||'.'||month||'.'||right(year,2)
   call lineout delZIP_BATCH, ':del' key.i.Pnam
   call lineout delZIP_BATCH, left( '@REM same files: ' same'/'gesamt, 31) daty.i '-' daty.j key.j.Pnam
   if verboseListBOOL=1 then do
      do k=1 to key.i.znam.0
         do l=1 to key.j.znam.0 ; if key.i.znam.k = key.j.znam.l then leave l ; end
         if l>key.j.znam.0 then call lineout delZIP_BATCH, '@REM' right( key.i.znam.k key.i.zdat.k, 35)
      end
      do k=1 to key.j.znam.0
         liny = left('@REM', 42)
         do l=1 to key.i.znam.0
            if key.j.znam.k = key.i.znam.l then do
               liny = '@REM' right( key.i.znam.l key.i.zdat.l, 35) '-'
               leave l
            end
         end
         call lineout delZIP_BATCH, liny left( key.j.zdat.k, 8) key.j.znam.k
      end
   end
return -1

insertkeyPROC: procedure expose key.
   arg k, _zipy, _dati, _fnam, _pnam
   do i=key.0 to k by -1
      j=i+1
      key.j.arcN = key.i.arcN
      key.j.dati = key.i.dati
      key.j.fnam = key.i.fnam
      key.j.Pnam = key.i.Pnam
      key.j.same = 0
      key.j.delBOOL=0
   end
   key.k.delBOOL = 0
   key.k.same = 0
   key.k.arcN = _zipy
   key.k.dati = _dati
   key.k.fnam = _fnam
   key.k.Pnam = _pnam
   key.0 = key.0+1
return 0

ListinPROC: procedure expose ARC. key.
   arg k, zipy
   do while queued() > 0 ; pull some; end
   address 'CMD' ARC.listAF.zipy key.k.Pnam' | rxqueue'
   do z= 1 to queued()
      parse pull vdkey
      if pos( ARC.AStrng.zipy , vdkey)>0 then leave z
   end
   listAnfBOOL=0; EndBOOL=0
   z = 0
   do while queued() > 0
      parse pull vdkey
      if words( vdkey)=1 then do
         parse pull wkey
         vdkey = vdkey wkey
      end
      if pos( ARC.Estrng.zipy, vdkey)>0 then EndBOOL = 1
      else if EndBOOL=0 then do
         zfnam = word( vdkey, ARC.nameNr.zipy)
         zfnam = translate( zfnam, '\ ', '/+', '\')
         if right( zfnam ,1) ='\' then NOP
         else do
            z = z + 1
            zfnam = filespec( 'N' , zfnam)
            key.k.znam.z = translate( strip( zfnam))
            key.k.zdat.z = word( vdkey, ARC.dateNr.zipy)
            if ARC.dWords.zipy>1 then key.k.zdat.z = key.k.zdat.z||word( vdkey, ARC.dateNr.zipy+1)
            if ARC.dWords.zipy>2 then key.k.zdat.z = key.k.zdat.z||word( vdkey, ARC.dateNr.zipy+2)
            key.k.zdat.z = translate( key.k.zdat.z, '...', '/-'||'20'x )
         end
      end
   end
   key.k.znam.0 = z
return 0

LarcBB2_PROC: procedure expose ARC.
   parse arg larc_bb2FILE
   nrecord = strip( linein( larc_bb2FILE))
   ARC.ext.0 =0; liny_0 = 1
   ARC.maxfirstBytes = 32
   do while lines( larc_bb2FILE)
      do i=1 to nrecord
         do until firstByte <> ';'
            liny = linein( larc_bb2FILE)
            liny_0 = liny_0 +1
            firstByte = left( liny,1)
            if lines(larc_bb2FILE)=0 then do
               call stream larc_bb2FILE, 'C', 'CLOSE'
               RETURN 0
            end
         end
         liny =strip( liny,'T')
         if liny=='' | liny='-1' then liny='@echo Function not found:  '
         select
            when i=2 then do
                           ARC.ext.0 =ARC.ext.0+1
                           Nr = ARC.ext.0
                           ARC.ext.Nr    =liny
            end
            when i=3  then do
               ARC.offset.Nr =(liny) +1
               if datatype( ARC.offset.Nr, 'W') then do
                  if ARC.offset.Nr+10>ARC.maxfirstBytes then ARC.maxfirstBytes = ARC.offset.Nr+10
               end
            end
            when i=4  then ARC.listAF.Nr =liny
            when i=14 then do
                           idy = liny
                           parse var idy vor '\x' x.1 '\x' x.0 '\x' x.3 '\x' x.4
                           ARC.identity.Nr = vor ||x2c(x.1) ||x2c(x.0) ||x2c(x.3) ||x2c(x.4)
                           ARC.identity.Nr = strip( ARC.identity.Nr,'T', '00'x )
            end
            when i=15 then ARC.AStrng.Nr =liny
            when i=16 then ARC.Estrng.Nr =liny
            when i=17 then ARC.sizeNr.Nr =liny +1
            when i=19 then ARC.dateNr.Nr =liny +1
            when i=20 then ARC.dWords.Nr =liny
            when i=21 then ARC.nameNr.Nr =liny +1
            otherwise NOP
         end
      end
      if datatype(ARC.nameNr.Nr,'W')= 0 then return liny_0
   end
return 0

whatArcPROC: procedure expose ARC.
   arg wArchivFile
   firstBytes = charin(wArchivFile,1, ARC.maxfirstBytes)
   call stream wArchivFile ,'C','Close'
   do x=1 to ARC.ext.0
      if pos( ARC.identity.x ,firstBytes)=ARC.offset.x then leave x
   end
   if x>ARC.ext.0 then x=0
return x



