/*
 *      **************************************************************
 *       JdeBP C++ Library Routines      General Public Licence v1.00
 *          Copyright (c) 1991,1992  Jonathan de Boyne Pollard
 *      **************************************************************
 *
 * PORT I/O and DOS/BIOS INTERRUPTS (MS-DOS)
 *
 */

#if !defined(___PORTINT_H_INCLUDED)

//
// manifest constants for _hardresume result parameter
//
#define _HARDERR_IGNORE     0   /* Ignore the error */
#define _HARDERR_RETRY      1   /* Retry the operation */
#define _HARDERR_ABORT      2   /* Abort program issuing Interrupt 23h */
#define _HARDERR_FAIL       3   /* Fail the system call in progress */
                    /* _HARDERR_FAIL is not supported on DOS 2.x */

//
//  Register packs
//
#ifndef _REGS_DEFINED
struct  WORDREGS {
    unsigned int    ax, bx, cx, dx, si, di, cflag, flags;
};
struct  BYTEREGS {
    unsigned char   al, ah, bl, bh, cl, ch, dl, dh;
};
struct  SREGS   {
    unsigned int    es, cs, ss, ds;
};
union   REGS    {
    struct  WORDREGS x;
    struct  BYTEREGS h;
};
struct  REGPACK {
    unsigned    r_ax, r_bx, r_cx, r_dx;
    unsigned    r_bp, r_si, r_di, r_ds, r_es, r_flags;
};
#define _REGS_DEFINED
#endif

extern "C" {

int         _CDECL  bdos        (int, unsigned int, unsigned int);
void        _CDECL  (_disable)  (void);
void        _CDECL  (_enable)   (void);
void        _CDECL  _harderr    (void (_far *)());
void        _CDECL  _hardresume (int);
void        _CDECL  _hardretn   (int);
int         _CDECL  intdos      (union REGS *, union REGS *);
int         _CDECL  intdosx     (union REGS *, union REGS *, struct SREGS *);
int         _CDECL  int86       (int, union REGS *, union REGS *);
int         _CDECL  int86x      (int, union REGS *, union REGS *, struct SREGS *);
void        _CDECL  segread     (struct SREGS *);

int         _CDECL  (inp)   (unsigned);
unsigned    _CDECL  (inpw)  (unsigned);
int         _CDECL  (outp)  (unsigned, int);
unsigned    _CDECL  (outpw) (unsigned, unsigned);

#if __BORLANDC__
unsigned char   _CDECL  inportb (int);
unsigned int    _CDECL  inport  (int);
void            _CDECL  outportb    (int, unsigned char);
void            _CDECL  outport     (int, unsigned int);
#endif

#if __BORLANDC__
//
// Borland C uses a system whereby __double_underscore_functions__ are
// expanded to inline code by the compiler.
//
void        _CDECL      __emit__    (unsigned char __byte, ...);
void        _CDECL      __cli__     (void);
void        _CDECL      __sti__     (void);
void        _CDECL      __int__     (int);
unsigned char   _CDECL  __inportb__ (int);
unsigned int    _CDECL  __inportw__ (int);
void        _CDECL      __outportb__(int, unsigned char);
void        _CDECL      __outportw__(int, unsigned int);
#endif

}

//
//  Macro Overrides
//

#if __BORLANDC__
#define inp(p)          __inportb__(p)
#define outp(p,v)      (__outportb__(p,v), (int)_AL)
#define inpw(p)         __inportw__(p)
#define outpw(p,v)     (__outportw__(p,v), (unsigned)_AX)
#define inportb         __inportb__
#define inport          __inportw__
#define outportb        __outportb__
#define outport         __outportw__
#define disable( )      __emit__( (char)( 0xfa ) )
#define enable( )       __emit__( (char)( 0xfb ) )
#define geninterrupt(i) __int__(i)
#endif

#if __MSC__
#define _disable( ) __emit__( (char )( 0xfa ) ) /* MSC name */
#define _enable( )  __emit__( (char )( 0xfb ) ) /* MSC name */
#endif

#define ___PORTINT_H_INCLUDED
#endif

