//
//      **************************************************************
//       JdeBP C++ Library Routines      General Public Licence v1.00
//          Copyright (c) 1991,1992  Jonathan de Boyne Pollard
//      **************************************************************
//
//  STANDARD SYSTEM CALL INTERFACE (POSIX)
//

#if !defined(___STDDEF_H_INCLUDED)
#include <_stddef.h>
#endif

#if !defined(__UNISTD_H_INCLUDED)

#define _POSIX_VERSION  199009L /* We conform to revised standard if we can */

#undef  _POSIX_JOB_CONTROL      /* On a single-tasking OS?  You jest. */
#undef  _POSIX_SAVED_IDS        /* Not even under Netware */
#define _POSIX_CHOWN_RESTRICTED -1  /* Always restricted */
#undef  _POSIX_NO_TRUNC         /* Yes on Netware, no on MS-DOS */
#define _POSIX_VDISABLE -1      /* No tty driver on MS-DOS */

#define _SC_ARG_MAX     1
#define _SC_CHILD_MAX   2
#define _SC_CLK_TCK     3
#define _SC_NGROUPS_MAX 4
#define _SC_OPEN_MAX    5
#define _SC_JOB_CONTROL 6
#define _SC_SAVED_IDS   7
#define _SC_VERSION     8
#define _PC_LINK_MAX    9
#define _PC_MAX_CANON   10
#define _PC_MAX_INPUT   11
#define _PC_NAME_MAX    12
#define _PC_PATH_MAX    13
#define _PC_PIPE_BUF    14
#define _PC_CHOWN_RESTRICTED    15
#define _PC_NO_TRUNC    16
#define _PC_VDISABLE    17

#define STDIN_FILENO    0
#define STDOUT_FILENO   1
#define STDERR_FILENO   2

#if _MSDOS_SOURCE > 0
#define STDAUX_FILENO   3
#define STDPRN_FILENO   4
#endif

#if _MSDOS_SOURCE > 0
#define P_WAIT      0
#define P_NOWAIT    1
#define P_OVERLAY   2
#endif

extern "C" {

// NOTE.  The original POSIX.1 draft uses int and unsigned int instead of
// ssize_t and size_t in some calls.  Because Borland C++ uses strong typing,
// we stick to the second draft declaration rather than mucking about with
// #if's.

void    _CDECL  _exit       (int);

int     _CDECL  access      (const char *, int);
unsigned int    _CDECL  alarm   (unsigned int);
int     _CDECL  chdir       (const char *);
int     _CDECL  chown       (const char *, _Gid_t, _Gid_t);
int     _CDECL  close       (int);
char *  _CDECL  ctermid     (char *);
int     _CDECL  dup         (int);
int     _CDECL  dup2        (int, int);
int     _CDECL  execl       (const char *, const char *, ...);
int     _CDECL  execle      (const char *, const char *, ...);
int     _CDECL  execlp      (const char *, const char *, ...);
int     _CDECL  execlpe     (const char *, const char *, ...);
int     _CDECL  execv       (const char *, const char * const *);
int     _CDECL  execve      (const char *, const char * const *, const char * const *);
int     _CDECL  execvp      (const char *, const char * const *);
int     _CDECL  execvpe     (const char *, const char * const *, const char * const *);
_Pid_t  _CDECL  fork        (void);
long    _CDECL  fpathconf   (int, int);
char *  _CDECL  getcwd      (char *, _Size_t);
_Gid_t  _CDECL  getegid     (void);
_Uid_t  _CDECL  geteuid     (void);
_Gid_t  _CDECL  getgid      (void);
int     _CDECL  getgroups   (int, _Gid_t *);
char *  _CDECL  getlogin    (void);
_Pid_t  _CDECL  getpgrp     (void);
_Pid_t  _CDECL  getpid      (void);
_Pid_t  _CDECL  getppid     (void);
_Uid_t  _CDECL  getuid      (void);
int     _CDECL  isatty      (int);
int     _CDECL  link        (const char *, const char *);
_Off_t  _CDECL  lseek       (int, _Off_t, int);
long    _CDECL  pathconf    (const char *, int);
// pause
int     _CDECL  pipe        (int [2]);
_Ssize_t _CDECL read        (int, void *, _Size_t);
int     _CDECL  rmdir       (const char *);
int     _CDECL  setgid      (_Gid_t) ;              // POSIX.1 ?
int     _CDECL  setpgid     (_Pid_t, _Pid_t) ;      // POSIX.1 ?
_Pid_t  _CDECL  setsid      (void);
int     _CDECL  seteuid     (_Uid_t);
int     _CDECL  setegid     (_Uid_t);               // POSIX.1 ?
unsigned int    _CDECL  sleep   (unsigned int);
long    _CDECL  sysconf     (int);
char *  _CDECL  ttyname     (int fd);
int     _CDECL  unlink      (const char *);
_Ssize_t _CDECL write       (int, const void *, _Size_t);

// This was in the original POSIX.1 standard, but removed in the 1990
// revision.  There is no feature test macro for the 1990 revision.
#if _POSIX1_SOURCE == 1
char *  _CDECL  cuserid     (char *);
#endif

// These are only tentatively declared here, pending the second draft of
// POSIX.1 standard.
#if _POSIX1_SOURCE > 1
int     _CDECL  fchown      (int, _Uid_t, _Gid_t);
int     _CDECL  ftruncate   (int, _Off_t);
#endif

#if _POSIX2_SOURCE > 0
int     _CDECL  fnmatch     (const char *, const char *, int);
int     _CDECL  getopt      (int, const char *[], const char *);
#endif

#if _MSDOS_SOURCE > 0
int     _CDECL  chsize      (int, _Off_t);
int     _CDECL  eof         (int);
_Off_t  _CDECL  filelength  (int);
int     _CDECL  locking     (int, int, _Off_t);
char *  _CDECL  mktemp      (char *);
int     _CDECL  setmode     (int, _Mode_t);
_Off_t  _CDECL  tell        (int);

int     _CDECL  spawnl      (int, const char *, const char *, ...);
int     _CDECL  spawnle     (int, const char *, const char *, ...);
int     _CDECL  spawnlp     (int, const char *, const char *, ...);
int     _CDECL  spawnlpe    (int, const char *, const char *, ...);
int     _CDECL  spawnv      (int, const char *, const char * const *);
int     _CDECL  spawnve     (int, const char *, const char * const *, const char * const *);
int     _CDECL  spawnvp     (int, const char *, const char * const *);
int     _CDECL  spawnvpe    (int, const char *, const char * const *, const char * const *);
#endif

#if _POSIX2_SOURCE > 0
extern  _CDECL  char *  optarg;
extern  _CDECL  int     optind, opterr, optopt;
#endif

long    _CDECL  _pathconf   (int);

}

#define ttyname(fd)     _NULL       /* Can't use NULL in this header */

#if _MSDOS_SOURCE > 0 && _POSIX1_SOURCE > 1
#define chsize(fd,sz)   ftruncate(fd,sz)
#endif

#define __UNISTD_H_INCLUDED
#endif
