//
//      **************************************************************
//       JdeBP C++ Library Routines      General Public Licence v1.00
//          Copyright (c) 1991,1992  Jonathan de Boyne Pollard
//      **************************************************************
//
//  STAT structures, and file mode bits
//

#if !defined(__STDDEF_H_INCLUDED)
#include <_stddef.h>
#endif
#if !defined(__ATTRIB_H_INCLUDED)
#include <_attrib.h>        // File attribute constants
#endif

//
// Because POSIX.1 states that a file mode encoding is implementation
// defined, we make it easy on ourselves by mushing all the bit flags
// together.  Under MS-DOS, rwx permission for owner implies the same
// for group and world.  The NETWARE trustee system does not match
// POSIX.1, unfortunately.
//
// A mode_t is encoded as a short integer, with the lower byte being
// the MS-DOS file attribute, and the upper byte being extra bits for
// POSIX.1 derived from the lower.
//
// Ŀ
//  F  E  D  C  B  A  9  8   Lower byte as for MS-DOS     
// 
//                        
//                         Executable (true for directories)
//                      Writable (owner, group, & world)
//                   Readable (owner, group, & world)
//                File is a device
//             Save text (because S_ISVTX must be non-zero)
//          Set GID (because S_ISGID must be non-zero)
//       Set UID (because S_ISUID must be non-zero)
//    Reserved
//
// Although MS-DOS has block special drivers, they are not in the namespace
// for normal files, as under POSIX.1 they would be.
//

//
// POSIX.1 bit masks to apply to a mode_t.
//

#define S_ISUID     0x04000U    /* Setting to 0 would break correct code */
#define S_ISGID     0x02000U    /* Setting to 0 would break correct code */
#define S_ISVTX     0x01000U    /* Non-POSIX (and non-MSDOS !)*/
#define S_IRUSR     0x00400U
#define S_IWUSR     0x00200U
#define S_IXUSR     0x00100U
#define S_IRGRP     0x00400U
#define S_IWGRP     0x00200U
#define S_IXGRP     0x00100U
#define S_IROTH     0x00400U
#define S_IWOTH     0x00200U
#define S_IXOTH     0x00100U

#define S_IRWXU     (S_IRUSR|S_IWUSR|S_IXUSR)
#define S_IRWXG     (S_IRGRP|S_IWGRP|S_IXGRP)
#define S_IRWXO     (S_IROTH|S_IWOTH|S_IXOTH)

//
// POSIX.1 macros to apply to a mode_t returning zero or non-zero
//

#define S_ISBLK(m)  0
#define S_ISCHR(m)  ((m) & 0x08FFU) == 0x0800U)
#define S_ISDIR(m)  ((m) & _A_SUBDIR) == _A_SUBDIR)
#define S_ISFIFO(m) 0
#define S_ISREG(m)  ((m) & 0x08FFU) == (_A_NORMAL & ~0x0800))

//
// Non-POSIX.1 bit flags
//
// We assume the use will be as ((m & S_IFMT) == S_IF...) otherwise
// these values will not work.  It is not valid POSIX.1 usage anyway.
//

#define S_IFMT      0x08FFU     /* file type mask */
#define S_IFREG     0x0000U     /* regular (_A_NORMAL and not a device) */
#define S_IFDIR     _A_SUBDIR   /* directory */
#define S_IFCHR     0x0800U     /* character special */
#define S_IFBLK     0x0000U     /* block special (not in MS-DOS namespace) */
#define S_IFFIFO    0x0000U     /* FIFO */

#define S_IREAD     S_IRUSR
#define S_IWRITE    S_IWUSR
#define S_IEXEC     S_IXUSR

#ifndef _STAT_DEFINED
struct stat {
    mode_t  st_mode;
    ino_t   st_ino;
    dev_t   st_dev;
    nlink_t st_nlink;
    uid_t   st_uid;         // NETWARE only
    gid_t   st_gid;         // Meaningless
    off_t   st_size;
    time_t  st_atime;       // NETWARE only, otherwise == st_mtime
    time_t  st_mtime;
    time_t  st_ctime;       // NETWARE only, otherwise == st_mtime
    dev_t   st_rdev;
};
#define _STAT_DEFINED
#endif

extern "C" {

int     _CDECL  chmod       (const char *, mode_t);
int     _CDECL  fstat       (int, struct stat *);
int     _CDECL  mkdir       (const char *);
int     _CDECL  stat        (const char *, struct stat *);
mode_t  _CDECL  umask       (mode_t);

extern  mode_t  _CDECL  _umaskval;

#if _POSIX1_SOURCE > 1
int     _CDECL  fchmod      (int, mode_t);
#endif

mode_t  _CDECL  _Dos2PosixFileMode (unsigned int) ;
time_t  _CDECL  _Dos2PosixFileTime (unsigned short *, unsigned short *) ;

}
