//
//    *******************************************************************
//      JdeBP C++ Library Routines      General Public Licence v1.00
//          Copyright (c) 1991,1992  Jonathan de Boyne Pollard
//    *******************************************************************
//

//
//  OS/2 VIO API
//

#ifndef _VIOTYPES_DEFINED
typedef struct _VIOCURSORINFO {
        unsigned short   yStart;
        unsigned short   cEnd;
        unsigned short   cx;
        unsigned short   attr;
} VIOCURSORINFO;

typedef struct _VIOMODEINFO {
        unsigned short cb;
        unsigned char  fbType;
        unsigned char  color;
        unsigned short col;
        unsigned short row;
        unsigned short hres;
        unsigned short vres;
        unsigned char  fmt_ID;
        unsigned char  attrib;
} VIOMODEINFO;

typedef struct _VIOPHYSBUF {
        unsigned char far * pBuf;
        unsigned long       cb;
        unsigned short      asel[1];
} VIOPHYSBUF;

typedef struct _VIOCONFIGINFO {
        unsigned short  cb     ;
        unsigned short  adapter;
        unsigned short  display;
        unsigned long   cbMemory;
} VIOCONFIGINFO;

typedef struct _VIOFONTINFO {
        unsigned short  cb;
        unsigned short  type;
        unsigned short  cxCell;
        unsigned short  cyCell;
        void far *      pbData;
        unsigned short  cbData;
} VIOFONTINFO;

typedef struct _VIOPALSTATE {
        unsigned short  cb;
        unsigned short  type;
        unsigned short  iFirst;
        unsigned short  acolor[1];
}VIOPALSTATE;

typedef struct _VIOOVERSCAN {
        unsigned short  cb;
        unsigned short  type;
        unsigned short  color;
}VIOOVERSCAN;

typedef struct _VIOINTENSITY {
        unsigned short  cb;
        unsigned short  type;
        unsigned short  fs;
}VIOINTENSITY;
#define _VIOTYPES_DEFINED
#endif

extern "C" {

    USHORT _APICALL VioRegister ( unsigned char far *, unsigned char far *, unsigned long, unsigned long );

    USHORT _APICALL VioDeRegister ( void );

    USHORT _APICALL VioGetBuf ( unsigned long far *, unsigned short far *, unsigned short );

    USHORT _APICALL VioGetCurPos ( unsigned short far *, unsigned short far *, unsigned short );
    USHORT _APICALL VioSetCurPos ( unsigned short, unsigned short, unsigned short );

    USHORT _APICALL VioGetCurType ( VIOCURSORINFO far *, unsigned short );
    USHORT _APICALL VioSetCurType ( VIOCURSORINFO far *, unsigned short );

#define VGMT_MONOCHROME     0x00
#define VGMT_OTHER          0x01
#define VGMT_GRAPHICS       0x02
#define VGMT_DISABLEBURST   0x04

    USHORT _APICALL VioGetMode ( VIOMODEINFO far *, unsigned short );
    USHORT _APICALL VioSetMode ( const VIOMODEINFO far *, unsigned short );

    USHORT _APICALL VioGetPhysBuf ( VIOPHYSBUF far *, unsigned short );

    USHORT _APICALL VioReadCellStr ( char far *, unsigned short far *, unsigned short, unsigned short, unsigned short );
    USHORT _APICALL VioReadCharStr ( char far *, unsigned short far *, unsigned short, unsigned short, unsigned short );
    USHORT _APICALL VioWrtCellStr ( const char far *, unsigned short, unsigned short, unsigned short, unsigned short );
    USHORT _APICALL VioWrtCharStr ( const char far *, unsigned short, unsigned short, unsigned short, unsigned short );

    USHORT _APICALL VioScrollDn ( unsigned short, unsigned short, unsigned short, unsigned short, unsigned short, unsigned char far *,  unsigned short );
    USHORT _APICALL VioScrollUp ( unsigned short, unsigned short, unsigned short, unsigned short, unsigned short, unsigned char far *,  unsigned short );
    USHORT _APICALL VioScrollLf ( unsigned short, unsigned short, unsigned short, unsigned short, unsigned short, unsigned char far *,  unsigned short );
    USHORT _APICALL VioScrollRt ( unsigned short, unsigned short, unsigned short, unsigned short, unsigned short, unsigned char far *,  unsigned short );

    USHORT _APICALL VioWrtNAttr ( unsigned const char far *, unsigned short, unsigned short, unsigned short, unsigned short );
    USHORT _APICALL VioWrtNCell ( unsigned const char far *, unsigned short, unsigned short, unsigned short, unsigned short );
    USHORT _APICALL VioWrtNChar ( const char far *, unsigned short, unsigned short, unsigned short, unsigned short );
    USHORT _APICALL VioWrtTTy ( const char far *, unsigned short, unsigned short );
    USHORT _APICALL VioWrtCharStrAtt ( const char far *, unsigned short, unsigned short, unsigned short, const unsigned char far *, unsigned short );

    USHORT _APICALL VioShowBuf ( unsigned short, unsigned short, unsigned short );

#define ANSI_ON     1
#define ANSI_OFF    0

    USHORT _APICALL VioSetAnsi ( unsigned short, unsigned short );
    USHORT _APICALL VioGetAnsi ( unsigned short far *, unsigned short );

    USHORT _APICALL VioPrtSc ( unsigned short );
    USHORT _APICALL VioPrtScToggle ( unsigned short );

#define VSRWI_SAVEANDREDRAW  0
#define VSRWI_REDRAW         1

#define VSRWN_SAVE           0
#define VSRWN_REDRAW         1

#define UNDOI_GETOWNER          0
#define UNDOI_RELEASEOWNER      1

#define UNDOK_ERRORCODE         0
#define UNDOK_TERMINATE         1

    USHORT _APICALL VioSavRedrawWait ( unsigned short, unsigned short far *, unsigned short);
    USHORT _APICALL VioSavRedrawUndo ( unsigned short, unsigned short, unsigned short );

#define VMWR_POPUP  0
#define VMWN_POPUP  0

    USHORT _APICALL VioModeWait ( unsigned short, unsigned short far *, unsigned short );
    USHORT _APICALL VioModeUndo ( unsigned short, unsigned short, unsigned short );

#define LOCKIO_NOWAIT   0
#define LOCKIO_WAIT     1

#define LOCK_SUCCESS    0
#define LOCK_FAIL       1

    USHORT _APICALL VioScrLock ( unsigned short, unsigned char far *, unsigned short );
    USHORT _APICALL VioScrUnLock ( unsigned short );

#define VP_NOWAIT       0x0000
#define VP_WAIT         0x0001
#define VP_OPAQUE       0x0000
#define VP_TRANSPARENT  0x0002

    USHORT _APICALL VioPopUp ( unsigned short far *, unsigned short );
    USHORT _APICALL VioEndPopUp ( unsigned short );

    USHORT _APICALL VioGetConfig ( unsigned short, VIOCONFIGINFO far *, unsigned short );

#define VGFI_GETCURFONT     0
#define VGFI_GETROMFONT     1

    USHORT _APICALL VioGetFont ( VIOFONTINFO far *, unsigned short );
    USHORT _APICALL VioSetFont ( VIOFONTINFO far *, unsigned short );

    USHORT _APICALL VioGetCp ( unsigned short, unsigned short far *, unsigned short );
    USHORT _APICALL VioSetCp ( unsigned short, unsigned short, unsigned short );

    USHORT _APICALL VioGetState ( void far *, unsigned short );
    USHORT _APICALL VioSetState ( void far *, unsigned short );


}
