//
//    *******************************************************************
//      JdeBP C++ Library Routines      General Public Licence v1.00
//          Copyright (c) 1991,1992  Jonathan de Boyne Pollard
//    *******************************************************************
//

//
//  OS/2 MOU API
//

#ifndef _MOUTYPES_DEFINED

typedef struct _PTRLOC {
		USHORT row;
		USHORT col;
} PTRLOC;

typedef struct _PTRSHAPE {
		USHORT cb;
		USHORT col;
		USHORT row;
		USHORT colHot;
		USHORT rowHot;
} PTRSHAPE;

typedef struct _MOUEVENTINFO {
		USHORT fs;
		ULONG  Time;
		USHORT row;
		USHORT col;
} MOUEVENTINFO;

typedef struct _MOUQUEINFO {
		USHORT cEvents;
		USHORT cmaxEvents;
} MOUQUEINFO;

typedef struct _SCALEFACT {
		USHORT rowScale;
		USHORT colScale;
} SCALEFACT;

typedef struct _NOPTRRECT {
		USHORT row;
		USHORT col;
		USHORT cRow;
		USHORT cCol;
} NOPTRRECT;

#define _MOUTYPES_DEFINED
#endif

extern "C" {

USHORT _APICALL MouRegister ( const UCHAR far *, const UCHAR far *, ULONG );

USHORT _APICALL MouDeRegister ( void );

USHORT _APICALL MouFlushQue ( USHORT );

#define MHK_BUTTON1         0x0002
#define MHK_BUTTON2         0x0004
#define MHK_BUTTON3         0x0008

USHORT _APICALL MouGetHotKey ( USHORT far *, USHORT );
USHORT _APICALL MouSetHotKey ( USHORT far *, USHORT );

USHORT _APICALL MouGetPtrPos ( PTRLOC far *, USHORT );
USHORT _APICALL MouSetPtrPos ( PTRLOC far *, USHORT );

USHORT _APICALL MouSetPtrShape ( BYTE far *, PTRSHAPE far *, USHORT );
USHORT _APICALL MouGetPtrShape ( BYTE far *, PTRSHAPE far *, USHORT );

USHORT _APICALL MouGetDevStatus ( USHORT far *, USHORT );

USHORT _APICALL MouGetNumButtons ( USHORT far *, USHORT );
USHORT _APICALL MouGetNumMickeys ( USHORT far *, USHORT );

USHORT _APICALL MouReadEventQue ( MOUEVENTINFO far *, USHORT far *, USHORT );

USHORT _APICALL MouGetNumQueEl ( MOUQUEINFO far *, USHORT );

USHORT _APICALL MouGetEventMask ( USHORT far *, USHORT );
USHORT _APICALL MouSetEventMask ( USHORT far *, USHORT );

USHORT _APICALL MouGetScaleFact ( SCALEFACT far *, USHORT );
USHORT _APICALL MouSetScaleFact ( SCALEFACT far *, USHORT );

USHORT _APICALL MouOpen ( const UCHAR far *, USHORT far * );
USHORT _APICALL MouClose ( USHORT );

USHORT _APICALL MouRemovePtr ( NOPTRRECT far *, USHORT );

USHORT _APICALL MouDrawPtr ( USHORT );

USHORT _APICALL MouSetDevStatus ( USHORT far *, USHORT );
USHORT _APICALL MouInitReal ( const UCHAR far * );

USHORT _APICALL MouSynch ( USHORT );

}
