//
//    *******************************************************************
//      JdeBP C++ Library Routines      General Public Licence v1.00
//          Copyright (c) 1991,1992  Jonathan de Boyne Pollard
//    *******************************************************************
//

//
//  OS/2 DOS API
//

#ifndef _DOSTYPES_DEFINED

typedef struct {
	unsigned day:   5;
	unsigned month: 4;
	unsigned year:  7;
} FDATE ;

typedef struct {
	unsigned twosecs:   5;
	unsigned minutes:   6;
	unsigned hours:     5;
} FTIME ;

typedef struct {
	unsigned char   hours;
    unsigned char   minutes;
    unsigned char   seconds;
    unsigned char   hundredths;
    unsigned char   day;
    unsigned char   month;
    unsigned short  year;
    short           timezone;
	unsigned char   weekday;
} DOSDATETIME;

typedef struct {
    unsigned short country;
    unsigned short codepage;
} DOSCOUNTRYCODE;

typedef struct {
    FDATE   fdateCreation;
    FTIME   ftimeCreation;
    FDATE   fdateLastAccess;
    FTIME   ftimeLastAccess;
	FDATE   fdateLastWrite;
    FTIME   ftimeLastWrite;
    unsigned long  cbFile;
    unsigned long  cbFileAlloc;
    unsigned short attrFile;
} DOSFILESTATUS;

typedef struct {
    unsigned short country;
    unsigned short codepage;
    unsigned short fsDateFmt;
    char   szCurrency[5];
    char   szThousandsSeparator[2];
    char   szDecimal[2];
    char   szDateSeparator[2];
    char   szTimeSeparator[2];
    unsigned char  fsCurrencyFmt;
    unsigned char  cDecimalPlace;
    unsigned char  fsTimeFmt;
    unsigned short abReserved1[2];
    char   szDataSeparator[2];
	unsigned short abReserved2[5];
} DOSCOUNTRYINFO;

typedef struct {
    unsigned long  idFileSystem;
    unsigned long  cSectorUnit;
    unsigned long  cUnit;
    unsigned long  cUnitAvail;
    unsigned short cbSector;
} FSALLOCATE;

#define CCHMAXPATHCOMP	256		/* Support for HPFS long filenames */

typedef struct {
	FDATE   fdateCreation;
	FTIME   ftimeCreation;
	FDATE   fdateLastAccess;
	FTIME   ftimeLastAccess;
	FDATE   fdateLastWrite;
	FTIME   ftimeLastWrite;
	unsigned long   cbFile;
	unsigned long   cbFileAlloc;
	unsigned int    attrFile;
	unsigned char   cchName;
	char            achName[CCHMAXPATHCOMP];
} FILEFINDBUF ;

typedef struct {
    unsigned int    pid ;
    unsigned int    tid ;
    unsigned int    pidParent ;
} PIDINFO ;

typedef struct {
	unsigned int    codeTerminate ;
    unsigned int    codeResult ;
} RESULTCODES ;

typedef struct {
	ULONG   time;
	ULONG   msecs;
	UCHAR   hour;
	UCHAR   minutes;
	UCHAR   seconds;
	UCHAR   hundredths;
	USHORT  timezone;
	USHORT  cusecTimerInterval;
	UCHAR   day;
	UCHAR   month;
	USHORT  year;
	UCHAR   weekday;
	UCHAR   uchMajorVersion;
	UCHAR   uchMinorVersion;
	UCHAR   chRevisionLetter;
	UCHAR   sgCurrent;
	UCHAR   sgMax;
	UCHAR   cHugeShift;
	UCHAR   fProtectModeOnly;
	USHORT  pidForeground;
	UCHAR   fDynamicSched;
	UCHAR   csecMaxWait;
	USHORT  cmsecMinSlice;
	USHORT  cmsecMaxSlice;
	USHORT  bootdrive;
	UCHAR   amecRAS[32];
} GINFOSEG;

typedef struct {
	USHORT  pidCurrent;
	USHORT  pidParent;
	USHORT  prtyCurrent;
	USHORT  tidCurrent;
	USHORT  sgCurrent;
	USHORT  sgSub;
	USHORT  fForeground;
} LINFOSEG;

typedef struct {
	USHORT zero;
	USHORT hsem;
} MUXSEM;

typedef struct {
	USHORT  cmxs;
	MUXSEM  amxs[16];
} MUXSEMLIST;

typedef struct {
	USHORT cb;
	USHORT Related;
	USHORT FgBg;
	USHORT TraceOpt;
	const UCHAR far *PgmTitle;
	const UCHAR far *PgmName;
	BYTE  far *PgmInputs;
	BYTE  far *TermQ;
} STARTDATA;

typedef struct {
	USHORT cb;
	USHORT SelectInd;
	USHORT BindInd;
} STATUSDATA;

#define _DOSTYPES_DEFINED
#endif

extern "C" {



#if defined(INCL_DOS) || defined(INCL_DOSPROCESS)

void  _APICALL  DosBeep     (USHORT, USHORT);
void  _APICALL  DosExit     (USHORT, USHORT);

#define EXIT_THREAD         0
#define EXIT_PROCESS        1

USHORT _APICALL DosCreateThread (void (far *)(void), UINT far *, unsigned char far *) ;
USHORT _APICALL DosResumeThread (UINT) ;
USHORT _APICALL DosSuspendThread (UINT) ;

USHORT _APICALL DosCWait (UINT, UINT, RESULTCODES far *, UINT far *, UINT) ;
void  _APICALL  DosSleep    (unsigned long);

#define DCWA_PROCESS        0
#define DCWA_PROCESSTREE    1
#define DCWW_WAIT   0
#define DCWW_NOWAIT 1

#define TC_EXIT          0
#define TC_HARDERROR     1
#define TC_TRAP          2
#define TC_KILLPROCESS   3

USHORT _APICALL DosEnterCritSec (void) ;
USHORT _APICALL DosExitCritSec (void) ;
USHORT _APICALL DosExitList (UINT, void (far *)(UINT)) ;

#define EXLST_ADD       1
#define EXLST_REMOVE    2
#define EXLST_EXIT      3

USHORT _APICALL DosExecPgm (char far *, USHORT, USHORT, char far *, char far *, RESULTCODES far *, char far *);

#define EXEC_SYNC           0
#define EXEC_ASYNC          1
#define EXEC_ASYNCRESULT    2
#define EXEC_TRACE          3
#define EXEC_BACKGROUND     4
#define EXEC_LOAD           5

USHORT _APICALL DosGetPid   (PIDINFO far *);
USHORT _APICALL DosGetPrty (UINT, UINT far *, UINT) ;
USHORT _APICALL DosSetPrty (UINT, UINT, short int, UINT) ;

#define PRTYS_PROCESS       0
#define PRTYS_PROCESSTREE   1
#define PRTYS_THREAD        2

#define PRTYC_NOCHANGE      0
#define PRTYC_IDLETIME      1
#define PRTYC_REGULAR       2
#define PRTYC_TIMECRITICAL  3

USHORT _APICALL DosKillProcess (UINT, UINT) ;

#define DKP_PROCESS         0
#define DKP_PROCESSTREE     1

#endif /* INCL_DOSPROCESS */




#if defined(INCL_DOS) || defined(INCL_DOSINFOSEG)

#define PT_FULLSCREEN       0
#define PT_REALMODE         1
#define PT_WINDOWABLEVIO    2
#define PT_PM               3
#define PT_DETACHED         4

USHORT _APICALL DosGetInfoSeg (USHORT far *, USHORT far *) ;

#endif /* INCL_DOSINFOSEG */




#if defined(INCL_DOS) || defined(INCL_DOSFILEMGR)

USHORT _APICALL DosClose    (USHORT);
USHORT _APICALL DosOpen     (const char far *, USHORT far *, unsigned int far *, unsigned long, unsigned int, unsigned int, unsigned int, unsigned long);
USHORT _APICALL DosRead     (USHORT, void far *, USHORT, USHORT far *);
USHORT _APICALL DosWrite    (USHORT, void far *, USHORT, USHORT far *);
USHORT _APICALL DosBufReset (USHORT);
USHORT _APICALL DosChdir    (const char far *);
USHORT _APICALL DosChgFilePtr (USHORT, long, USHORT, long far *);
USHORT _APICALL DosDelete   (const char far *, unsigned long);
USHORT _APICALL DosDupHandle (USHORT, USHORT far *);
USHORT _APICALL DosFileLocks (USHORT, long far *, long far *);
USHORT _APICALL DosFindClose (USHORT) ;
USHORT _APICALL DosFindFirst (char far *, USHORT far *, unsigned int, FILEFINDBUF far *, unsigned int, unsigned int far *, unsigned long);
USHORT _APICALL DosFindNext (USHORT, FILEFINDBUF far *, unsigned int, unsigned int far *);
USHORT _APICALL DosNewSize  (USHORT, unsigned long);
USHORT _APICALL DosMkdir    (const char far *, unsigned long);
USHORT _APICALL DosMove     (const char far *, const char far *, unsigned long);
USHORT _APICALL DosQCurDir  (USHORT, char far *, USHORT far *);
USHORT _APICALL DosQCurDisk (USHORT far *, unsigned long far *);
USHORT _APICALL DosQFHandState (USHORT, USHORT far *);
USHORT _APICALL DosQFileInfo (USHORT, USHORT, DOSFILESTATUS far *, USHORT);
USHORT _APICALL DosQFileMode (const char far *, USHORT far *, unsigned long);
USHORT _APICALL DosQFSInfo  (USHORT, USHORT, BYTE far *, USHORT);
USHORT _APICALL DosQHandType (USHORT, USHORT far *, USHORT far *);
USHORT _APICALL DosQVerify  (USHORT far *);
USHORT _APICALL DosReadAsync (USHORT, unsigned long far *, USHORT far *, void far *, USHORT, USHORT far *) ;
USHORT _APICALL DosRmdir    (const char far *, unsigned long);
USHORT _APICALL DosSelectDisk (USHORT);
USHORT _APICALL DosSetFHandState (USHORT, USHORT);
USHORT _APICALL DosSetFileInfo (USHORT, USHORT, DOSFILESTATUS far *, USHORT);
USHORT _APICALL DosSetFileMode (const char far *, USHORT, unsigned long);
USHORT _APICALL DosSetFSInfo (USHORT, USHORT, BYTE far *, USHORT);
USHORT _APICALL DosSetMaxFH (USHORT);
USHORT _APICALL DosSetVerify (USHORT);
USHORT _APICALL DosWriteAsync (USHORT, unsigned long far *, USHORT far *, void far *, USHORT, USHORT far *) ;

#endif /* INCL_DOSFILEMGR */





#if defined(INCL_DOS) || defined(INCL_DOSMEMMGR)

USHORT _APICALL DosAllocSeg (USHORT, USHORT far *, USHORT);
USHORT _APICALL DosFreeSeg  (USHORT);
USHORT _APICALL DosMemAvail (ULONG far *);
USHORT _APICALL DosReallocSeg (USHORT, USHORT);

#define SEG_GIVEABLE        0x0001
#define SEG_GETTABLE        0x0002
#define SEG_DISCARDABLE     0x0004

USHORT _APICALL DosLockSeg (USHORT) ;
USHORT _APICALL DosUnlockSeg (USHORT) ;

USHORT _APICALL DosAllocHuge (USHORT, USHORT, USHORT far *, USHORT, USHORT);
USHORT _APICALL DosGetHugeShift (USHORT far *);
USHORT _APICALL DosReallocHuge (USHORT, USHORT, USHORT);

USHORT _APICALL DosAllocShrSeg (UINT, char far *, USHORT far *) ;
USHORT _APICALL DosGiveSeg  (USHORT, USHORT, USHORT far *);
USHORT _APICALL DosGetSeg   (USHORT);
USHORT _APICALL DosGetShrSeg (char far *, USHORT far *) ;

USHORT _APICALL DosSubAlloc (USHORT, USHORT far *, USHORT);
USHORT _APICALL DosSubFree  (USHORT, USHORT, USHORT);
USHORT _APICALL DosSubSet   (USHORT, USHORT, USHORT);

USHORT _APICALL DosCreateCSAlias (USHORT, USHORT far *) ;

#endif /* INCL_DOSMEMMGR */


#if defined(INCL_DOS) || defined(INCL_DOSSEMAPHORES)

//USHORT _APICALL DosCloseSem(HSEM);
//USHORT _APICALL DosCreateSem(USHORT, PHSYSSEM, PSZ);
//USHORT _APICALL DosOpenSem(PHSEM, PSZ);
//USHORT _APICALL DosSemClear(HSEM);
//USHORT _APICALL DosSemRequest(HSEM, LONG);
//USHORT _APICALL DosSemSet(HSEM);
//USHORT _APICALL DosSemSetWait(HSEM, LONG);
//USHORT _APICALL DosSemWait(HSEM, LONG);

#define CSEM_PRIVATE    0
#define CSEM_PUBLIC     1

/*
 * Since a MUXSEMLIST structure is actually a variable length
 * structure, the following macro may be used to define a MUXSEMLIST
 * structure having size elements, named "name".
 */
#define DEFINEMUXSEMLIST(name, size) \
	struct {                         \
		USHORT cmxs;                 \
		MUXSEM amxs[size];           \
	} name;

/*
 * This function actually takes a far pointer to a MUXSEMLIST structure
 * as its second parameter, but in order to allow its use with the
 * DEFINEMUXSEMLIST macro, it is declared here as PVOID.
 */
//USHORT _APICALL DosMuxSemWait(PUSHORT, PVOID, LONG);

#endif /* INCL_DOSSEMAPHORES */



#if defined(INCL_DOS) || defined(INCL_DOSDATETIME)

USHORT _APICALL DosGetDateTime (DOSDATETIME far *);
USHORT _APICALL DosSetDateTime (DOSDATETIME far *);

USHORT _APICALL DosTimerAsync(ULONG, USHORT, USHORT far *);
USHORT _APICALL DosTimerStart(ULONG, USHORT, USHORT far *);
USHORT _APICALL DosTimerStop(USHORT);

#endif /* INCL_DOSDATETIME */



#if defined(INCL_DOS) || defined(INCL_DOSMODULEMGR)

//USHORT _APICALL DosLoadModule(PSZ, USHORT, PSZ, PHMODULE);
//USHORT _APICALL DosFreeModule(HMODULE);
//USHORT _APICALL DosGetProcAddr(HMODULE, PSZ, PPFN);
//USHORT _APICALL DosGetModHandle(PSZ, PHMODULE);
//USHORT _APICALL DosGetModName(HMODULE, USHORT, PCHAR);

#endif /* INCL_DOSMODULEMGR */



#if defined(INCL_DOS) || defined(INCL_DOSNLS)

USHORT _APICALL DosCaseMap  (USHORT, DOSCOUNTRYCODE far *, char far *);
USHORT _APICALL DosGetCollate (USHORT, DOSCOUNTRYCODE far *, char far *, USHORT far *);
USHORT _APICALL DosGetCp    (USHORT, USHORT far *, USHORT far *);
USHORT _APICALL DosGetCtryInfo (USHORT, DOSCOUNTRYCODE far *, DOSCOUNTRYINFO far *, USHORT far *);
USHORT _APICALL DosGetDBCSEv (USHORT, DOSCOUNTRYCODE far *, char far *);
USHORT _APICALL DosSetCp    (USHORT, USHORT);

#endif /* INCL_DOSNLS */



#if defined(INCL_DOS) || defined(INCL_DOSSIGNALS)

#define SIG_CTRLC           1       /* Control C            */
#define SIG_BROKENPIPE      2       /* Broken Pipe          */
#define SIG_KILLPROCESS     3       /* Program Termination  */
#define SIG_CTRLBREAK       4       /* Control Break        */
#define SIG_PFLG_A          5       /* Process Flag A       */
#define SIG_PFLG_B          6       /* Process Flag B       */
#define SIG_PFLG_C          7       /* Process Flag C       */
#define SIG_CSIGNALS        8       /* number of signals plus one */

#define PFLG_A              0       /* Process Flag A       */
#define PFLG_B              1       /* Process Flag B       */
#define PFLG_C              2       /* Process Flag C       */

#define SIGA_KILL           0
#define SIGA_IGNORE         1
#define SIGA_ACCEPT         2
#define SIGA_ERROR          3
#define SIGA_ACKNOWLEDGE    4

#define HLDSIG_ENABLE       0
#define HLDSIG_DISABLE      1

#define FLGP_SUBTREE        0
#define FLGP_PID            1

USHORT _APICALL DosSetSigHandler (void (_APICALL *)(USHORT, USHORT), void (_APICALL * far *)(USHORT, USHORT), unsigned int far *, unsigned int, unsigned int) ;
//USHORT _APICALL DosFlagProcess(PID, USHORT, USHORT, USHORT);
//USHORT _APICALL DosHoldSignal(USHORT);
//USHORT _APICALL DosSendSignal(USHORT, USHORT);

#endif /* INCL_DOSSIGNALS */




#if defined(INCL_DOS) || defined(INCL_DOSMONITORS)

//USHORT _APICALL   DosMonClose () ;
//USHORT _APICALL   DosMonOpen () ;
//USHORT _APICALL   DosMonRead () ;
//USHORT _APICALL   DosMonReg () ;
//USHORT _APICALL   DosMonWrite () ;

#endif /* DOS_MONITORS */


#if defined(INCL_DOS) || defined(INCL_DOSQUEUES)
USHORT _APICALL DosMakePipe (USHORT far *, USHORT far *, UINT) ;
//USHORT _APICALL DosCloseQueue(HQUEUE);
//USHORT _APICALL DosCreateQueue(PHQUEUE, USHORT, PSZ);
//USHORT _APICALL DosOpenQueue(PUSHORT, PHQUEUE, PSZ);
//USHORT _APICALL DosPeekQueue(HQUEUE, PULONG, PUSHORT, PULONG, PUSHORT, USHORT, PBYTE, HSEM);
//USHORT _APICALL DosPurgeQueue(HQUEUE);
//USHORT _APICALL DosQueryQueue(HQUEUE, PUSHORT);
//USHORT _APICALL DosReadQueue(HQUEUE, PULONG, PUSHORT, PULONG, USHORT, USHORT, PBYTE, HSEM);
//USHORT _APICALL DosWriteQueue(HQUEUE, USHORT, USHORT, PBYTE, USHORT);
#endif /* INCL_DOSQUEUES */


#if defined(INCL_DOS) || defined(INCL_DOSMISC)

USHORT _APICALL DosErrClass (USHORT, USHORT far *, USHORT far *, USHORT far *);
USHORT _APICALL DosError    (USHORT);
USHORT _APICALL DosSetVec   (USHORT, int (_APICALL *)(void), int (_APICALL * far *)(void));

USHORT _APICALL DosGetEnv   (USHORT far *, USHORT far *) ;
USHORT _APICALL DosGetMachineMode (unsigned char far *);
USHORT _APICALL DosGetVersion (USHORT far *);
USHORT _APICALL DosScanEnv  (const char far *, const char far * far *);
USHORT _APICALL DosSearchPath (USHORT, const char far *, const char far *, unsigned char far *, USHORT);

USHORT _APICALL DosGetMessage (char far * far *, USHORT, char far *, USHORT, USHORT, char far *, USHORT far *);
USHORT _APICALL DosInsMessage (char far * far *, USHORT, char far *, USHORT, char far *, USHORT, USHORT far *);
USHORT _APICALL DosPutMessage (int, USHORT, char far *);

#endif /* INCL_DOSMISC */

#if defined(INCL_DOS) || defined(INCL_DOSSESMGR)

//USHORT _APICALL DosStartSession(STARTDATA far *, USHORT far *, USHORT far *);
//USHORT _APICALL DosSetSession(USHORT, STATUSDATA far *);
//USHORT _APICALL DosSelectSession(USHORT, ULONG);
//USHORT _APICALL DosStopSession(USHORT, USHORT, ULONG);

#endif /* INCL_DOSSESMGR */



#if defined(INCL_DOS) || defined(INCL_DOSDEVICES)

USHORT _APICALL DosCLIAccess (void) ;
USHORT _APICALL DosDevConfig (void far *, UINT, UINT) ;
USHORT _APICALL DosDevIOCtl (void far *, void far *, UINT, UINT, UINT);
USHORT _APICALL DosPhysicalDisc (UINT, unsigned char far *, UINT, unsigned char far *, UINT) ;
USHORT _APICALL DosPortAccess (UINT, UINT, UINT, UINT) ;

//USHORT _APICALL   DosPTrace () ;
//USHORT _APICALL DosSystemService(USHORT, void far *, void far *);


#endif /* INCL_DOSDEVICES */

}
