/*
 *		**************************************************************
 *		 JdeBP C++ Library Routines 	 General Public Licence v1.00
 *			Copyright (c) 1991,1992	 Jonathan de Boyne Pollard
 *		**************************************************************
 *
 * LIMITS (ANSI) (FREESTANDING)
 *
 */

#define MB_LEN_MAX		255				/* Maximum len of MB char	*/
#define CHAR_BIT		8				/* Bits in a char			*/

#define INT_MAX			32767			/* Max of int				*/
#define INT_MIN			-32767			/* Min of int				*/
#define LONG_MAX		2147483647L		/* Max of long				*/
#define LONG_MIN		-2147483647L	/* Min of long				*/

#define SCHAR_MAX		127				/* Max of signed char		*/
#define SCHAR_MIN		-127			/* Min of signed char		*/
#define SHRT_MAX		32767			/* Max of short				*/
#define SHRT_MIN		-32767			/* Min of short				*/

#define UCHAR_MAX		255				/* Max of unsigned char		*/
#define UINT_MAX		0xffff			/* Max of unsigned int		*/
#define ULONG_MAX		0xffffffffUL	/* Max of unsigned long		*/
#define USHRT_MAX		0xffff			/* Max of unsigned short	*/

#if !defined(_CHAR_UNSIGNED) || ('\x80' < '\x00')
#define CHAR_MAX		SCHAR_MAX
#define CHAR_MIN		SCHAR_MIN
#else
#define CHAR_MAX		UCHAR_MAX
#define CHAR_MIN		0
#endif

#if _POSIX1_SOURCE > 0

//
// POSIX absolute minima of system limits.  MUST be defined as in standard.
//
#define	_POSIX_ARG_MAX		4096
#define	_POSIX_CHILD_MAX	6			/* Will be 0 under MS-DOS. */
#define	_POSIX_LINK_MAX		8			/* Will be 1 under MS-DOS. */
#define	_POSIX_MAX_CANON	255
#define	_POSIX_MAX_INPUT	255			/* WIll be 15 for IBM PC/AT. */
#define	_POSIX_NAME_MAX		14			/* Will be 13 under MS-DOS. */
#define	_POSIX_NGROUPS_MAX	0			/* Netware support */
#define	_POSIX_OPEN_MAX		16
#define	_POSIX_PATH_MAX		255			/* Will be 64/128 MS-DOS/Netware. */
#define	_POSIX_PIPE_BUF		512
#define	_POSIX_STREAM_MAX	8
#define	_POSIX_SSIZE_MAX	32767

//
// MUST be defined, but variable at runtime.
//
#define NGROUPS_MAX		256				/* Assume Netware */

//
// MUST be defined, and fixed.
//
#define	SSIZE_MAX		32767			/* Relies on <_stddef.h> _SizeT */

//
// Defined only if fixed, always but obtainable from {fpath,path,sys}conf()
//
#define	ARG_MAX			32767			/* 32k limit owing to near pointers */
#undef	CHILD_MAX						/* Unsupported */
#undef	STREAM_MAX						/* Unsupported */
#undef	OPEN_MAX		20
#define	LINK_MAX		1				/* POSIX minimum is 8 ! */
#undef	MAX_CANON
#undef	MAX_INPUT		15				/* POSIX minimum is 15 ! */
#define	NAME_MAX		13				/* POSIX minimum is 14 ! */
#undef	PATH_MAX						/* Variable under Netware */
#undef	PIPE_BUF						/* Unsupported */
#endif