//
//      **************************************************************
//       JdeBP C++ Library Routines      General Public Licence v1.00
//          Copyright (c) 1991,1992  Jonathan de Boyne Pollard
//      **************************************************************
//
//  CHARACTER TYPE FUNCTIONS (ANSI)
//

#if !defined(___STDDEF_H_INCLUDED)
#include <_stddef.h>
#endif

#ifndef __CTYPE_H_INCLUDED

#define _CT_UPPER   0x0001U /* 'A' to 'Z' (variable in non-"C" locale)  */
#define _CT_LOWER   0x0002U /* 'a' to 'z' (variable in non-"C" locale)  */
#define _CT_ALPHA   0x0004U /* Any other alphabetic (non-"C" locales)   */
#define _CT_PUNCT   0x0008U /* Punctuation chars    (variable)          */
#define _CT_CNTRL   0x0010U /* Control characters   (variable)          */
#define _CT_MCTRL   0x0020U /* Motion control characters FF NL CR VT HT */
#define _CT_SPACE   0x0040U /* The ' ' char                             */
#define _CT_WHITE   0x0080U /* Other whitespace (variable in non"C")    */
#define _CT_DIGIT   0x0100U /* '0' to '9'                               */
#define _CT_HEX     0x0200U /* 'A' to 'F' and 'a' to 'f'                */

extern "C" {

int     _CDECL  isalnum     (int);
int     _CDECL  isalpha     (int);
int     _CDECL  iscntrl     (int);
int     _CDECL  isdigit     (int);
int     _CDECL  isgraph     (int);
int     _CDECL  islower     (int);
int     _CDECL  isprint     (int);
int     _CDECL  ispunct     (int);
int     _CDECL  isspace     (int);
int     _CDECL  isupper     (int);
int     _CDECL  isxdigit    (int);
int     _CDECL  tolower     (int);
int     _CDECL  toupper     (int);

#if _SYSTEM_V_SOURCE > 0
int     _CDECL  _tolower    (int);
int     _CDECL  _toupper    (int);
int     _CDECL  isascii     (int);
int     _CDECL  toascii     (int);
#endif

}

/*
 * Actually, these point to one beyond the start of the table to make
 * the macro overrides simpler and faster, even when dealing with EOF (-1).
 */
extern unsigned short * _CDECL _Ctype, * _CDECL _Cupper, * _CDECL _Clower;

#define isdigit(c)  (_Ctype[(int)(c)] & _CT_DIGIT)
#define ispunct(c)  (_Ctype[(int)(c)] & _CT_PUNCT)
#define isxdigit(c) (_Ctype[(int)(c)] & (_CT_DIGIT|_CT_HEX))

#define isalpha(c)  (_Ctype[(int)(c)] & (_CT_ALPHA|_CT_UPPER|_CT_LOWER))
#define isalnum(c)  (_Ctype[(int)(c)] & (_CT_ALPHA|_CT_UPPER|_CT_LOWER|_CT_DIGIT))
#define isgraph(c)  (_Ctype[(int)(c)] & (_CT_ALPHA|_CT_UPPER|_CT_LOWER|_CT_DIGIT|_CT_PUNCT))
#define isprint(c)  (_Ctype[(int)(c)] & (_CT_ALPHA|_CT_UPPER|_CT_LOWER|_CT_DIGIT|_CT_PUNCT|_CT_SPACE))

#define iscntrl(c)  (_Ctype[(int)(c)] & (_CT_MCTRL|_CT_CNTRL))
#define isspace(c)  (_Ctype[(int)(c)] & (_CT_MCTRL|_CT_SPACE|_CT_WHITE))

#define islower(c)  (_Ctype[(int)(c)] & _CT_LOWER)
#define isupper(c)  (_Ctype[(int)(c)] & _CT_UPPER)

#define tolower(c)  (_Clower[(int)(c)])
#define toupper(c)  (_Cupper[(int)(c)])

#if _SYSTEM_V_SOURCE > 0
#define isascii(c)  ((unsigned)(c) < 0x80U)
#define toascii(c)  ((unsigned)(c) & 0x7fU)
#define _tolower(c) ((c)-'A'+'a')
#define _toupper(c) ((c)-'a'+'A')
#endif

#define __CTYPE_H_INCLUDED
#endif
