/********************************************************************
 * EzyCom structures converted to C format V1.02 9/9/92
 * by Peter Davies and Ron Clark
 * Based on original C Structures for Ezycom V1.00 by Colin Berg
 *
 * These structures may ONLY be used in accordance with those
 * agreements laid out in the Official Ezycom Structures.
 * Peter Davies or Ron Clark takes no responsibility whatsoever
 * for the correctness of these structures.
 *
 * If, you find any faults please notify me of them.
 *
 * Please refer to the pascal structures for more explanation, before
 * querying me
 *
 ********************************************************************/

#define  EZYVER     "1.02"
#define  VERSIONHIGH   1
#define  VERSIONLOW    2
#define  PRODNAME   "Ezycom"
#define  COPYRIGHT  "Peter Davies"
#define  MAXFREE     685
#define  USERFREE      4
#define  CONSTANTFREESPACE 89
#define  CONSTANTFILEFREESPACE 816
#define  MAXNODES    128
#define  MAXAKA       16
#define  MAXMESS    1024
#define  MAXMESSALL 1024
#define  MAXFILES    400
#define  MAXBAUDREC   11

/****** Take Note ********************************************************
Boolean can be defined as a Char value under C or as an enum with a
true/false value under C++ (if compiled with enum to char switch)
WARNING: Make sure that you don't have another header which defines Boolean
**************************************************************************/
/* typedef char Boolean; */

/* The following can also be defined as enum under C++ */
typedef char AskType;          /* 0=yes, 1=no, 2=ask */
typedef char PhoneType;        /* 0=business, 1=data, 2=nophone */
typedef char MsgType;          /* 0=localmail, 1=netmail, 2=echomail, 3=passthru, 4=waitthru, 5=allmail */
typedef char MsgKindsType;     /* 0=public, 1=private, 2=private or public */
typedef char ShowFileSizeType; /* 0=nosize, 1=size in bytes, 2=size in kbytes */

/* Swapping Types : 0=None, 1=Ems, 2=Xms, 3=Disk, 4=EmsXms, 5=XmsEms */

typedef unsigned char MaxStr[256];
typedef unsigned char UserString[36];
typedef unsigned char Date[9];
/* typedef unsigned char Str3[4]; */
typedef unsigned char Str8[9];
/* typedef unsigned char Str30[31]; */
typedef unsigned char FlagType[4];
typedef unsigned char PathString[61];

/*************************************************************************
 * Datetime record as defined under Turbo Pascal
 *************************************************************************/
typedef struct DATETIME
{
    unsigned int year,
                 month,
                 day,
                 hour,
                 min,
                 sec;
}DATETIME;

typedef struct DATERECORD
{
    unsigned int  year;
    unsigned char month,
                  day;
}DATERECORD;

typedef struct ONOFFFLAGS
{
    FlagType      onflags;
    FlagType      offflags;
}ONOFFRECORD;

typedef struct NETRECORD
{
    unsigned int  zone,
                  net,
                  node,
                  point;
}NETRECORD;

/********************************************************************
 * USERS.BBS record structure
 *
 *     attribute bit 0 : deleted
 *               bit 1 : clear screen
 *               bit 2 : more prompt
 *               bit 3 : ansi capable
 *               bit 4 : don't kill user
 *               bit 5 : file points ignore
 *               bit 6 : full screen ed
 *               bit 7 : quiet mode
 *
 *    attribute2 bit 0 : ignore file ratios
 *               bit 1 : extended ibm characters
 *               bit 2 : on = mmddyy off = ddmmyy
 *               bit 3 : ignore paging hours
 *               bit 4 : exclude user
 *               bit 5 : avatar capable
 *               bit 6 : ignore menu time restrictions
 *               bit 7 : ignore message ratios
 *
 *    attribute3 bit 0 : do not sound page
 *                   1 : page on logon
 *                   2 : hold mailbox
 *                   3 : use combined mailbox
 *                4..7 : Reserved
 *
 *    attribute4 bit 0..7 reserved
 ********************************************************************/
typedef struct USERSRECORD
{
    UserString    name,                   /* Users Name */
                  alias;                  /* Users Alias */
    unsigned char password[16];           /* Users Password */
    unsigned int  security;               /* Users SecLvl */
    unsigned char attribute,              /* See Type Comment */
                  attribute2,             /* See Type Comment */
                  attribute3,             /* See Type Comment */
                  attribute4;             /* See Type Comment */
    FlagType      flags;                  /* Users Access Flags */
    unsigned char dataphone[15],          /* Users Data Phone No: */
                  voicephone[15];         /* Users Voice Phone No: */
} USERSRECORD;


/********************************************************************
 * USERSEXT.BBS record structure
 *
 * colour?_? : To retrieve the first colour  " && 15 "
 *             To retrieve the second colour " >> 4  "
 ********************************************************************/
typedef struct USERSEXTRARECORD
{
    unsigned char location[26];              /* Users Location */
    long int      lasttimedate;              /* (Dos packed) Last Login Date Time */
    unsigned int  credit,                    /* Netmail Credit */
                  pending;                   /* Netmail Points Pending */
    unsigned int  msgsposted,                /* Msgs posted */
                  nocalls,                   /* Times Called */
                  uploads,                   /* Users Uploads (Files) */
                  todayk,                    /* K's Downloaded today */
                  timeused,                  /* Time Used today */
                  downloads;                 /* Users Downloads (Files) */
    long int      uploadsk,                  /* Kilobytes Uploaded */
                  downloadsk;                /* Kilobytes Downloaded */
    unsigned char screenlength,              /* Users Screen Length */
                  lastpwdchange;             /* Logons since password last changed */
    unsigned int  timebanked,                /* Time banked by user */
                  ksbanked,                  /* Kilobytes banked by user */
                  filepoints;                /* Filepoints remaining */
    unsigned char qwkcompression,            /* QWK Compression Type */
                  qwkdaysold;                /* QWK Days old to pack mail */
    unsigned char comment[41];               /* Sysops comment about user */
    unsigned char colour1_2,                 /* Message\File area colors */
                  colour3_4,                 /* Message\File area colors */
                  colour5_6,                 /* Message\File area colors */
                  colour7_8,                 /* Message\File area colors */
                  bkcolour;                  /* Message\File area colors */
    unsigned char sessionfailures;           /* Number of Session Failures */
	 unsigned char topmenu[9];                /* Name of Top Menu to show to user */
    unsigned int  filepointsgiven;           /* File Points given since last session */
    DATERECORD    dateofbirth;               /* Users date of birth */
    unsigned char groups[4];                 /* User Groups */
    unsigned int  regodate,                  /* Users Registration date */
                  firstdate,                 /* Date of first logon */
                  lastfiledate;              /* Date of last New files listing */
    char          defprotocol;               /* Blank = NO protocol defined */
    unsigned int  timeleft;                  /* Users time left today */
    unsigned int  filearea;                  /* Last file area accessed by user */
    unsigned int  messarea;                  /* Last message area access by user */
    long int      qwkmaxmsgs;                /* Maximum Msgs for QWK Pkt */
    unsigned char qwkmaxmsgsperarea;         /* Maximum Msgs per area */
    signed int    todaybankwk;               /* Kilobytes withdrawn/deposit today */
    unsigned char fordwardto;                /* Who to Forward Msgs to */
    unsigned char todaycalls;                /* Number of Calls today */
    signed int    todaybankwt;               /* Minutes withdrawn/deposit today */
    char          extraspace[USERFREE];      /* For future expansion */
} USERSEXTRARECORD;

/********************************************************************
 * LASTCOMB.BBS record structure
 * This file grows and shrinks for EACH User depending on the
 * number of message areas defined in the configuration
 ********************************************************************/
typedef struct USERSLASTRECORD
{
    unsigned int  combinedinfo;
    unsigned int  lastreadinfo[16];
} USERSLASTRECORD;

/********************************************************************
 * *.MNU record structure
 *
 * attribute bit 0 : test ratio kb's
 *           bit 1 : test message/call ratio
 *           bit 2 : test age <config age> and over
 *           bit 3 : test ratio files
 *           bit 4 : local keyboard
 *            5..7 : [ reserved ]
 *
 * securityattr  0 : greater than or equal to
 *               1 : greater than
 *               2 : less than or equal to
 *               3 : less than
 *               4 : equal to
 *               5 : not equal to
 ********************************************************************/
typedef struct MNURECORD
{
    unsigned char typ;              /* Menu option number */
    unsigned int  security;         /* SecLvl required to access option */
    FlagType      flags;            /* Flags required to access option */
    unsigned char display[91];      /* String to display to user, ";" = no display */
    char          hotkey;           /* Ctrl-A means Automatic Option */
    unsigned char miscdata[91];     /* Misc data field */
    unsigned char colour;           /* Display Colour */
    unsigned char securityattr;     /* Security Testing Condition */
    unsigned char timeonline;       /* Minutes before user can access option */
    unsigned int  timestart;        /* Time for option to become active */
    unsigned int  timeend;          /* Time option is no longer active */
    long int      baudrate;         /* minimum baudrate to use option */
	 unsigned int  filepoints;       /* minimum filepoints to use option */
    unsigned char attribute;        /* See Type Comment */
    unsigned char node;             /* Nodes which can access option (0=All) */
} MNURECORD;

/********************************************************************
 * PROTOCOL.EZY record structure
 *
 * attribute bit 0 : enable/disable
 *           bit 1 : batch protocol
 *           bit 2 : [ reserved ]
 *           bit 3 : both directions
 *           bit 4 : up/down
 *           bit 5 : bidirectional (ONLY Works on Uploads)
 *            6..7 : [ reserved ]
 ********************************************************************/
typedef struct PROTOCOLRECORD
{
    unsigned char name[16];                /* Protocol name to be displayed */
    char          activekey;               /* Hotkey which selects protocol */
    unsigned char attribute;               /* See Type Comments */
    PathString    logfilename,             /* eg: Dsz logfile */
                  ctlfilename,             /* Protocol control file name */
                  dnctlstring;             /* String used by prot to indicate batch list */
    unsigned char dncmdstring[101],        /* Download command string */
                  upcmdstring[101];        /* Upload command string */
    unsigned char uplogkeyword[11],        /* Upload Key in Log */
                  dnlogkeyword[11],        /* Download Key in Log */
                  uperrkeyword[11],        /* Upload Error Key in Log */
                  dnerrkeyword[11],        /* Download Error Key in Log */
                  uperr2keyword[11],       /**/
                  dnerr2keyword[11];       /**/
    unsigned char xfernamewordnum,         /**/
                  xfercpswordnum;          /**/
    unsigned int  security;                /* SecLvl required to use this protocol */
    FlagType      flags;                   /* Flags required to use this protocol */
    unsigned char efficiency;              /* Protocols efficiency percentage */
} PROTOCOLRECORD;

/********************************************************************
 * CONFIG.<EZY or NODE> structure
 *
 * unknownarea = 0 - kill messages
 *               1 - make a new echomail area
 *               2 - make a new passthru area
 *
 * tossattr2 = bit 0 - [ reserved ]
 *                 1 - [ reserved ]
 *                 2 - kill bad archives
 *                 3 - arcmail 0.6 compat
 *
 * autodetect = bit 0 - Auto Detect Ansi
 *                  1 - Ansi Detect for New User
 *                  2 - Auto Detect Emsi
 *                  3 - auto detect emsi & for newuser
 *
 * tossattr = bit 0 : [reserved]
 *                1 : [reserved]
 *                2 : [reserved]
 *                3 : dupe detection
 *                4 : delete netmail on import
 *                5 : keep echoarea node receipts
 *                6 : allow message rescan
 *                7 : [reserved]
 *
 * multitasker = 0 = do not detect or use any multitasker
 *               1 = auto-detect
 *               2 = desqview (or compatiable)
 *               3 = double dos
 *               4 = OS.2
 *               5 = multidos plus
 *               6 = Taskview
 *               7 = Topview
 *               8 = PC MOS
 *               9..255 [reserved]
 *
 * printerport = 0 = LPT1
 *               1 = LPT2
 *               2 = LPT3
 *               3 = COM1
 *               4 = COM2
 *               5 = COM3
 *               6 = COM4
 ********************************************************************/
typedef struct CONFIGRECORD
{
    unsigned char version[9],
                  deflanguage[9],
                  freespace50[68],
                  logpath[61],
                  textpath[61],
                  menupath[61],
                  mnurampath[61],
                  netmailpath[61],
                  nodelistpath[61],
                  msgpath[61],
                  filepath[61],
                  freespace51[61],
                  bipath[61],
                  temppath[61],
                  userbasepath[61],
                  avatarpath[61],
                  ascpath[61],
                  asclowpath[61],
                  filemaint[61],
                  fileattachpath[61],
                  soundpath[61],
                  fastindexpath[61],
                  systempwd[16],                 /* Password to Logon System */
                  sysoppwd[16],                  /* Password to Keyboard */
                  newuserpwd[16],                /* Password for Newuser */
                  newtopmenu[9],                 /* NewUser TopMenu */
                  freespace52[4],
                  inboundmail[61],
                  outboundmail[61],
                  uploadpath[61],
                  swapfile[61],
                  multipath[61],
                  brackets[3],
                  inactivitytime,
                  minmesscheck,
                  maxlogintime,
    /* unused */  freespace53,
                  answerdelay;
    unsigned char shellswap,
                  highbit,
                  disppass,
                  asklocalpass,
                  fastlogon,
                  sysopremote,
                  printerlog,
                  phone1ask,
                  colourask,
                  aliasask,
                  dobask,
                  phoneforce,
                  direct_video,
                  snow_check;
    char          freespace54;
    char          screen_blank;
    unsigned char oneword;
    AskType       checkmail,
                  checkfile,
                  ansiask,
                  fullscreenask,
                  clearask,
                  moreask,
                  avatarask,
                  extendask,
                  usdateask;
    unsigned char phone2ask,
                  phoneformat[15],
                  nameprompt[61],
                  pwdprompt[61],
                  shellprompt[61],
                  shell2prompt[61],
                  enterprompt[61],
                  chatprompt[61],
                  listprompt[61];
   unsigned char  f7keylinetop[80],
                  f7keylinebot[80],
                  freespace55[84],
                  chat2prompt[61],
                  screenlengthprompt[61], /* */
                  screenclearprompt[61],  /* */
                  locationprompt[61],
                  freeprompt[61],
                  loadprompt[61],
                  avatarprompt[61],       /* */
                  aliasprompt[61];
     unsigned int security,
                  logonsecurity;
     FlagType     flags;
    unsigned char minpasslength,
   /* Constant */ dispfwind,                /* Status Bar Colour */
   /* Constant */ dispbwind,                /* Status Bar Colour */
   /* Constant */ disppopupf,               /* Popup Forground  */
   /* Constant */ disppopupborder,          /* Popup Border     */
   /* Constant */ disppopupb,               /* Popup Background */
   /* Constant */ dispf;                    /* Foreground Colour */
    unsigned char freespace56,
                  comport,
                  passlogons,
                  doblogon,
                  printerport,
                         /* 0 : LPT1
                            1 : LPT2
                            2 : LPT3
                            3 : COM1
                            4 : COM2
                            5 : COM3
                            6 : COM4  */
                  passtries;
    unsigned char topmenu[9];
    unsigned char freespace100[4];
     unsigned int watchmess,
   /* constant */ netmailcredit,
                  ansiminbaud,
   /* unused */   freespace57,
                  slowbaud,
                  minloginbaud,
                  lowsecuritystart,
                  lowsecurityend,
                  slowstart,
                  slowend;
            char  quotestring[6],
                  freespace58,
                  offhook;
    unsigned int  forcecrashmail,
                  optioncrashmail,
                  netmailfileattach;
    unsigned char popuphighlight,
                  freespace59,
                  maxpages,
                  maxpagefiles,
                  pagelength;
     unsigned int pagestart[7],
/* constant */    pagemessboard,
                      /* Message Board for Paging (0=Not In Use) */
                  localfattachsec,
                  sectouploadmess,
                  sectoupdateusers,
                  readsecnewecho,
                  writesecnewecho,
                  sysopsecnewecho;
    unsigned int  secreplyvianetmail;
        AskType   netmailkillsent;
    unsigned char swaponarchive;

	unsigned char freespace60[9];

    unsigned char popuptext;
    unsigned int  pageend[7];
    unsigned char freespace61[22];
    unsigned int  incomingcallstart,
                  incomingcallend,

  /* unused */    freespace62;

	 unsigned char altf[10][61],
                  ctrlf[10][41],
   /* unused  */  freespace63[4];
    unsigned int  fp_credit;             /* Newuser Filepoints */
    unsigned char ks_per_fp,             /* Number of Kilobytes per FP */
                  fp_upload,             /* Filepoints Upload Credit */
                  rego_warn_1,
                  rego_warn_2;
   char           freespace64[2];
   unsigned int   min_space_1;
   unsigned char  swapbimodem,
                  modembusy,                /* Toggle DTR or ATH1 */
                  scrheight,                /* 43/50 line mode */
                  msgtmptype,               /* True  = MSGTMP False = MSGTMP.<node> */
                  swapupload;
   char           phonelogon,
                  carrierdetect;           /* Carrier Detect (Default=$80) */
   unsigned char  newfileshighlight;
   char           max_descrip,
                  min_descrip;
   unsigned int   requestreceipt;
   char           ushowdate;
   char           ufilesizek;
   unsigned char  uuploader,
                  udownloadcount,
 /* unused */     freespace4,
                  ushowsecurity,
                  sshowdate;
   char           sfilesizek;
   unsigned char  suploader,
                  sdownloadcount,
 /* Unused */     freespace5,
                  sshowsecurity,
                  ushowtime,
                  ushowfp,
                  sshowtime,
                  sshowfp;
    unsigned int  fp_percent;             /* Download Filepoints Credit */
    char          autodetect;
                        /* Bit 0 : Auto Detect ANSI
                               1 : ANSI Detect for NewUser
                               2 : Auto Detect IEMSI
                               3 : IEMSI Detect for NewUser
                               4-7 [Reserved] */
    unsigned char dispsecurityfile,
                  askforpagereason,
                  delincompletefiles;
   char           freespace65;
   char           swaponfeditview;

   char           freespace6,
                  secfileschar,
                  passchar;
   unsigned char  localinactivity;
   char           conversiononmaster;
   char           leftbracket[2],
                  rightbracket[2];
   unsigned int   ignorefp;               /* Min Security to Ignore FPs */
   char           menuminage;             /* Minimum Age for Age Checks */
   char           freespace66;
   unsigned int   modemeff[MAXBAUDREC],
                  modembaud[MAXBAUDREC];
   unsigned char  modemconnect[MAXBAUDREC][16];
   char           freespace67[10];
   unsigned int   configattr;
                      /*  Bit  0 : Move Local Uploads
                               1-15 [Reserved] */
   char           usercol1_2,
                  usercol3_4,
                  usercol5_6,
                  usercol7_8,
                  userbkcol,
                  newusercol2,
                  chstatcol,
                  getentercol;
   unsigned char  usdateforsysop,
                  ezyovrpath[61];
   UserString     sysfree3;
   unsigned char  ovrems;
   char           swapezy,
                  filesecpath[61];
   unsigned char  freespace28;
   char           multitasker;
                     /*  0 = Do Not Detect or Use Any MultiTasker
                         1 = Auto-Detect
                         2 = Desqview
                         3 = Double DOS
                         4 = OS 2
                         5 = MultiDOS Plus
                         6 = Taskview
                         7 = Topview
                         8 = PC MOS
                         9..255 [Reserved] */
   unsigned int   maxbaud;                /* longint in 1.02 */
   unsigned char  lockedport;
   unsigned int   filereqsec;
   unsigned char  autoanswer,
                  initresponse[11],
                  ringstring[11];
   char           inittries,
                  initstring1[61],
                  initstring2[61],
                  busystring[21],
                  answerstring[21],
                  mailerstring[61];
   unsigned int   modemstart,
                  modemend;
   char           modemdelay;
   unsigned char  sendbreak;
    unsigned char externaleditor[61],
                  defaultorigin[51],
                  connectfax[16];
   char           freespace22[16];
   unsigned int   uploadcredit;
   /* Upload Credit Percentage */
   char           sysfree4[36];        /**/
   char           shownewfileschar;
                        /* 0 - No
                           1 - ASCII Only
                           2 - Always */
   unsigned int   zonea[16],  /* unused */
                  neta[16],
                  nodea[16],
                  pointa[16],
   /* Unused   */ freespace24[16];
   char           freespace9[16][21],
                  nocarrierstring[21];
   UserString     guestaccount;
   char           freespace[MAXFREE];
} CONFIGRECORD;

/********************************************************************
 * CONSTANT.EZY record structure
 *
 * scantossattr = bit 0 : Dupe Detection
 *                    1 : Kill Null Netmail
 *                    2 : Keep EchoArea Node Receipts
 *                    3 : Import Messages To Sysop
 *                    4 : Route Mail (Off = Direct)
 *                    5 : Kill Bad Archives
 *                    6 : ARCMail 0.6 Compatability
 *                   7-15 [Reserved]
 *
 * constantattr = bit 0 : Sysop Alias in Chat
 *                    1 : Auto Log Chat
 *                    2 : Display Full Message To User
 *                    3 : Do not delete outbound mail bundles with no .MSG
 *                   4-15 [Reserved]
 *
 * unknownarea  =     0 : Kill Messages
 *                    1 : Make a New EchoMail Area
 *                    2 : Make a New PassThru Area
 *
 ********************************************************************/
typedef struct CONSTANTRECORD
{
   unsigned char  version[9];
   unsigned char  system[41];
   UserString     sysopname,
                  sysopalias;
   unsigned char  systemlocation[36];
   unsigned char  multiline;              /* (B) */
   unsigned int   maxmess,                /* maximum usable message areas */
                  maxfile;                /* maximum usable file areas */
   unsigned int   watchmess,              /* watchdog message board */
                  pagemessboard,          /* paging message board */
                  badpwdmsgboard;         /* bad pwd message board */
   unsigned char  mintimeforcall;         /* minimum time to register call */
   unsigned char  freespace2[11];
   unsigned int   scantossattr,
                  constantattr;
   unsigned int   maxmsgsrescan;          /* maximum msgs to rescan (0=disable) */
   unsigned char  qwkfilename[9];
   unsigned int   qwkmaxmail,
                  qwkmsgboard;
   NETRECORD      netaddress[MAXAKA];
   unsigned int   netmailboard[MAXAKA];
   unsigned char  newareagroup[MAXAKA];
   unsigned int   newareastmess[MAXAKA];
   unsigned char  quotestring[6];
   unsigned char  swaponezymail;
   unsigned char  unknownarea;
   unsigned char  swaponfeditview,
                  swaponarchive;
	unsigned int   minspaceupload;
   unsigned char  textinputcolour;
	unsigned int   badmsgboard;
   unsigned char  freespace[CONSTANTFREESPACE];
} CONSTANTRECORD;

typedef struct COMPRESSRECORD
{
    unsigned char echounarccmd[6][13];
    unsigned char echounarcpar[6][19];
    unsigned char echoarccmd[6][13];
    unsigned char echoarcpar[6][19];
} COMPRESSRECORD;

typedef char DOMAINTYPE[MAXAKA][21];

typedef struct CONSTANTFILERECORD
{
	CONSTANTRECORD constantrecord;
	char           space[CONSTANTFILEFREESPACE];
	COMPRESSRECORD compress;
	DOMAINTYPE     domaintype;
} CONSTANTFILERECORD;

/********************************************************************
 * LIMITS.EZY record structure
 ********************************************************************/
typedef struct LIMITSRECORD
{
    unsigned int  security;
    unsigned int  time;
    unsigned int  limit[11];
    unsigned char ratio;
    unsigned int  credit;
    unsigned char ratiok;
    unsigned int  creditk;
    unsigned int  regodays;
    unsigned int  creditmess;
    unsigned int  mess;
    unsigned int  timerpercall;
    unsigned char callsperday;
    unsigned char freespace;
    unsigned int  maxbankwk,
                  maxbankwt,
                  maxbankdk,
                  maxbankdt,
                  maxkbank,
                  maxtbank;
} LIMITSRECORD;


/********************************************************************
 * FILEPATH.EZY record structure
 *
 * attribute = bit 0 : cd rom path
 *                 1 : show as not found
 *                 2 : free downloads
 *                 3 : age check (config age or over)
 *              4..7 : reserved
 ********************************************************************/
typedef struct FILEPATHRECORD
{
    PathString    filepath;
    unsigned int  security;
    FlagType      flags;
    unsigned int  uploadarea;
    unsigned char password[9];
    unsigned char attribute;
} FILEPATHRECORD;


/********************************************************************
 * FILESEC.EZY structure
 *
 * attribute = bit 0 : [ reserved ]
 *                 1 : show as not found
 *                 2 : free downloads
 *                 3 : age check (config age or over)
 *              4..7 : [ reserved ]
 *
 ********************************************************************/
typedef struct FILESECRECORD
{
    unsigned char filename[13];
    unsigned int  security;
    FlagType      flags;
    unsigned char password[9];
    unsigned char attribute;
} FILESECRECORD;


/*****************************************************************
 * FILExxx.EZY record structure
 *
 * attribute = bit 0 : checked
 *                 1 : reserved
 *                 2 : offline
 *                 3 : reserved
 *                 4 : private
 *                 5 : deleted
 *                 6 : reserved
 *                 7 : security
 *
 *****************************************************************/
typedef struct FILELISTRECORD
{
    unsigned char filename[13];
    unsigned char description[51];
    long int      fsize;             /* Shown in Bytes */
    unsigned int  fdate;
    unsigned char attribute;
    unsigned char attribute2;       /* reserved */
    UserString    uploader;
    unsigned int  downloads;
} FILELISTRECORD;


/**************************************************************
 * FILES.EZY structure
 *
 * attribute = bit 0 : keep files offline
 *             bit 1 : offline allowed
 *             bit 2 : sortby date
 *             bit 3 : sortby alpha
 *             bit 4 : master list
 *             bit 5 : age testing using < age in config
 *              6..7 : [ reserved ]
 *
 *   convert = 0 : none
 *             1 : zip
 *             2 : lzh
 *             3 : arj
 *             4 : pak
 *             5 : arc
 *             6 : zoo
 *        7..255 : [ reserved ]
 *
 **************************************************************/
typedef struct FILERECORD
{
    unsigned char name[31];
    unsigned char attribute,
                  convert;
             char filegroup;
    unsigned int  uptemplate,
                  upfilepath;
    long int      freespace;
    unsigned int  security;
    FlagType      flags;
    unsigned int  syssecurity;
    FlagType      sysflags;
} FILERECORD;


/*************************************************************
 * EZYDOWN.<NODE> record structure  (Pre-Download)
 *************************************************************/
typedef struct PREDOWNLOADRECORD
{
    unsigned char filename[13];     /* */
    MaxStr        locationfile;     /* */
    long int      fsize;            /* File Size in kilobytes */
    char          freedown;         /* (B) */
    long int      timetodown;       /* download time in Seconds */
    char          deleted;          /* (B) */
} PREDOWNLOADRECORD;


/*************************************************************
 * EZYUP.<NODE> record structure (Pre-Upload)
 *************************************************************/
typedef struct PREUPLOADRECORD
{
    unsigned char filename[13];     /* */
    unsigned char description[51];  /* */
    char          isdupe;           /* (B) */
} PREUPLOADRECORD;


/*************************************************************
 * MAINT1.BBS - MAINT2.BBS record structures
 *************************************************************/
typedef struct MAINT_RECORD
{
    unsigned char filename[13];
    unsigned int  filepoint;
    UserString    downloader,
                  uploader;
} MAINT_RECORD;


/*************************************************************
 * Fast Find Index record structures
 * Information Below Explains how to fill the FASTINDEXRECORD.name Field
 * Filenames are PADDED to fill out the fields as follows.
 * Filename = 8 bytes
 * FileExt  = 4 bytes consisting of a .(Period) + 3 Alpha/Numeric chars
 * Length Byte Precedes the string in Pascal and is replaced with
 * a NULL or Terminating char under C.
 * If at anytime Filename or FileExt do not fill their fields
 * they are to be padded with spaces.
 * eg: DUMMY.LZH = "DUMMY   .LZH", or, DUMMY.L = "DUMMY   .L  "
 *
 * An easy way to achieve this under Turbo or Borland C follows.
 *
 * fnsplit(filename,drv,pth,fnm,ext);
 * sprintf(FASTINDEXRECORD.name,"%-8.8s%-4.4s",fnm,ext);
 *************************************************************/
typedef long int FastPointerRecord[730];  /* FFPTR.EZY */
typedef struct FASTINDEXRECORD    /* FFIDX.EZY */
{
    unsigned char name[13];
    unsigned int  template;        /* directory of file 1 -> */
    char          deleted;         /* boolean */
} FASTINDEXRECORD;


/*************************************************************
 * ONLINE.BBS record structure
 *
 * status =   0: active
 *            1: reserved
 *            2: downloading
 *            3: uploading
 *            4: bimodem transfer
 *            5: message browsing
 *            6: door/outside
 *            7: in chat with sysop
 *            8: in chat with other users - channel 000
 *          ???: in chat with other users - channel ???
 *          207: in chat with other users - channel 199
 *      208-252: [reserved]
 *          253: node not active in any way
 *          254: user in login process
 *          255: waiting for caller
 *************************************************************/
 typedef struct ONLINERECORD
 {
    UserString    name,            /* Should Blank if NO user online */
                  alias;
    unsigned char status;
    unsigned char attribute;
    long int      baud;
    unsigned char location[26];
} ONLINERECORD;

/*************************************************************
 * MESSNODE.<NODE> record structure
 *************************************************************/
typedef struct MULTIMESSAGERECORD
{
    UserString    from;         /* From Username */
    unsigned int  fromnode;     /* From Node */
    unsigned char message[81];
    char          private;      /* boolean */
} MULTIMESSAGERECORD;

/*************************************************************
 * BESTSTAT.BBS record structure
 *
 *    bestname[0] is for bestmessages
 *    bestname[1] is for bestcalls
 *    .....
 *    bestname[6] is for bestdownk
 *
 *************************************************************/
typedef struct BESTUSERRECORD
{
    unsigned char bestname[7][36];
    unsigned int  bestmessages,
                  bestcalls,
                  bestups,
                  bestdns,
                  bestfps;
    long int      bestupk,
                  bestdownk;
} BESTUSERRECORD;


/*************************************************************
 * MSGHxxx.BBS record structure
 *
 * msgattr = bit 0    deleted
 *               1    netmail pending export
 *               2    [reserved]
 *               3    private
 *               4    received
 *               5    echomail pending export
 *               6    locally generated msg
 *               7    do not kill message
 *
 * netattr = bit 0     kill/sent
 *               1     sent
 *               2     file attach
 *               3     crash
 *               4     file req
 *               5     request reciept
 *               6     audit request
 *               7     is a return reciept
 *
 * extattr =  bit 0-7   [reserved]
 *
 *************************************************************/
typedef struct MSGHDRRECORD
{
    unsigned int  prevreply,
                  nextreply;            /* 0=No Reply Chain */
    long int      startposition,        /* Byte Offset of Text in MSGTxxx.BBS */
                  messagelength;        /* Length of msg including Null terminator */
    NETRECORD     destnet,
                  orignet;
    unsigned int  cost;
    unsigned char msgattr;
    unsigned char netattr;
    unsigned char extattr;
    long int      posttimedate;         /* Dos format packed time & date */
    long int      recvtimedate;         /* Dos format packed time & date */
    UserString    whoto,
                  whofrom;
    unsigned char subject[73];
} MSGHDRRECORD;


/*************************************************************
 * MSGFAST.BBS record structure
 *
 * standard 32 Bit CRC on whoto in MSGH???.BBS
 * Username is CRCd in UPPERCASE, and does not
 * include null terminator or length byte
 *
 *************************************************************/
typedef struct MSGFASTRECORD
{
    long     int  whoto;       /* 32 bit CRC on WhoTo in MSGHxxx.BBS */
    unsigned int  msgboard,
                  msgnumber;
} MSGFASTRECORD;


/*************************************************************
 * MSGEXPRT.BBS
 * file of maxmess records defining if area needs echo/netmail scan
 *************************************************************/
typedef char needscanrecord[MAXMESS];  /* boolean */

/*************************************************************
 * MSGREPLY.BBS
 * file of maxmess records defining if area needs reply chaining
 *************************************************************/
typedef char needreplytype[MAXMESS];  /* boolean */


/*************************************************************
 * MSGTxxx.BBS structure definition (No Predefined Rec Size)
 *
 * Each text part of a message starts at "Startposition" and
 * continues until a NULL terminator is found, or EOF is reached.
 * Msg Text length is limited to 16Meg as defined by Turbo Pascal
 * The messagelength MUST be the same length as the message text
 * including the NULL terminator, as MSGCOMP uses this field for
 * speed and for kilobyte deletion
 *************************************************************/


/*************************************************************
 * MESSAGES.EZY record structure
 *
 * attribute = bit 0 : allow aliases
 *                 1 : use alias
 *                 2 : use alias, ask for aliases
 *                 3 : test age as defined in config.xx
 *                 4 : combined area access
 *                 5 : local file attaches
 *                 6 : strip private bit on incoming echomail
 *                 7 : security
 *
 * attribute2 = bit 0 : show seenby lines
 *                  1 : forced mail check
 *                  2 : strip forward seenbys
 *               3..4 : [reserved]
 *                  5 : areafix info visible
 *                  6 : initial combined area access
 *                  7 : Do Not use in Template
 *
 * attribute3 = [Reserved]
 *
 * destnode = nodes  1 to  8 - destnode[1]
 *            nodes  9 to 16 - destnode[2]
 *            nodes 17 to 24 - destnode[3]
 *            etc, etc, etc.
 *
 *************************************************************/
typedef struct MESSAGERECORD
{
    unsigned char name[31];
    unsigned char areatag[31];
    unsigned char qwkname[13];
    MsgType       typ;              /* msgtype */
    MsgKindsType  msgkinds;         /* msgkinds type */
    unsigned char attribute,
                  attribute2,
                  attribute3;
    unsigned char dayskill,
                  recvkill;
    unsigned int  countkill,
                  kilobytekill,
                  readsecurity;
    FlagType      readflags;    /* Flagtype */
    unsigned int  writesecurity;
    FlagType      writeflags;      /* Flagtype */
    unsigned int  sysopsecurity;
    FlagType      sysopflags;      /* Flagtype */
    unsigned char originline[51];
    unsigned char originaddress;
    unsigned char seenby[MAXAKA/8];
    char          areagroup,
                  messgroup;
    unsigned char destnodes[MAXNODES/8];
    unsigned char echomailfeed;           /* 0=No Uplink */
} MESSAGERECORD;


/*************************************************************
 * ECHOMGR.EZY record structure ( 1 to 128 records )
 *
 * compress = 0 : compress to zip
 *            1 : compress to lzh
 *            2 : compress to arj
 *            3 : compress to arc
 *            4 : compress to pak
 *            5 : compress to zoo
 *            6 : compress to sqz
 *
 * attribute = bit 0 : node active
 *                 1 : crash mail
 *                 2 : hold mail
 *                 3 : node can create new echos
 *                 4 : add node to export on new echo creation
 *                 5 : Direct Mail (Off=Mail Routed)
 *               6-7 : [reserved]
 *
 * sendpkttype = 0 : type 2
 *               1 : type 2+
 *               2-255 [reserved]
 *
 *************************************************************/
typedef struct ECHOMGRRECORD
{
    NETRECORD     destnet;
    unsigned char redirectto;
    unsigned char groups[4];
    unsigned char compress;
    unsigned char attribute;
    unsigned char passwordto[21],
                  passwordfr[21];
    unsigned char dayshold,
                  sendpkttype;
} ECHOMGRRECORD;


/*************************************************************
 * EVENTS.EZY record structure
 *
 * attribute = bit 0 : enabled
 *              1..7 : [reserved]
 *
 * days = bit 0 : sunday
 *            1 : monday
 *            ...
 *            6 : saturday
 *            7 : [reserved]
 *
 *************************************************************/
typedef struct EVENTRECORD
{
    unsigned char attribute;
    unsigned int  starttime;     /* msb=Hour, lsb=Minutes */
    unsigned char errorlevel;
    unsigned char days;
    unsigned int  lasttimerun;
} EVENTRECORD;


/*************************************************************
 * TODAY.BBS & YESTER.BBS record structure
 *
 * didwhat = bit 0 : (n) new user
 *               1 : (u) upload
 *               2 : (d) download
 *               3 : (r) read mail
 *               4 : (s) sent mail
 *               5 : (o) door/outside
 *               6 : (c) chat with sysop and/or user(s)
 *               7 : (p) paged sysop
 *
 *************************************************************/
typedef struct ONTODAYRECORD
{
    unsigned char line;
    UserString    name,
                  alias;
    unsigned char location[26];
    unsigned int  baudrate;
    unsigned int  logontime;
    unsigned int  logofftime;
    unsigned char didwhat;
} ONTODAYRECORD;


/*************************************************************
 * system usage record structure
 *************************************************************/
typedef struct USEAGERECORD
{
    unsigned int  startdate;
    long int      busyperhour[24];  /* Minutes Used */
    long int      busyperday[7];    /* Minutes Used */
} USEAGERECORD;


/*************************************************************
 * MSGINFO.<Node>
 * Created when external FSE called
 *
 * returnstatus = 0 = FSE Record Not Used
 *                1 = Message Saved
 *                2 = Message Aborted
 *                3 = User Inactivity
 *                4 = User Hungup
 *                5 = Sysop Hungup
 *
 * attribute = bit 0 : can change subject
 *                 1 : can change whoto
 *                 2 : can change private
 *                 3 : private message
 *                 4 : is message forwarded (false = quoted)
 *                 5 : netmail message
 *                 6 : avatar in use
 *                 7 : echomail message
 *************************************************************/
typedef struct FSERECORD
{
    UserString    whofrom;
    NETRECORD     orignet;
    UserString    whoto;
    NETRECORD     destnet;
    unsigned char subject[73];
    unsigned char returnstatus;
    unsigned char attribute;
    long int      baudrate,
                  lockedbaud;
    unsigned char comport;
    unsigned char screenlength;
    unsigned int  timeleft;
} FSERECORD;


/*************************************************************
 * Used in ExitInfo record (Could be used as Union under C)
 *************************************************************/
typedef struct TIMERECORD
{
    unsigned char hour,
                  min;
} TIMERECORD;


/*************************************************************
 * EXITINFO.<node> record structure
 *
 * iemsi_req1 = bit 0 : News
 *                  1 : Mail
 *                  2 : File
 *                  3 : ClrScr
 *                  4 : Quiet
 *                  5 : More
 *                  6 : FSE
 *                  7 : [Reserved]
 *
 * iemsi_scrlen : Screen Length for current session Only.  If NO Iemsi
 *                session, this is set to users Normal screen length.
 *
 * iemsi_prot = bit 0 : ZModem
 *                  1 : SEAlink
 *                  2 : Kermit
 *               3..7 : [reserved]
 *
 * iemsi_crt  = 0 : TTY
 *              1 : ANSI
 *              2 : AVT0+
 *              3 : VT100
 *              4 : VT52
 *         5..255 : [reserved]
 *
 * iemsi_cap  = bit 0 : CHT
 *                  1 : MNU
 *                  2 : TAB
 *                  3 : ASCII
 *               4..7 : [reserved]
 *
 *************************************************************/
typedef struct EXITINFORECORD
{
    unsigned int  baud,                 /* Speed between Modem<->Modem */
                  lockedbaud;           /* Speed between Modem<->PC */
    unsigned char comport;              /* Com1=1 Com2=2 etc etc */
    unsigned int  efficiency;           /* Baud rate efficiency */
    unsigned int  userrecnum;           /* User Record Number, 0=User_1 */
    USERSRECORD   userinfo;
    USERSEXTRARECORD userextra;
    unsigned char extraspace[128];
    UserString    sysopname,            /* Sysops Name as defined in Config.xxx */
                  sysopalias;           /* Sysops Alias as defined in Config.xxx */
    unsigned char system[41];           /* System Name as defined in Config.xxx */
    unsigned int  downloadlimit;        /* */
    unsigned int  timelimit;
    unsigned int  timetakenevent;         /* Number of Minutes taken from user due to event */
    long int      timecreated;            /* Number of seconds since Midnight */
    long int      timeofnextevent;        /* Number of seconds from midnight */
    unsigned int  timetillnextevent;      /* Number of seconds After timecreated */
    unsigned char dayofnextevent;         /* 0=Sun, 6=Sat, 7=NoEvent */
    unsigned char errorlevelofnextevent;  /* Errorlevel to return from next event */
    unsigned char ratio;
    unsigned int  credit;
    unsigned char ratiok;
    unsigned int  creditk,
                  regodays,
                  creditmess;
    unsigned int  mess;
    DATETIME      logintimedate;
    unsigned char stack[20][9];           /* Menu Stack */
    unsigned char stackpos;               /* Menu Stack Position, 0 = No Stack */
    Str8          curmenu;                /* FileName of Current Menu */
    unsigned char oldpassword[16];
    unsigned int  limitrecnum;            /* Limits Record being used */
    unsigned char baudrecnum;             /* BaudRate record being used */
    char          hibitreplace;           /* HiBit replacement char */
    unsigned char maxpages;               /* Times user can page sysop */
    unsigned char pagedsysop;             /* Times user has paged sysop */
    char          wantchat;               /* boolean */
    long int      pagestart,
                  pageend;                /* Seconds since midnight */
    unsigned char pagelength;
    char          echoentered,            /* boolean */
                  netentered,
                  nextsysop;
    unsigned char inactivitytime;         /* Seconds */
    char          protrecnum;             /* Default Protocol record number, 0=NoDefault */
    unsigned char protname[16];           /* Default Protocol Name */
    unsigned char didwhat;                /* Did what flag for Todays callers */
    unsigned char pagereason[61];
    unsigned char mtasker;                /* 0=No Multitasker, 1=[Reserved] */
             char iemsi_session;          /* boolean */
    unsigned char iemsi_req1,
                  iemsi_req2,
                  iemsi_scrlen;
    unsigned char iemsi_prot,
                  iemsi_crt,
                  iemsi_cap;
    char          pagesound;              /* (B) */
    unsigned char freespace[99];
} EXITINFORECORD;


/*************************************************************
 * sysinfo record structure
 *************************************************************/
typedef struct SYSINFORECORD
{
    long int      callcount;
    UserString    lastcaller;
    long int      filesizek;           /* Updated by EzyFF -C */
    unsigned int  newusers,
                  newfiles,
                  newmessages;         /* Does not include Inbound Echomail */
    UserString    lastalias;
    unsigned int  laststarttime;
    unsigned char extraspace[80];
} SYSINFORECORD;


/*************************************************************************/
/* Some sample C Src to replicate most of the functions shown in the     */
/* Pascal version of the EzyCom Structures  (Turbo/Borland)              */
/*************************************************************************/

/**********************************************************
 * Determine if a file or path exists.
 * Returns 1 if true and 0 if false.
 * To check a path do NOT include the trailing backslash.
 * Note: You could use "findfirst()" for this also.
 *
 * eg: if(exists(filepath)) do_something(); else is_error();
 **********************************************************/
int exists(char *filepath)
{
    return( access( filepath, 0 ) == 0 );
}

/**********************************************************
 * Check if file path has a trailing backslash.
 * It is assumed you won't be stupid enough to pass a NULL
 * length string.
 *
 * eg: fixslash(pathstring);
 **********************************************************/
void fixslash(char *s)
{
	 while(*s) s++;                       /* Move to EOS */
	 if(*(--s) == '\\') return;          /* If Ok return */
    *(++s) = '\\';                       /* Else Add Slash */
    *(++s) = '\0';                       /* Terminate String */
}

/**********************************************************
 * Locate the Config.xxx file
 *
 * The parameter "node" should be declared globaly and
 * initialized to "1" if not otherwise declared either
 * by your own program or the "TASK" environment variable.
 * Note: It's up to you to check these two things.
 *
 * eg: if((pntr=findc(2))==NULL) is_error();
 **********************************************************/
char *findc(int node)
{
    char p[128];                                  /* Temp String Pointer */
    static char path[128];                        /* To store the location */
    char *s[] = {"CONFIG.1","CONFIG.EZY"};

    strcpy(p,getenv("EZY"));                      /* Get EZY Environment value */
    fixslash(p);                                  /* Make sure theres a backslash */

    if(node > 1 && node < 251) sprintf(s[0],"CONFIG.%d",node);

    if(strlen(p) > 1)                             /* If environment path set */
    {
        strcpy(path,p);
        strcat(path,s[0]);
        if(exists(path)) return(path);            /* Env Path + Config.xxx */

        strcpy(path,p);
        strcat(path,s[1]);
        if(exists(path)) return(path);            /* Env Path + Config.Ezy */
    }

    strcpy(path,s[0]);
    if(exists(path)) return(path);                /* Config.xxx in CurDir */

    strcpy(path,s[1]);
    if(exists(path)) return(path);                /* Config.Ezy in CurDir */

    return(NULL);                                 /* Unable to locate config.xx */
}

/**********************************************************
 * Check for a valid date
 *
 * Returns 1 if a valid date and 0 if not.
 *
 * eg: if(!checkdate(1992,1,1)) do_nothing();
 **********************************************************/
int checkdate(unsigned int yy, unsigned int mm, unsigned int dd)
{
    int days[] = {31,29,31,30,31,30,31,31,30,31,30,31};

    if( mm < 1 || mm > 12) return(0);                        /* Invalid Month */
    if( dd < 1 || dd > days[mm-1]) return(0);                /* Invalid Day */
    if(yy < 1900) return(0);                                 /* Your to Old */
    if(((yy%4) != 0) && (dd == 29) &&  (mm == 2)) return(0); /* Tryin to fool me */

    return(1);                                               /* Everything must be valid */
}

/**********************************************************
 * Convert a Date to an Int
 *
 * Returns the converted date on success or 65535 on failure.
 *
 * eg: intdate = dat2int(1992,1,1);
 **********************************************************/
unsigned int dat2int(unsigned int yy, unsigned int mm, unsigned int dd)
{
    unsigned int  tofield=0;

    if(!checkdate(yy,mm,dd) || yy < 1980 || yy > 2107) return(65535);

    tofield = dd-1;
    tofield = tofield + ((mm-1) << 5);
    tofield = tofield + ((yy-1980) << 9);

    return(tofield);
}

/**********************************************************
 * Convert an Int to a Date
 *
 * Returns the converted date in the variables yy,mm,dd
 * and a true false value in relation to the conversion.
 *
 * eg: if(!int2dat(intdate,&year,&mon,&day)) is_error();
 **********************************************************/
int int2dat(unsigned int dat, unsigned int *yy, unsigned int *mm, unsigned int *dd)
{
    unsigned int temp=dat;

    if(dat == 65535) return(0);          /* Invalid Date */

    *dd = (temp & 31) + 1;
    temp >>= 5;
    *mm = (temp & 15) + 1;
    temp >>= 4;
    *yy = (temp & 127) + 1980;
    return(1);                         /* Conversion OK */
}

/**********************************************************
 * Convert a Date and Time to a Long (DOS Packed DateTime)
 *
 * Returns the converted date on success or 0 on failure.
 *
 * eg: longdate = dat2int(1992,1,1,12,53,50);
 **********************************************************/
unsigned long dat2long(unsigned int year, unsigned int month, unsigned int day,
                       unsigned int hour, unsigned int min,   unsigned int sec)
{
    unsigned long  todatefield,totimefield;

    if(!checkdate(year,month,day) || year < 1980 || year > 2107) return(0);

    todatefield = day;
    todatefield = tofield + ((month) << 5);
    todatefield = tofield + ((year-1980) << 9);

    totimefield = (sec >> 1) + (min << 5) + (hour << 12);

    totimefield = totimefield + (todatefield << 16);

    return(totimefield);
}

