/*    Setup script for EZirc

  Creates folder and various other objects
  Adjust paths in INI and scripts for INSTALL path.
*/

Call Init

Setup:
call getkeypress
if proceed = "QUIT" then signal end
if proceed = "NO" then signal setup

Lets_Go:
say '     * Please wait while EZirc is installed to 'dir
say ' '

/* Check that destination exists, if not make it. */
call Directory_Make

/* Define Files to setup on the desktop */
docs = dir"\html\EZIRC.HTM"
exename = dir'\EZIRC.EXE'

say '     Unpacking Distribution Package to 'dir
'@unzip install -d 'dir' > nul'

say '     Customizing the INI'
call ModifyINI
say '     Customizing paths in scripts.'
call ModifyScripts
say '     Creating WPS objects'
call CreateObjects
call SysOpenObject "<EZIRC_FLDR>","DEFAULT","TRUE"

End:
say '     ALL DONE!'
return

/* ===================================================== */
/*               procedures below here.                  */
/* ===================================================== */

Init :

  call RxFuncAdd 'SysLoadFuncs', 'RexxUtil', 'SysLoadFuncs'
  call SysLoadFuncs

/* Define Variables */
dir = directory()
env='OS2ENVIRONMENT'
UserIdent=value('user',,env)
if UserIdent = '' then UserIdent = 'yourID'
testid=pos('@',UserIdent)
if testid > 0 then UserIdent = 'yourID'
realname = 'Your Realname String'
nickname = 'YourNick'

/* trace ?r */
return

greeting:

call SysCls
Say ' '
Say ' '
say '     EZirc Installation.'
say ' '
Say '     This Script will install EZIRC and customise files for you.'
Say ' '
Say '     Current Settings for installation :'
Say ' '
Say '        1)  Install Path : 'dir
Say '        2)  Your User ID : 'UserIdent
Say '        3) Your Realname : 'realname
Say '        4) Your NickName : 'nickname
Say ' '
Say '     Press Enter to Install with above Settings, or # to change. Q to Quit.'
proceed = "NO"
return

getkeypress:
call greeting
say ' '
key = SysGetKey(NOECHO)
say ' '
keyhex = C2X(key)
if keyhex='0D'
   then  /* if key is RETURN */
     proceed = "YES"
   else
    do
      key = translate(key)
      if key = 1
         then
           do
             Say '    Enter Full path to install to, without the trailing /'
             Say '    ie  d:\ezirc     or  d:\internet\ezirc'
             Say ' '
             result=charout(,'    Path : ')
             string = '                                                                                '
             Parse Upper Pull string .
             dir = string
             Call Directory_Check
           end
         else
           if key = 2
              then
                do
                Say '    Enter your User ID from your ID in your email address'
                Say '    ie if your email is xyz@provider.com  you enter xyz'
                Say ' '
                result=charout(,'    UserID : ')
                string = '                                                                                '
                Parse Pull string .
                UserIdent = String
                end
              else
                if key = 3
                   then
                     do
                     Say '    Enter the string you want in your Realname Field when you are connected.'
                     Say '    A typical string might be    Firstname in City/state'
                     Say ' '
                     result=charout(,'    Realname : ')
                     string = '                                                                                '
                     Parse Pull string
                     Realname = string
                     end
                   else
                     if key = 4
                        then
                          do
                          Say '    Enter the NICKNAME you would like to use while on IRC.'
                          Say '    Rules for Nicknames are Max 9 Char. And no special Characters'
                          Say '    Characters like _ for a space are allowed.'
                          Say '    Avoid the | char, as it is used in scripts to seperate multiple commands.'
                          Say ' '
                          result=charout(,'    NickName : ')
                          string = '                                                                                '
                          Parse Pull string .
                          NickName = String
                          end
                        else
                          if key = 'Q'
                             then
                               proceed = "QUIT"
    end
return

Directory_Check:
       /* Check the DRIVE exists */
       testdrive=substr(dir,1,2)
       info = SysDriveInfo(testdrive)
       if info = ''
         then /* No Drive, then lets go back for a new KEY Press */
           do
             say '     Destination Drive Doesn'"'"'t Exist.'
             say '     Resetting to current path'
             dir = directory()
             say '     Press any key to continue'
             key = SysGetKey()
           end
         else
           do
             /* in case user entered a trailing /  Strip it. */
             dir = strip(dir,'T','/')
             dir = strip(dir,'T','\')
           end
return

Directory_Make:

/* Drive Exists, so lets make the path */
say '     Creating Path 'dir
rc = SysMkDir(dir)
if rc = 0
   then
    say'     Directory creation was successful.'
   else
    if rc = 5
       then
        say '     Directory Already Exists. So lets use it.'
       else
        DO
         /* Any other Return Code is an Error, so report and FAIL */
         if rc = 2   then say'     * Error.  File not found.'
         if rc = 3   then say'     * Error.  Path not found.'
         if rc = 26  then say'     * Error.  Not a DOS disk.'
         if rc = 87  then say'     * Error.  Invalid parameter.'
         if rc = 108 then say'     * Error.  Drive locked.'
         if rc = 206 then say'     * Error.  Filename exceeds range.'
         say '     * Fatal Error, can not continue.'
         Signal End
        END
return

ModifyINI:
/* Source File to patch */
source= dir"\ezirc.ini"

/* Lets Load it */
call loadfile

/* for all the following Set the Old and New strings then Search & Replace */
ReplaceString = 'x:'
newstring = dir
call SearchnReplace

replacestring = 'yourID'
newstring = UserIdent
call SearchnReplace

replacestring = 'Your_Realname_String'
newstring = realname
call SearchnReplace

replacestring = 'YourNick'
newstring = nickname
call SearchnReplace

/* Done with this file, lets save it. */
Call SaveFile

Return

ModifyScripts:
/* adjust driver letters in scripts/aliases from x: to install_drive */
ReplaceString = 'x:'
newstring = dir

source= dir"\alias\type_it.cmd"
call ProcessFile

source= dir"\script\finger.cmd"
call ProcessFile

source= dir"\script\page.cmd"
call ProcessFile

source= dir"\script\sendfile.cmd"
call ProcessFile

source= dir"\script\sidoh.cmd"
call ProcessFile

source= dir"\script\siwoohoo.cmd"
call ProcessFile

Return

ProcessFile:
call loadfile
call SearchnReplace
Call savefile
return

CreateObjects:

    If  SysCreateObject("WPFolder","EZirc for Os/2 ","<WP_DESKTOP>","OBJECTID=<EZIRC_FLDR>") then
    do
          If SysCreateObject("WPProgram", "EZirc", "<EZIRC_FLDR>","EXENAME="exename";STARTUPDIR="dir";PROGTYPE=PM")  Then
          do
               Say '     Folder and program objects have been created'
               url1 = 'file:///'docs
               rc = SysCreateObject( 'WPUrl', 'EZirc Manual', '<EZIRC_FLDR>', 'OBJECTID=<EZIRC_MANUAL>;URL='url1';', 'replace' )
          end
          Else
             Say '     * Could not create program object'
    End
    Else
       Say '     * Could not create folder '

return

LoadFile:

lines.0=0
   /* open file for read */
   resultCode = stream( source , 'C', 'OPEN READ')
   if resultCode  \= 'READY:' then
   do
      say 'stream open of 'source' returned "'resultCode'"'
      exit
   end
   /* load each line and store in array lines */
   do while lines( source )
      newline = linein( source )
      /* Store lines in Array LINES */
      count= lines.0 + 1
      lines.0 = count
      lines.count=newline
   end
   /* close file */
   resultCode = stream( source, 'C', 'CLOSE')
   if resultCode  \= 'READY:' then
   do
      say 'stream close returned "'resultCode'"'
      exit
   end

Return

SearchnReplace:
/* Search for replacestring and replace with NewString */

do i=1 to lines.0
   replace_len=length(replacestring)
   dlexist = pos(replacestring,lines.i)
   if dlexist > 0
    then
      do
      lines.i = delstr(lines.i,dlexist,replace_len)
      lines.i = insert(newstring,lines.i,dlexist-1)
      end
    else
      NOP
end
Return

SaveFile:
   '@del 'source
   /* open file for write */
   resultCode = stream( source , 'C', 'OPEN WRITE')
   if resultCode  \= 'READY:' then
   do
      say 'stream open of 'source' returned "'resultCode'"'
      exit
   end

   /* load each line and store in array lines */
   do i=1 to lines.0
      writeline = lines.i
      rc = lineout( source , writeline )
   end

   /* close file */
   resultCode = stream( source, 'C', 'CLOSE')
   if resultCode  \= 'READY:' then
   do
      say 'stream close returned "'resultCode'"'
      exit
   end

return

