//
// $Header: D:/32bits/ext2-os2/uext2/RCS/uext2.c,v 1.1 1996/09/22 23:16:31 Willm Exp Willm $
//

// Linux ext2 file system driver for OS/2 2.x and WARP - Allows OS/2 to
// access your Linux ext2fs partitions as normal drive letters.
// Copyright (C) 1995, 1996 Matthieu WILLM
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

#define INCL_DOS
#include <os2.h>

#include <stdio.h>
#include <stdlib.h>
#include <process.h>

char banner[] ="ͻ\n"
               "      Linux ext2 file system driver for OS/2           \n"
               "  (Built on "__DATE__" at "__TIME__ " in Paris - France) \n"
               "                                                       \n"
               "       EXT2-OS2 VERSION " EXT2OS2_VER " (32 BITS EDITION)         \n"
               "                                                       \n"
               "        Copyright (C) Matthieu WILLM 1995, 1996        \n"
               "                                                       \n"
               "ͼ\n";

typedef char *_Seg16 __pchar16;


int start_program(char *program, short argc, __pchar16 *_Seg16 argv, __pchar16 *_Seg16 envp) {
    int    rc;
    int    i;
    int    c;
    char **__argv_32 = 0;
    char **__envp_32 = 0;
    __pchar16 *__argv_16 = (__pchar16 *)argv;
    __pchar16 *__envp_16 = (__pchar16 *)envp;

    __argv_32 = malloc((argc + 1) * sizeof(char *));
    if (__argv_32) {
        __argv_32[0] = program;
        for (i = 1 ; i < argc ; i++) {
            __argv_32[i] = (char *)(__argv_16[i]);
        }
        __argv_32[argc] = 0;
        if (__envp_16) {
            c = 0; 
            while ((char *)(__envp_16[c])) c++;
            __envp_32 = malloc((c + 1) * sizeof(char *));
            if (__envp_32) {
                for (i = 0 ; i < c ; i++) {
                    __envp_32[i] = (char *)(__envp_16[i]);
                }
                __envp_32[c] = 0;
                rc = spawnvpe(P_WAIT, program, __argv_32, __envp_32);
                if (rc == -1) {
                    fprintf(stderr, "Couldn't start %s. ", program);
                    perror("");
                }
                free(__envp_32);
            } else {
                rc = 1;
            }
        } else {
            rc = spawnvp(P_WAIT, "e2fsck.exe", __argv_32);
            if (rc == -1) {
                    fprintf(stderr, "Couldn't start %s. ", program);
                    perror("");
            }
        }
     
        free(__argv_32);
    } else {
        rc = 1;
    }

    return rc;
}

short _Far16 _Pascal CHKDSK(short argc, __pchar16 *_Seg16 argv, __pchar16 *_Seg16 envp) {
    printf(banner);
    return start_program("e2fsck.exe", argc, argv, envp);
}

/*
 * This entry point is necessary to make BOOTOS2 happy, even if it does nothing. The boot
 * record actually needs to be installed from Linux by LILO.
 */
short _Far16 _Pascal SYS(short argc, char *_Seg16 *_Seg16 argv, char *_Seg16 *_Seg16 envp) {
    fprintf(stderr, "SYS not implemented for ext2-os2 yet. To install OS/2 on a Linux partition please follow the instructions in ext2-os2.inf.\n");
    /*
     * Maybe in the future there will be a port of lilo here.
     */
    return 0;
}

short _Far16 _Pascal FORMAT(short argc, char *_Seg16 *_Seg16 argv, char *_Seg16 *_Seg16 envp) {
    printf(banner);
    return start_program("mke2fs.exe", argc, argv, envp);
}

short _Far16 _Pascal RECOVER(short argc, char *_Seg16 *_Seg16 argv, char *_Seg16 *_Seg16 envp) {
    fprintf(stderr, "RECOVER not implemented for ext2-os2 yet.\n");
    /*
     * No known undelete yet ...
     */
    return 0;
}

