#define INCL_DOSERRORS
#define INCL_NOPMAPI
#include <os2.h>

#include <stdio.h>
#include <stdlib.h>
#include <os2/vfsapi.h>

void os2_err(int error) {
    int rc;
    char *buf;
    unsigned long len;


    buf = malloc(4096);
    if (buf) {
        rc = DosGetMessage(0, 0, buf, 4096, error, "OSO001.MSG", &len);
        if (rc == NO_ERROR) {
            fprintf(stderr, "%s", buf);
        }
        free(buf);
    }
}

int main(int argc, char **argv) {
    int ret;
    int rc;

    if (argc == 3) {
        rc = vfs_link(argv[1], argv[2]);
        if (rc == NO_ERROR) {
            printf("%s -> %s [OK]\n", argv[1], argv[2]);
            ret = 0;
        } else {
           fprintf(stderr, "%s -> %s [FAILED]\n", argv[1], argv[2]);
           os2_err(rc);
           ret = 1;
        }
    } else {
        fprintf(stderr, "Usage : link <oldname> <newname>\n");
        ret = 1;
    }

    return ret;
}
