//
// $Header: D:/ext2-os2/minifsd/RCS/volume.c,v 9.0 1996/06/02 16:39:11 Willm Exp Willm $
//

// Linux ext2 file system driver for OS/2 2.x and WARP - Allows OS/2 to
// access your Linux ext2fs partitions as normal drive letters.
// Copyright (C) 1995, 1996 Matthieu WILLM
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

//
// Will be eventually moved to ext2/super.c, and openvolume will be split into
// ext2_read_super() and its calling VFS routine
//


#define INCL_DOSERRORS
#define INCL_NOPMAPI
#include <os2.h>                // From the Developer Connection Device Driver Kit version 2.0
#include <strat2.h>             // From the Developer Connection Device Driver Kit version 2.0

#include <fsd.h>
#include <fsh.h>

#include <string.h>
#include <dos.h>

#include <os2/errors.h>


#include <os2/types.h>
#include <os2/os2proto.h>
#include <os2/os2misc.h>


#include <linux/fs.h>
#include <linux/ext2_fs.h>
#include <linux/fs_proto.h>
#include <linux/e2_proto.h>
#include <linux/sched.h>

#include <os2/log.h>         /* Prototypes des fonctions de log.c                      */
#include <os2/volume.h>      /* Prototypes des fonctions de volume.c                   */


struct super_block stage1_superblk;

extern struct super_operations ext2_sops;

struct super_block * stage2_getvolume(unsigned short hVPB)
{
    struct super_block *sb;
    int                 rc;
    struct vpfsi       *pvpfsi;
    union  vpfsd       *pvpfsd;

    sb = 0;
    if (hVPB) {
        if ((rc = FSH_GETVOLPARM(hVPB, &pvpfsi, &pvpfsd)) == NO_ERROR) {
            sb = pvpfsd->u.sb;
        } else {
            kernel_printf("getvolume - rc = %d", rc);
        }
    } else {
        /*
         * This should NEVER occur
         */
        kernel_printf("getvolume called with hVPB = 0");
    }
    return sb;
}

struct super_block * stage1_getvolume(unsigned short hVPB) {
    return &stage1_superblk;
}

struct super_block *(*getvolume)() = stage1_getvolume;


void __wait_on_super(struct super_block * sb)
{
    _disable();
    while (sb->s_lock) {
        ProcBlock((unsigned long)(&(sb->s_wait)), -1, 1);
        _disable();
    }
    _enable();
}



void stage1_ext2_read_super (void) {
        struct super_block *sb = &stage1_superblk;
	struct buffer_head * bh;
	struct ext2_super_block * es;
	unsigned long sb_block = 1;
	unsigned long logic_sb_block = 1;
	int db_count;
	int i, j;

        sb->s_op              = &ext2_sops;

	bh = bread (0, sb_block, BLOCK_SIZE); /* failure in bread = panic */
	/*
	 * Note: s_es must be initialized s_es as soon as possible because
	 * some ext2 macro-instructions depend on its value
	 */
	es = (struct ext2_super_block *) bh->b_data;
	sb->u.ext2_sb.s_es = es;
        sb->s_magic = es->s_magic;
	if (sb->s_magic != EXT2_SUPER_MAGIC) {
            ext2_os2_panic(0, "Invalid ext2 signature in superblock : 0x%04X", sb->s_magic);
	}
	sb->s_blocksize = EXT2_MIN_BLOCK_SIZE << es->s_log_block_size;
	sb->s_blocksize_bits = EXT2_BLOCK_SIZE_BITS(sb);
	if (sb->s_blocksize != BLOCK_SIZE && 
	    (sb->s_blocksize == 1024 || sb->s_blocksize == 2048 ||  
	     sb->s_blocksize == 4096)) {
#if 1
            ext2_os2_panic(0, "Invalid block size : %d", sb->s_blocksize);
#else
		unsigned long offset;

		brelse (bh);
		set_blocksize (dev, sb->s_blocksize);
		logic_sb_block = (sb_block*BLOCK_SIZE) / sb->s_blocksize;
		offset = (sb_block*BLOCK_SIZE) % sb->s_blocksize;
		bh = bread (dev, logic_sb_block, sb->s_blocksize);
		if(!bh)
			return NULL;
		es = (struct ext2_super_block *) (((char *)bh->b_data) + offset);
		sb->u.ext2_sb.s_es = es;
		if (es->s_magic != EXT2_SUPER_MAGIC) {
			sb->s_dev = 0;
			unlock_super (sb);
			brelse (bh);
			printk ("EXT2-fs: Magic mismatch, very weird !\n");
			return NULL;
		}
#endif
	}
	sb->u.ext2_sb.s_frag_size = EXT2_MIN_FRAG_SIZE <<
				   es->s_log_frag_size;
	if (sb->u.ext2_sb.s_frag_size)
		sb->u.ext2_sb.s_frags_per_block = sb->s_blocksize /
						  sb->u.ext2_sb.s_frag_size;
	else
		sb->s_magic = 0;
	sb->u.ext2_sb.s_blocks_per_group = es->s_blocks_per_group;
	sb->u.ext2_sb.s_frags_per_group = es->s_frags_per_group;
	sb->u.ext2_sb.s_inodes_per_group = es->s_inodes_per_group;
	sb->u.ext2_sb.s_inodes_per_block = sb->s_blocksize /
					   sizeof (struct ext2_inode);
	sb->u.ext2_sb.s_itb_per_group = sb->u.ext2_sb.s_inodes_per_group /
				        sb->u.ext2_sb.s_inodes_per_block;
	sb->u.ext2_sb.s_desc_per_block = sb->s_blocksize /
					 sizeof (struct ext2_group_desc);
	sb->u.ext2_sb.s_sbh = bh;
	sb->u.ext2_sb.s_es = es;

	if (sb->s_magic != EXT2_SUPER_MAGIC) {
            ext2_os2_panic(0, "Invalid ext2 signature in superblock : 0x%04X", sb->s_magic);
	}

	if (sb->s_blocksize != sb->u.ext2_sb.s_frag_size) {
            ext2_os2_panic(0, "fragments not yet supported");
	}

	sb->u.ext2_sb.s_groups_count = (es->s_blocks_count -
				        es->s_first_data_block +
				       EXT2_BLOCKS_PER_GROUP(sb) - 1) /
				       EXT2_BLOCKS_PER_GROUP(sb);
	db_count = (sb->u.ext2_sb.s_groups_count + EXT2_DESC_PER_BLOCK(sb) - 1) /
		   EXT2_DESC_PER_BLOCK(sb);
        sb->u.ext2_sb.s_group_desc = stage1_G_malloc(db_count * sizeof (struct buffer_head *));
	if (sb->u.ext2_sb.s_group_desc == NULL) {
		ext2_os2_panic(0, "stage1_read_super : G_malloc failed");
	}

	for (i = 0; i < db_count; i++) {
		sb->u.ext2_sb.s_group_desc[i] = bread (0, logic_sb_block + i + 1, sb->s_blocksize);
                /*
                 * failure in bread = panic
                 */
	}
	for (i = 0; i < EXT2_MAX_GROUP_LOADED; i++) {
		sb->u.ext2_sb.s_inode_bitmap_number[i] = 0;
		sb->u.ext2_sb.s_inode_bitmap[i] = 0;
		sb->u.ext2_sb.s_block_bitmap_number[i] = 0;
		sb->u.ext2_sb.s_block_bitmap[i] = 0;
	}
	sb->u.ext2_sb.s_loaded_inode_bitmaps = 0;
	sb->u.ext2_sb.s_loaded_block_bitmaps = 0;
	sb->u.ext2_sb.s_db_per_group = db_count;
}



