//
// $Header: D:/ext2-os2/minifsd/RCS/mem.c,v 9.0 1996/06/02 16:39:04 Willm Exp Willm $
//

// Linux ext2 file system driver for OS/2 2.x and WARP - Allows OS/2 to
// access your Linux ext2fs partitions as normal drive letters.
// Copyright (C) 1995, 1996 Matthieu WILLM
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

#define INCL_DOSERRORS
#define INCL_NOPMAPI
#include <os2.h>                // From the Developer Connection Device Driver Kit version 2.0
#include <fsh.h>

#include <os2/types.h>
#include <os2/os2proto.h>


char *(*G_malloc)(unsigned long) = stage1_G_malloc;
int   (*G_free)(char *)          = stage1_G_free;

char *stage1_G_malloc(unsigned long cbSize) {
    unsigned long  ptr;
    unsigned short seg;

    ptr = 0;
    if (MFSH_SEGALLOC(0, cbSize, &seg) == NO_ERROR) {
        ptr = ((unsigned long)seg) << 16;
    }

    return (char *)ptr;
}

char *stage2_G_malloc(unsigned long cbSize) {
    unsigned long  ptr;
    unsigned short seg;

    ptr = 0;
    if (FSH_SEGALLOC(SA_FRING0 | SA_FSWAP, cbSize, &seg) == NO_ERROR) {
        ptr = ((unsigned long)seg) << 16;
    }

    return (char *)ptr;
}

int stage1_G_free(char *ptr) {
    return MFSH_SEGFREE((__segment)ptr);
}

int stage2_G_free(char *ptr) {
    return FSH_SEGFREE((__segment)ptr);
}

