//
// $Header: D:/ext2-os2/minifsd/RCS/log.c,v 9.0 1996/06/02 16:39:02 Willm Exp Willm $
//

// Linux ext2 file system driver for OS/2 2.x and WARP - Allows OS/2 to     
// access your Linux ext2fs partitions as normal drive letters.
// Copyright (C) 1995, 1996 Matthieu WILLM 
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.



#define INCL_DOSERRORS
#define INCL_NOPMAPI
#include <os2.h>		// From the "Developer Connection Device Driver Kit" version 2.0
// #include <infoseg.h>		// From the "Developer Connection Device Driver Kit" version 2.0

#include <conio.h>

#include <fsh.h>

#include <stdarg.h>
#include <os2/log.h>
#include <os2/types.h>
#include <os2/os2misc.h>
#include <os2/os2proto.h>


#define OUTPUT_COM1 0x3F8
#define OUTPUT_COM2 0x2F8

int kernel_printf(const char *fmt, ...) {
    va_list arg;
    char buf[256];
    char *bufptr = buf;


    va_start(arg, fmt);
    vsprintf(buf, fmt, arg);
    va_end(arg);


    while (*bufptr) {
	while(!(_inp(OUTPUT_COM2 + 5) & 0x20)); // Waits for COM port to be ready
        _outp(OUTPUT_COM2, *bufptr++);	        // Outputs our character
    }
    while(!(_inp(OUTPUT_COM2 + 5) & 0x20));     // Waits for COM port to be ready
    _outp(OUTPUT_COM2, '\r');	                // Outputs our character
    while(!(_inp(OUTPUT_COM2 + 5) & 0x20));     // Waits for COM port to be ready
    _outp(OUTPUT_COM2, '\n');	                // Outputs our character

    return 0;
}

 
int fs_err(UINT32 infunction, UINT32 errfunction, int retcode, UINT32 sourcefile, UINT32 sourceline) {
    return printk("Error function %ld returned %d (in function %ld, file %ld line %ld)", errfunction, retcode, infunction, sourcefile, sourceline);
}
