;
; $Header: D:/ext2-os2/RCS/devhelp2.asm,v 9.0 1996/06/02 16:36:51 Willm Exp Willm $
;

; Linux ext2 file system driver for OS/2 2.x and WARP - Allows OS/2 to
; access your Linux ext2fs partitions as normal drive letters.
; Copyright (C) 1995, 1996  Matthieu WILLM
;
; This program is free software; you can redistribute it and/or modify
; it under the terms of the GNU General Public License as published by
; the Free Software Foundation; either version 2 of the License, or
; (at your option) any later version.
;
; This program is distributed in the hope that it will be useful,
; but WITHOUT ANY WARRANTY; without even the implied warranty of
; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
; GNU General Public License for more details.
;
; You should have received a copy of the GNU General Public License
; along with this program; if not, write to the Free Software
; Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.


;
; These are *LARGE MEMORY MODEL* DevHelp C bindings
;

	.286p
        .model large

        INCL_DOSERRORS  EQU     1
        include os2.inc                         ; From the "Developer Connection Device Driver Kit" version 2.0
        include devhlp.inc                      ; From the "Developer Connection Device Driver Kit" version 2.0


        public _Device_Help



        .data

	_Device_Help dd (?)

;        .code
        .386p

;.386p
_TEXT segment word public use16 'CODE'
assume CS:_TEXT
;.286p

;
; int Beep(int frequency, int duration);
;
public _Beep
_Beep proc far
        push bp
        mov  bp, sp

        mov bx, [bp + 6]                 ; frequency
        mov cx, [bp + 8]                 ; duration
        mov dl, DevHlp_Beep
        call [_Device_Help]

        leave
        retf
_Beep endp

;
;int VirtToLin(void *virt, unsigned long *plin)
;
public _VirtToLin
_VirtToLin proc far
        push bp
        mov  bp, sp
        push si
        push di

        mov dl, DevHlp_VirtToLin
        xor eax, eax
        mov esi, eax
        mov ax, [bp + 8]                ; (__segment) virt
        mov si, [bp + 6]                ; OFFSETOF(virt)
        call  [_Device_Help]
        jc    VirtToLin_error           ; if error, EAX = error code
        les di, [bp + 10]               ; plin
        mov dword ptr es:[di], eax      ; *plin
        mov ax, NO_ERROR

VirtToLin_error:
        pop di
        pop si
        leave
        retf
_VirtToLin endp

;
; int VMLock(
;            unsigned long flags,                [bp + 6]
;            unsigned long lin,                        [bp + 10]
;            unsigned long length,                [bp + 14]
;            void          *pPageList,                [bp + 18]
;            void            *pLockHandle,        [bp + 22]
;             unsigned long *pPageListCount        [bp + 26]
;           );
;
public _VMLock
_VMLock proc far
        push bp
        mov  bp, sp
        push si
        push di

        mov ebx, [bp + 10]        ; lin
        mov ecx, [bp + 14]        ; length
        mov edi, [bp + 18]        ; pPageList
        mov esi, [bp + 22]        ; pLockHandle
        mov eax, [bp + 6]         ; flags
        mov dl, DevHlp_VMLock
        call [_Device_Help]
        jc    VMLock_error        ; if error, EAX = error code
        les di, [bp + 26]         ; pPageListCount
        mov es:[di], eax          ;*pPageListCount
        mov ax, NO_ERROR
VMLock_error:
        pop di
        pop si
        leave
        retf
_VMLock endp

;
; int VMUnlock(void *pLockHandle);
;
public _VMUnlock
_VMUnlock proc far
        push bp
        mov  bp, sp
        push si

        mov esi, [bp + 6]        ; pLockHandle
        mov dl, DevHlp_VMUnlock
        call [_Device_Help]
        jc    VMUnlock_error        ; if error, EAX = error code
        mov ax, NO_ERROR
VMUnlock_error:
        pop si
        leave
        retf
_VMUnlock endp



;
;int VirtToPhys(unsigned long virt, unsigned long *phys)
;
public _VirtToPhys
_VirtToPhys proc far
        push bp
        mov  bp, sp
	push ds
        push si
        push di

	mov ax, DGROUP
	mov es, ax

        lds si, [bp + 6]                 ; virt
        mov dl, DevHlp_VirtToPhys
        call  es:[_Device_Help]
        jc    VirtToPhys_error
        les di, [bp + 10]                ; phys
        mov word ptr es:[di], bx
        mov word ptr es:[di + 2], ax
        mov ax, NO_ERROR
        jmp VirtToPhys_out
VirtToPhys_error:
        mov ax, -1
VirtToPhys_out:
        pop di
        pop si
	pop ds
        leave
        retf
_VirtToPhys endp

;
; int FS_DevHelp_VMAlloc(
;                        unsigned long Taille,                /* bp + 6  */
;                        unsigned long PhysAddr,        /* bp + 10 */
;                        unsigned long Flags,           /* bp + 14 */
;                        PUINT32 LinAddr                /* bp + 18 */
;                       );
;
;
public _FS_DevHelp_VMAlloc
_FS_DevHelp_VMAlloc proc far
        push bp
        mov  bp, sp
        push di

        mov   ecx, dword ptr[bp + 6]                ; Taille
        mov   edi, dword ptr[bp + 10]                ; PhysAddr
        mov   eax, dword ptr[bp + 14]                ; Flags
        mov   dl, DevHlp_VMAlloc
        call  [_Device_Help]
        jc    VMAlloc_error

        les   bx, dword ptr[bp + 18]                ; LinAddr
        mov   es:[bx], eax
        mov   ax, NO_ERROR
        jmp VMAlloc_out
VMAlloc_error:
        mov ax, -1

VMAlloc_out:
        pop di
        leave
        retf
_FS_DevHelp_VMAlloc endp

;
; int FS_DevHelp_VMFree(
;                       unsigned long LinAddr        /* bp + 6 */
;                      );
;
public _FS_DevHelp_VMFree
_FS_DevHelp_VMFree proc far
;ARG @@LinAddr:DWORD
        push bp
        mov  bp,sp

        mov   eax, dword ptr[bp + 6]                ; LinAddr
        mov   dl, DevHlp_VMFree
        call  [_Device_Help]
        jc    VMFree_error
        mov   ax, NO_ERROR
        jmp VMFree_out
VMFree_error:
        mov ax, -1

VMFree_out:
        leave
        retf
_FS_DevHelp_VMFree endp

;
; int FS_DevHelp_GetDOSVar(
;                          unsigned char index,        /* bp + 6  */
;                          ppchar value                /* bp + 8  */
;                         );
;
public _FS_DevHelp_GetDOSVar
_FS_DevHelp_GetDOSVar proc far
        push bp
        mov  bp, sp
	push di

        mov al, byte ptr[bp + 6]                    ; index
        mov dl, DevHlp_GetDOSVar
        call [_Device_Help]
        jc GetDOSVar_error
        les di, dword ptr[bp + 8]                  ; value
        mov es:[di], bx
        mov es:[di + 2], ax
        mov ax, NO_ERROR
        jmp GetDOSVar_out

GetDOSVar_error:
        mov ax, -1

GetDOSVar_out:
	pop di
        leave
        retf
_FS_DevHelp_GetDOSVar endp


;
; int ProcBlock(
;                unsigned long  eventid,       /* bp + 6  */
;                long           timeout,       /* bp + 10 */
;                short          interruptible  /* bp + 14 */
;               );
;
public _ProcBlock
_ProcBlock proc far
        push bp
        mov  bp, sp
        push di
        mov bx, [bp + 6]                 ; eventid_low
        mov ax, [bp + 8]                 ; eventid_high
        mov di, [bp + 12]                ; timeout_high
        mov cx, [bp + 10]                ; timeout_low
        mov dh, [bp + 14]                ; interruptible_flag
        mov dl, DevHlp_ProcBlock
        call [_Device_Help]
        mov ah, 0
        pop di
        leave
        retf
_ProcBlock endp
_TEXT ends

.386p
EXT2_FIXED_CODE segment word public use16 'CODE'


;
; int ProcRun(
;             unsigned longt eventid        /* bp + 6  */
;            );
;
public _ProcRun
_ProcRun proc far
        push bp
        mov  bp, sp

        mov bx, [bp + 6]                 ; eventid_low
        mov ax, [bp + 8]                 ; eventid_high
        mov dl, DevHlp_ProcRun
        call [_Device_Help]
        leave
        retf
_ProcRun endp
EXT2_FIXED_CODE ends

        end

