;
; $Header: D:/32bits/ext2-os2/microfsd/rcs/entry.asm,v 1.2 1996/12/23 18:29:51 Willm Exp $
;

; Linux ext2 file system driver for OS/2 2.x and WARP - Allows OS/2 to
; access your Linux ext2fs partitions as normal drive letters.
; Copyright (C) 1995, 1996 Matthieu WILLM 
;
; This program is free software; you can redistribute it and/or modify
; it under the terms of the GNU General Public License as published by
; the Free Software Foundation; either version 2 of the License, or
; (at your option) any later version.
;
; This program is distributed in the hope that it will be useful,
; but WITHOUT ANY WARRANTY; without even the implied warranty of
; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
; GNU General Public License for more details.
;
; You should have received a copy of the GNU General Public License
; along with this program; if not, write to the Free Software
; Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

;****************************************************************************
;*** Segment definitions                                                  ***
;****************************************************************************
        .386p

_TEXT	SEGMENT  WORD USE16 PUBLIC 'CODE'
_TEXT	ENDS
_DATA	SEGMENT  WORD USE16 PUBLIC 'DATA'
_DATA	ENDS
CONST	SEGMENT  WORD USE16 PUBLIC 'CONST'
CONST	ENDS
_BSS	SEGMENT  WORD USE16 PUBLIC 'BSS'
_BSS	ENDS
mfs_stack	SEGMENT  WORD USE16 PUBLIC 'STACK'
mfs_stack	ENDS
DGROUP	GROUP	_TEXT, CONST, _BSS, _DATA, mfs_stack
        ASSUME CS:DGROUP, DS: DGROUP, SS: DGROUP

;****************************************************************************
;*** External variables                                                   ***
;****************************************************************************
        .286

;****************************************************************************
;*** Stack segment                                                        ***
;****************************************************************************

mfs_stack SEGMENT
	public _microfsd_stack_bottom
	public _microfsd_stack_top
        _microfsd_stack_bottom db 4096 dup (?)
	_microfsd_stack_top equ this byte
mfs_stack ENDS


_DATA segment
	public _disk_table

	checkpoint_1 db "MICROFSD - checkpoint 1"
        checkpoint_1_len equ $ - offset DGROUP:checkpoint_1

	checkpoint_2 db "MICROFSD - checkpoint 2"
        checkpoint_2_len equ $ - offset DGROUP:checkpoint_2

	checkpoint_3 db "MICROFSD - checkpoint 3"
        checkpoint_3_len equ $ - offset DGROUP:checkpoint_3

	_disk_table dw 11 dup (0)
_DATA ends

;****************************************************************************
;** Code segment                                                          ***
;****************************************************************************

_TEXT   SEGMENT

        public BIOS_READ_HD
	public _stub_mu_Open
	public _stub_mu_Read
	public _stub_mu_Close
	public _stub_mu_Terminate

        EXTRN _mu_Start     : near	; in start.c
        EXTRN _mu_Open      : near	; in open.c
        EXTRN _mu_Read      : near	; in read.c
        EXTRN _mu_Close     : near	; in close.c
        EXTRN _mu_Terminate : near	; in term.c

        EXTRN _parm_cs      : word	; in start.c
        EXTRN _parm_ds      : word	; in start.c
        EXTRN _parm_es      : word	; in start.c
        EXTRN _parm_ss      : word	; in start.c

	EXTRN _output_com   : near      ; in vsprintf.c

	EXTRN VIDEO_INIT    : near      ; in video.asm 
	EXTRN VIDEO_OUTPUT  : near      ; in video.asm 
	EXTRN VIDEO_CRLF    : near      ; in video.asm 

	LILO_DATA_SEGMENT equ 09000h    ; segment of LILO data passed to microfsd.fsd
	RELOC_LILO_DATA   equ 08C00h    ; LILO data will be relocated here
	RELOC_SEG         equ 08C20h    ; microfsd.fsd will be relocated here

	DEBUG_PORT        equ 00000h	; COM port for debug output (0 : com1, 1 : com2)

        ;
        ; >>>>> LILO will call us here normally <<<<<
        ;
        org 0h			; 0 based code

public microfsd_entry
microfsd_entry:
	;
	; Saves the DS ES and SS registers as passed to us
	;
	mov ax, cs
 	mov bx, ds
	mov cx, es
	mov dx, ss

        ;
        ; Updates the data segment registers
        ;
        mov ds, ax
        mov es, ax

	;
	; Updates the stack pointer
	;
	cli
        mov ss, ax
        mov sp, offset DGROUP:_microfsd_stack_top 
	sti

	ASSUME DS:DGROUP

        ;
        ; Saves the DS ES and SS passed to us into parm_ds and parm_es
        ;
	mov _parm_cs, ax
	mov _parm_ds, bx
	mov _parm_es, cx
	mov _parm_ss, dx

	;
	; Initialize video (and clear screen)
	;
	call VIDEO_INIT

	;
	; Checkpoint
	;
        push offset DGROUP:checkpoint_1
	push checkpoint_1_len
	call VIDEO_OUTPUT
	call VIDEO_CRLF

	;
	; Copies the LILO command line parameter area to RELOC_LILO_DATA:0000
	; (512 bytes)
	;
	push ds
	push es

	mov ax, LILO_DATA_SEGMENT
	mov ds, ax

	mov ax, RELOC_LILO_DATA
	mov es, ax

	xor si, si
	xor di, di
	mov cx, 256
	cld
	rep movsw

	pop es
	pop ds


	;
	; Relocales ourself at 2000:0000
	;
	mov cx, offset DGROUP:_microfsd_stack_top
	shr cx, 1
	inc cx
	mov ax, 02000h
	mov es, ax
	mov ax, 0
	mov si, ax
	mov di, ax
	cld
	rep movsw

	push 02000h
	push offset DGROUP:reloc_1
	retf	
reloc_1:

	;
	; Updates the stack segment
	;
	mov ax, cs
	mov ds, ax
	mov es, ax
	cli
	mov ss, ax
        mov sp, offset DGROUP:_microfsd_stack_top 
	sti

	;
	; Checkpoint
	;
        push offset DGROUP:checkpoint_2
	push checkpoint_2_len
	call VIDEO_OUTPUT
	call VIDEO_CRLF

	;
	; Relocales ourself at RELOC_SEG:0000
	;
	mov cx, offset DGROUP:_microfsd_stack_top
	shr cx, 1
	inc cx
	mov ax, RELOC_SEG
	mov es, ax
	mov ax, 0
	mov si, ax
	mov di, ax
	cld
	rep movsw

	push RELOC_SEG
	push offset DGROUP:reloc
	retf	
reloc:

	;
	; Updates the stack segment
	;
	mov ax, cs
	mov ds, ax
	mov es, ax
	cli
	mov ss, ax
        mov sp, offset DGROUP:_microfsd_stack_top 
	sti

	;
	; Checkpoint 3
	;
        push offset DGROUP:checkpoint_3
	push checkpoint_3_len
	call VIDEO_OUTPUT
	call VIDEO_CRLF

	;
	; Initialize the BIOS floppy parameter table
	;
	push ds
	push es
	pusha

	xor ax, ax
	mov ds, ax
	mov si, 078h					; DS:SI -> 0000:0078
	lea di, _disk_table
	mov cx, 11
	cld
	rep movsb

	mov ax, es
	mov ds:[si], di
	mov ds:[si + 2], ax

	mov byte ptr [di + 3], 3	; 512 bytes per sector
	mov byte ptr [di + 4], 18	; 18 sectors per track

	popa
	pop es
	pop ds



	;
	; Initialize disk controller
	;
	pusha
	push ds
	push es
	xor ax, ax
	xor dx, dx
	int 13h
	pop es
	pop ds
	popa

        ;
        ; Calls the micro FSD main entry point - We'll normally never return from it, 
        ; except in test mode.
        ;
        call _mu_Start

endless_loop:
        ;
        ; Normally we should NEVER reach this point ; otherwise we halt the system.
        ;
        hlt
        jmp endless_loop



; int _pascal bios_read_hd(
;                          unsigned short dev, 		/* bp + 16 */
;                          unsigned short head,		/* bp + 14 */
;                          unsigned short cyl,		/* bp + 12 */
;                          unsigned short sect,		/* bp + 10 */
;                          unsigned short nbsect,	/* bp + 8  */
;                          unsigned long  buffer	/* bp + 4  */
;                        );
BIOS_READ_HD proc near
	enter 0, 0
	push ds
	push es
	push si
	push di
	push bx

	mov dl, [bp+16]  ; dev
	mov dh, [bp+14]  ; head

        mov ax, [bp+12]  ; Cyl.
        mov ch, al     
        mov cl, ah
	shl cl, 6   
        or cl, [bp+10]  ; sect.

        les bx, [bp+4]  ; buf

	mov ah, 02h	; read disk
	mov al, [bp+8]  ; nb sect.
	int 13h
	jc  short not_ok
	mov ax, 0
not_ok:
	shr ax, 8

	pop bx
	pop di
	pop si
	pop es
	pop ds
	leave
	ret 14
BIOS_READ_HD endp

;***********************
;* mu_Open entry point *
;***********************
_stub_mu_Open proc far
	push bp
	mov bp, sp

	push ds
	push es
	push cs
	pop ax
	mov ds, ax
	mov es, ax
.386p
        mov ax, ss
        mov word ptr [_microfsd_stack_top-2], ax
        mov word ptr [_microfsd_stack_top-4], sp

        mov eax, dword ptr [bp+10]
	mov dword ptr [_microfsd_stack_top-8], eax

        mov eax, dword ptr [bp+6]
	mov dword ptr [_microfsd_stack_top-12], eax

	push ds
	mov ax, offset DGROUP:_microfsd_stack_top - 12 
	push ax
	lss sp, dword ptr [esp]

.286p
	call _mu_Open
	add sp, 8
.386p
        lss sp, dword ptr [_microfsd_stack_top - 4]
.286p
	pop es
	pop ds
	leave
	retf
_stub_mu_Open endp


;***********************
;* mu_Read entry point *
;***********************
_stub_mu_Read proc far
	push bp
	mov bp, sp

	push ds
	push es
	push cs
	pop ax
	mov ds, ax
	mov es, ax
.386p
	;
	; Saves current ss:sp on top of microfsd_stack
 	;
        mov ax, ss
        mov word ptr [_microfsd_stack_top-2], ax
        mov word ptr [_microfsd_stack_top-4], sp

	;
	; Copies cbBuf on our new stack
	;
        mov eax, dword ptr [bp+14]			; cbBuf
	mov dword ptr [_microfsd_stack_top-8], eax

	;
	; Copies pBuf on our new stack
	;
        mov eax, dword ptr [bp+10]			; pBuf
	mov dword ptr [_microfsd_stack_top-12], eax

	;
	; Copies loffseek on our new stack
	;
        mov eax, dword ptr [bp+6]			; loffseek
	mov dword ptr [_microfsd_stack_top-16], eax

	;
	; New ss:sp
	;
	push ds
	mov ax, offset DGROUP:_microfsd_stack_top - 16 
	push ax
	lss sp, dword ptr [esp]

.286p
	call _mu_Read
	add sp, 12
.386p
        lss sp, dword ptr [_microfsd_stack_top - 4]
.286p
	pop es
	pop ds
	leave
	retf
_stub_mu_Read endp

;************************
;* mu_Close entry point *
;************************
_stub_mu_Close proc far
	push bp
	mov bp, sp

	push ds
	push es
	push cs
	pop ax
	mov ds, ax
	mov es, ax
.386p
        mov ax, ss
        mov word ptr [_microfsd_stack_top-2], ax
        mov word ptr [_microfsd_stack_top-4], sp


	push ds
	mov ax, offset DGROUP:_microfsd_stack_top - 4 
	push ax
	lss sp, dword ptr [esp]

.286p
	call _mu_Close
.386p
        lss sp, dword ptr [_microfsd_stack_top - 4]
.286p
	pop es
	pop ds
	leave
	retf
_stub_mu_Close endp

;****************************
;* mu_Terminate entry point *
;****************************
_stub_mu_Terminate proc far
	push bp
	mov bp, sp

	push ds
	push es
	push cs
	pop ax
	mov ds, ax
	mov es, ax
.386p
        mov ax, ss
        mov word ptr [_microfsd_stack_top-2], ax
        mov word ptr [_microfsd_stack_top-4], sp


	push ds
	mov ax, offset DGROUP:_microfsd_stack_top - 4 
	push ax
	lss sp, dword ptr [esp]

.286p
	call _mu_Terminate
.386p
        lss sp, dword ptr [_microfsd_stack_top - 4]
.286p
	pop es
	pop ds
	leave
	retf
_stub_mu_Terminate endp

_TEXT   ENDS

_DATA segment
	public _current_seg
	public _image_length

	_current_seg  dw RELOC_SEG
	_image_length dw offset DGROUP:_microfsd_stack_top 

_DATA ends

;****************************************************************************
;*** End                                                                  ***
;****************************************************************************
        end microfsd_entry


