//
// $Header: D:/32bits/ext2-os2/fsd32/rcs/fs32_rmdir.c,v 1.1 1996/09/21 22:25:43 Willm Exp $
//

// 32 bits Linux ext2 file system driver for OS/2 WARP - Allows OS/2 to
// access your Linux ext2fs partitions as normal drive letters.
// Copyright (C) 1995, 1996 Matthieu WILLM
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
#ifdef __IBMC__
#pragma strings(readonly)
#endif


#define INCL_DOS
#define INCL_DOSERRORS
#define INCL_NOPMAPI
#include <os2.h>

#include <string.h>

#include <os2/types.h>
#include <os2/StackToFlat.h>
#include <os2/fsd32.h>
#include <os2/fsh32.h>
#include <os2/DevHlp32.h>

#include <linux/stat.h>

#include <os2/os2proto.h>
#include <os2/ifsdbg.h>
#include <os2/filefind.h>
#include <os2/errors.h>
#include <os2/log.h>         /* Prototypes des fonctions de log.c                      */
#include <os2/volume.h>      /* Prototypes des fonctions de volume.c                   */
#include <os2/files.h>       /* Prototypes des fonctions de files.c                    */
#include <os2/os2misc.h>
#include <os2/trace.h>

#include <linux/fs.h>
#include <linux/fs_proto.h>
#include <linux/ext2_fs.h>
#include <linux/ext2_proto.h>
#include <linux/sched.h>

#define THISFILE FILE_FS_DIR_C

/*
 * struct fs32_rmdir_parms {
 *     unsigned short iCurDirEnd;
 *     PTR16          pName;
 *     PTR16          pcdfsd;
 *     PTR16          pcdfsi;
 * };
 */
int FS32ENTRY fs32_rmdir(struct fs32_rmdir_parms *parms) {
    char           *pName;
    struct cdfsi32 *pcdfsi;
    union  cdfsd32 *pcdfsd;
    int             rc;
    struct super_block *sb;       /* volume descriptor */
    struct inode       *dir;
    struct file        *filp;
    ino_t               ino_no;
    char              parent[CCHMAXPATH];
    char              name[CCHMAXPATH];
    char             *__name = __StackToFlat(name);
    umode_t                i_mode;
    UINT32              mode;



    parms = __StackToFlat(parms);

    if ((rc = DevHlp32_VirtToLin(parms->pcdfsi, __StackToFlat(&pcdfsi))) == NO_ERROR) {
        if ((rc = DevHlp32_VirtToLin(parms->pcdfsd, __StackToFlat(&pcdfsd))) == NO_ERROR) {
            if ((rc = DevHlp32_VirtToLin(parms->pName, __StackToFlat(&pName))) == NO_ERROR) {
	        if (trace_FS_RMDIR) {
        	    kernel_printf("FS_RMDIR pre-invocation : %s", pName);
    		}

	        if (Read_Write) {
	            mode = (is_case_retensive() ? OPENMODE_DOSBOX : 0);
	            //
	            // Gets the superblock from pcdfsi
	            //
	            if ((sb = getvolume(pcdfsi->cdi_hVPB)) != 0) {

	                ExtractPath(pName, __StackToFlat(parent));
            		ExtractName(pName, __StackToFlat(name));
            		if ((filp = _open_by_name(sb, __StackToFlat(parent), OPENMODE_READONLY | mode)) != NULL) {
                	    ino_no = filp->f_inode->i_ino;
                	    i_mode = filp->f_inode->i_mode;
                	    if ((rc = vfs_close(filp)) == NO_ERROR) {

                    		if (S_ISDIR(i_mode)) {
                       		    if (((i_mode & S_IWUSR)) ||
                            		((i_mode & S_IWGRP)) ||
                            		((i_mode & S_IWOTH))) {

                            		dir = iget(sb, ino_no);
                            		rc = dir->i_op->rmdir(dir, __StackToFlat(name), strlen(__name));
                            		rc = map_err(rc);        // rc was a Linux error code (from linux/errno.h)
                        	    } else {
                            		kernel_printf("FS_RMDIR - %s is read only", pName);
                            		rc = ERROR_ACCESS_DENIED;
                       		    }
                    		} else {
                        	    kernel_printf("FS_RMDIR - %s is not a directory", pName);
                        	    rc = ERROR_ACCESS_DENIED;
                    		}
                	    } else {
                    		fs_err(FUNC_FS_RMDIR, FUNC_CLOSE, rc, THISFILE, __LINE__);
                	    }
            		} else {
                	    fs_err(FUNC_FS_RMDIR, FUNC_OPEN_BY_NAME, -1, THISFILE, __LINE__);
                	    rc = ERROR_OPEN_FAILED;
           	        } /* end if */
	            } else {
            		kernel_printf("FS_RMDIR - Couldn't get the superblock");
            		rc = ERROR_INVALID_PARAMETER;
        	    }
	        } else {
        	    rc = ERROR_WRITE_PROTECT;
	        }

	        if (trace_FS_RMDIR) {
        	    kernel_printf("FS_RMDIR post-invocation : rc = %d", rc);
    		}
            }
        }
    }
    return rc;
}
