//
// $Header: D:/32bits/ext2-os2/fsd32/rcs/fs32_move.c,v 1.1 1996/09/21 22:25:28 Willm Exp $
//

// 32 bits Linux ext2 file system driver for OS/2 WARP - Allows OS/2 to
// access your Linux ext2fs partitions as normal drive letters.
// Copyright (C) 1995, 1996 Matthieu WILLM
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

#ifdef __IBMC__
#pragma strings(readonly)
#endif

#define INCL_DOS
#define INCL_DOSERRORS
#define INCL_NOPMAPI
#include <os2.h>

#include <string.h>

#include <os2/types.h>
#include <os2/StackToFlat.h>
#include <linux/fs.h>
#include <os2/os2proto.h>
#include <os2/fsd32.h>
#include <os2/fsh32.h>
#include <os2/DevHlp32.h>
#include <os2/log.h>
#include <os2/trace.h>
#include <os2/errors.h>
#include <os2/files.h>
#include <os2/volume.h>
#include <linux/fs_proto.h>
#include <linux/stat.h>
#include <os2/vfsapi.h>
#include <os2/ifsdbg.h>

/*
 * struct fs32_move_parms {
 *     unsigned short flag;
 *     unsigned short iDstCurDirEnd;
 *     PTR16          pDst;
 *     unsigned short iSrcCurDirEnd;
 *     PTR16          pSrc;
 *     PTR16          pcdfsd;
 *     PTR16          pcdfsi;
 * };
 */
int FS32ENTRY fs32_move(struct fs32_move_parms *parms) {
    char           *pSrc;
    char           *pDst;
    struct cdfsi32 *pcdfsi;
//    union  cdfsd32 *pcdfsd;
    int             rc;
    int error;
    char *srcPath, *srcName, *dstPath, *dstName;
    struct inode *isrcdir, *idstdir;
    struct file        *file;
    struct super_block *sb;
    unsigned long DOSmode;


    parms = __StackToFlat(parms);

    if ((rc = DevHlp32_VirtToLin(parms->pcdfsi, __StackToFlat(&pcdfsi))) == NO_ERROR) {
//        if ((rc = DevHlp32_VirtToLin(parms->pcdfsd, __StackToFlat(&pcdfsd))) == NO_ERROR) {
            if ((rc = DevHlp32_VirtToLin(parms->pSrc, __StackToFlat(&pSrc))) == NO_ERROR) {
                if ((rc = DevHlp32_VirtToLin(parms->pDst, __StackToFlat(&pDst))) == NO_ERROR) {
                    if (trace_FS_MOVE) {
                        kernel_printf("FS_MOVE(%s -> %s)", pSrc, pDst);
                    }
                    if (Read_Write) {
                        sb = getvolume(pcdfsi->cdi_hVPB);

                        DOSmode = (is_case_retensive() ? OPENMODE_DOSBOX : 0);

                        if ((rc = DevHlp32_VMAlloc(4 * CCHMAXPATH, VMDHA_NOPHYSADDR, VMDHA_SWAP, __StackToFlat(&srcPath))) == NO_ERROR) {

                            srcName = srcPath + CCHMAXPATH;
                            dstPath = srcName + CCHMAXPATH;
                            dstName = dstPath + CCHMAXPATH;

                            ExtractPath(pSrc, srcPath);                // Source path
                            ExtractName(pSrc, srcName);                // Source name
                            ExtractPath(pDst, dstPath);                // Destination path
                            ExtractName(pDst, dstName);                // Destination name

			    //
			    // Does the destination path exists ? (this is a hack until I write a true dir_namei routine)
			    //
			    if ((file = _open_by_name(sb, dstPath, DOSmode | OPENMODE_READONLY)) != NULL) {

			        idstdir = file->f_inode;
			        idstdir->i_count ++;
			        vfs_close(file);

			        //
			        // Does the source path exists ? (this is a hack until I write a true dir_namei routine)
			        //
			        if ((file = _open_by_name(sb, srcPath, DOSmode | OPENMODE_READONLY)) != NULL) {

			            isrcdir = file->f_inode;
				    isrcdir->i_count ++;
				    vfs_close(file);

				    //
				    // Now we do the move operation
				    //
				    idstdir->i_count++;
				    down(&idstdir->i_sem);
				    if (isrcdir->i_op && isrcdir->i_op->rename) {
				        error = isrcdir->i_op->rename(isrcdir, srcName, strlen(srcName),
                           				              idstdir, dstName, strlen(dstName));
				    } else {
				        if (!isrcdir->i_op)
				                ext2_os2_panic(1, "FS_MOVE - isrcdir->i_op = 0 - shoudn't occur for ext2-os2");
				        if (!isrcdir->i_op->rename)
				                ext2_os2_panic(1, "FS_MOVE - isrcdir->i_op->rename = 0 - shoudn't occur for ext2-os2");

				    }
				    up(&idstdir->i_sem);
				    iput(idstdir);
				    rc = map_err(error);
			        } else {
       			            kernel_printf("FS_MOVE() - Source path %s not found", srcPath);
			            iput(idstdir);
                                    rc = ERROR_PATH_NOT_FOUND;
                                }
                            } else {
                                kernel_printf("FS_MOVE() - Destination path %s not found", dstPath);
                                rc = ERROR_PATH_NOT_FOUND;
                            }

                            DevHlp32_VMFree(srcPath);
                        } // DevHlp32_VMAlloc
                    } else {
                        rc = ERROR_WRITE_PROTECT;
                    }
                    if (trace_FS_MOVE) {
                        kernel_printf("FS_MOVE(%s -> %s rc = %d)", pSrc, pDst, rc);
                    }

                }
            }
//        }
    }
    return rc;
}
