//
// $Header: D:/32bits/ext2-os2/fsd32/rcs/fs32_mkdir.c,v 1.1 1996/09/21 22:25:23 Willm Exp $
//

// 32 bits Linux ext2 file system driver for OS/2 WARP - Allows OS/2 to
// access your Linux ext2fs partitions as normal drive letters.
// Copyright (C) 1995, 1996 Matthieu WILLM
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

#ifdef __IBMC__
#pragma strings(readonly)
#endif

#define INCL_DOS
#define INCL_DOSERRORS
#define INCL_NOPMAPI
#include <os2.h>

#include <string.h>

#include <os2/types.h>
#include <os2/StackToFlat.h>
#include <os2/fsd32.h>
#include <os2/fsh32.h>
#include <os2/DevHlp32.h>

#include <linux/stat.h>

#include <os2/os2proto.h>
#include <os2/ifsdbg.h>
#include <os2/filefind.h>
#include <os2/errors.h>
#include <os2/log.h>         /* Prototypes des fonctions de log.c                      */
#include <os2/volume.h>      /* Prototypes des fonctions de volume.c                   */
#include <os2/files.h>       /* Prototypes des fonctions de files.c                    */
#include <os2/os2misc.h>
#include <os2/trace.h>

#include <linux/fs.h>
#include <linux/fs_proto.h>
#include <linux/ext2_fs.h>
#include <linux/ext2_proto.h>
#include <linux/sched.h>

#define THISFILE FILE_FS_DIR_C

/*
 * struct fs32_mkdir_parms {
 *     unsigned short flags;
 *     PTR16          pEABuf;
 *     unsigned short iCurDirEnd;
 *     PTR16          pName;
 *     PTR16          pcdfsd;
 *     PTR16          pcdfsi;
 * };
 */
int FS32ENTRY fs32_mkdir(struct fs32_mkdir_parms *parms) {
    char           *pName;
    struct cdfsi32 *pcdfsi;
    union  cdfsd32 *pcdfsd;
    int             rc;
    struct super_block *p_volume;
    char                parent[CCHMAXPATH];
    char                name[CCHMAXPATH];
    char               *__name = __StackToFlat(name);
    struct file        *p_file;
    ino_t               ino_no;
    struct inode       *dir;
    UINT32              mode;


    parms = __StackToFlat(parms);

    if (Read_Write) {
        if ((rc = DevHlp32_VirtToLin(parms->pcdfsi, __StackToFlat(&pcdfsi))) == NO_ERROR) {
            if ((rc = DevHlp32_VirtToLin(parms->pcdfsd, __StackToFlat(&pcdfsd))) == NO_ERROR) {
                if ((rc = DevHlp32_VirtToLin(parms->pName, __StackToFlat(&pName))) == NO_ERROR) {
                    if (trace_FS_MKDIR) {
                        kernel_printf("FS_MKDIR pre-invocation : %s", pName);
                    }


        /*
         * Checks if we must do case sensitive compares
         */
        mode = (is_case_retensive() ? OPENMODE_DOSBOX : 0);

        /*
         * Gets the superblock from pcdfsi
         */
        if ((p_volume = getvolume(pcdfsi->cdi_hVPB)) != 0) {

            ExtractPath(pName, __StackToFlat(parent));
            ExtractName(pName, __StackToFlat(name));
            /*
             * Opens the parent directory
             */
            if ((p_file = _open_by_name(p_volume, __StackToFlat(parent), OPENMODE_READONLY | mode)) != NULL) {
                ino_no = p_file->f_inode->i_ino;
                if ((rc = vfs_close(p_file)) == NO_ERROR) {
                    dir = iget(p_volume, ino_no);
                    dir->i_count++;
                    down(&dir->i_sem);
                    rc = dir->i_op->mkdir(dir, __StackToFlat(name), strlen(__name), 0777);
                    up(&dir->i_sem);
                    iput(dir);
                    rc = map_err(rc);        // rc was a Linux error code (from linux/errno.h)
                } else {
                    fs_err(FUNC_FS_MKDIR, FUNC_CLOSE, rc, THISFILE, __LINE__);
                    rc = ERROR_CANNOT_MAKE;
                }
            } else {
                fs_err(FUNC_FS_MKDIR, FUNC_OPEN_BY_NAME, -1, THISFILE, __LINE__);
                rc = ERROR_CANNOT_MAKE;
            } /* end if */
        } else {
            kernel_printf("FS_MKDIR - couldn't retrieve superblock");
            rc = ERROR_INVALID_PARAMETER;
        }

    /*
     * Some apps (software installer...) do rely on this, which seems to be the default
     * behavior on HPFS.
     */
    if (rc == ERROR_FILE_EXISTS) {
        rc = ERROR_ACCESS_DENIED;
    }

    if (trace_FS_MKDIR) {
        kernel_printf("FS_MKDIR post-invocation : rc = %d", rc);
    }
    return rc;
            }
        }
    }

    } else {                 // !Read_Write
        rc = ERROR_WRITE_PROTECT;
    }

    return rc;
}
