//
// $Header: D:/32bits/ext2-os2/fsd32/rcs/fs32_ioctl.c,v 1.1 1996/09/21 22:25:20 Willm Exp $
//

// 32 bits Linux ext2 file system driver for OS/2 WARP - Allows OS/2 to
// access your Linux ext2fs partitions as normal drive letters.
// Copyright (C) 1995, 1996 Matthieu WILLM
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
#ifdef __IBMC__
#pragma strings(readonly)
#endif


#define INCL_DOS
#define INCL_DOSERRORS
#define INCL_NOPMAPI
#include <os2.h>

#include <os2/types.h>
#include <os2/StackToFlat.h>
#include <linux/fs.h>
#include <os2/os2proto.h>
#include <os2/fsd32.h>
#include <os2/fsh32.h>
#include <os2/DevHlp32.h>
#include <os2/log.h>
#include <os2/trace.h>
#include <os2/errors.h>
#include <os2/files.h>
#include <os2/volume.h>
#include <linux/fs_proto.h>

/*
 * struct fs32_ioctl_parms {
 *     PTR16          pDataLenInOut;
 *     unsigned short lenData;
 *     PTR16          pData;
 *     PTR16          pParmLenInOut;
 *     unsigned short lenParm;
 *     PTR16          pParm;
 *     unsigned short func;
 *     unsigned short cat;
 *     PTR16           psffsd;
 *     PTR16           psffsi;
 * };
 */
int FS32ENTRY fs32_ioctl(struct fs32_ioctl_parms *parms) {
    unsigned short *pDataLenInOut;
    unsigned short *pParmLenInOut;
    PTR16           pvpfsi16;
    PTR16           pvpfsd16;
    struct sffsi32 *psffsi;
    struct vpfsi32 *pvpfsi;
    union  vpfsd32 *pvpfsd;

    int             rc;
    int             rc2;


    parms = __StackToFlat(parms);

    if (trace_FS_IOCTL) {
        kernel_printf("FS_IOCTL pre-invocation : cat = 0x%0X, func = 0x%0X", parms->cat, parms->func);
    }

    if ((rc = DevHlp32_VirtToLin(parms->psffsi, __StackToFlat(&psffsi))) == NO_ERROR) {
        if ((rc = fsh32_getvolparm(psffsi->sfi_hVPB, __StackToFlat(&pvpfsi16), __StackToFlat(&pvpfsd16))) == NO_ERROR) {
            if ((rc = DevHlp32_VirtToLin(pvpfsi16, __StackToFlat(&pvpfsi))) == NO_ERROR) {
                if ((rc = fsh32_devioctl(
                                     0,
                                     pvpfsi->vpi_hDEV,
                                     psffsi->sfi_selfsfn, /* sfn */
                                     parms->cat,
                                     parms->func,
                                     parms->pParm,
                                     parms->lenParm,
                                     parms->pData,
                                     parms->lenData
                                    )) == NO_ERROR) {
                    kernel_printf("FS_IOCTL - fsh32_devioctl returned %d", rc);
                     /*
                     * Nothing ...
                     */
                } else {
                    kernel_printf("FS_IOCTL - fsh32_devioctl returned %d", rc);
                } /* FSH_DEVIOCTL failed */
            } else {
                kernel_printf("FS_IOCTL - Error while thunking pvpfsi - rc = %d", rc);
            }
        } else {
            kernel_printf("FS_IOCTL - FSH_GETVOLPARM returned %d", rc);
        } /* FSH_GETVOLPARM failed */

        if (parms->pParmLenInOut.seg) {
            if ((rc2 = DevHlp32_VirtToLin(parms->pParmLenInOut, __StackToFlat(&pParmLenInOut))) == NO_ERROR) {
                *pParmLenInOut = parms->lenParm;
            }
        }
        if (parms->pDataLenInOut.seg) {
            if ((rc2 = DevHlp32_VirtToLin(parms->pDataLenInOut, __StackToFlat(&pDataLenInOut))) == NO_ERROR) {
                *pDataLenInOut = parms->lenData;
            }
        }
    } else {
        kernel_printf("FS_IOCTL - error while thunking psffsi", rc);        
    }

    if (trace_FS_IOCTL) {
        kernel_printf("FS_IOCTL post-invocation : rc = %d", rc);
    }

    return rc;
}
