//
// $Header: D:/32bits/ext2-os2/fsd32/rcs/fs32_fsinfo.c,v 1.1 1996/09/21 22:25:15 Willm Exp $
//

// 32 bits Linux ext2 file system driver for OS/2 WARP - Allows OS/2 to
// access your Linux ext2fs partitions as normal drive letters.
// Copyright (C) 1995, 1996 Matthieu WILLM
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
#ifdef __IBMC__
#pragma strings(readonly)
#endif


#define INCL_DOS
#define INCL_DOSERRORS
#define INCL_NOPMAPI
#include <os2.h>

#include <string.h>

#include <os2/types.h>
#include <os2/StackToFlat.h>
#include <linux/fs.h>
#include <os2/os2proto.h>
#include <os2/fsd32.h>
#include <os2/fsh32.h>
#include <os2/DevHlp32.h>
#include <os2/log.h>
#include <os2/trace.h>
#include <os2/errors.h>
#include <os2/files.h>
#include <os2/volume.h>
#include <linux/fs_proto.h>
#include <linux/stat.h>
#include <os2/vfsapi.h>
#include <os2/ifsdbg.h>

struct FSINFO16 {        /* fsinf */
    ULONG ulVSN;
    VOLUMELABEL vol;
};

/*
 * struct fs32_fsinfo_parms {
 *     unsigned short level;
 *     unsigned short cbData;
 *     PTR16          pData;
 *     unsigned short hVPB;
 *     unsigned short flag;
 * };
 */
int FS32ENTRY fs32_fsinfo(struct fs32_fsinfo_parms *parms) {
    char           *pData;
    int             rc;
    int             rc2;

    FSALLOCATE        *pfsil_alloc;
    struct super_block *            sb;
    struct ext2_super_block       *psb;
    struct vpfsi32 *pvpfsi;
    union  vpfsd32 *pvpfsd;
    PTR16  pvpfsi16;
    PTR16  pvpfsd16;
    struct FSINFO16 *pvolser;
    char lock[12];
    unsigned long PgCount;

    parms = __StackToFlat(parms);

    if ((rc = DevHlp32_VirtToLin(parms->pData, __StackToFlat(&pData))) == NO_ERROR) {
    /*******************************************************************/
    /*** Traitement des cas suivant flag (INFO_RETRIEVE - INFO_SET)  ***/
    /*******************************************************************/
    switch(parms->flag) {
        /*******************************************************************/
        /*** INFO_RETRIEVE : retrieves file system information           ***/
        /*******************************************************************/
        case INFO_RETREIVE :
            switch(parms->level) {
                case FSIL_VOLSER :
#ifdef FS_TRACE
                    if ((rc = fs_log("FS_FSINFO : flag = INFO_RETREIVE, level = FSIL_VOLSER")) != NO_ERROR) {
                        return rc;
                    } /* end if */
#endif
                    if ((rc = fsh32_getvolparm(parms->hVPB, __StackToFlat(&pvpfsi16), __StackToFlat(&pvpfsd16))) == NO_ERROR) {
                        if ((rc = DevHlp32_VirtToLin(pvpfsi16, __StackToFlat(&pvpfsi))) == NO_ERROR) {
                        if ((rc = DevHlp32_VirtToLin(parms->pData, __StackToFlat(&pData))) == NO_ERROR) {

                            rc = DevHlp32_VMLock(VMDHL_LONG | VMDHL_VERIFY | VMDHL_WRITE, pData, sizeof(struct FSINFO16), (void *)-1, __StackToFlat(lock), __StackToFlat(&PgCount));
                            if ((rc == NO_ERROR) || (rc == ERROR_NOBLOCK)) {

                                pvolser          = (struct FSINFO16 *)pData;
                                pvolser->ulVSN   = pvpfsi->vpi_vid;
                                pvolser->vol.cch = (BYTE)strlen(pvpfsi->vpi_text);
                                strcpy(pvolser->vol.szVolLabel, pvpfsi->vpi_text);
                                rc = NO_ERROR;

			        if ((rc2 = DevHlp32_VMUnlock(__StackToFlat(lock))) == NO_ERROR) {
                                } else {
	   		            rc = rc2;
                                }

		            }

                        }
                        }
                    }
		    break;

                case FSIL_ALLOC :
#ifdef FS_TRACE
                    if ((rc = fs_log("FS_FSINFO : flag = INFO_RETREIVE, level = FSIL_ALLOC")) != NO_ERROR) {
                        return rc;
                    } /* end if */
#endif
                        if ((rc = DevHlp32_VirtToLin(parms->pData, __StackToFlat(&pData))) == NO_ERROR) {

                            rc = DevHlp32_VMLock(VMDHL_LONG | VMDHL_VERIFY | VMDHL_WRITE, pData, sizeof(FSALLOCATE), (void *)-1, __StackToFlat(lock), __StackToFlat(&PgCount));
                            if ((rc == NO_ERROR) || (rc == ERROR_NOBLOCK)) {
                    sb = getvolume(parms->hVPB);
                    psb = (struct ext2_super_block *)sb->u.ext2_sb.s_sbh->b_data;
                    pfsil_alloc = (FSALLOCATE *)pData;
//                  pfsil_alloc->idFileSystem      =  ????? ;
                    pfsil_alloc->cSectorUnit       = sb->sectors_per_block;
                    pfsil_alloc->cUnit             = psb->s_blocks_count;
                    pfsil_alloc->cUnitAvail        = (psb->s_free_blocks_count > psb->s_r_blocks_count ? psb->s_free_blocks_count - psb->s_r_blocks_count : 0);
                    pfsil_alloc->cbSector          = (UINT16)sb->sector_size;
                    rc = NO_ERROR;
			        if ((rc2 = DevHlp32_VMUnlock(__StackToFlat(lock))) == NO_ERROR) {
                                } else {
	   		            rc = rc2;
                                }

		            }

                        }

		    break;

                default :
                    rc = ERROR_INVALID_PARAMETER;
		    break;
            }
            break;
        /*******************************************************************/

        /*******************************************************************/
        /*** INFO_SET : used to set the volume label and volume serial   ***/
        /***            number. We currently do nothing                  ***/
        /*******************************************************************/
        case INFO_SET :
#ifdef FS_TRACE
            kernel_printf("FS_FSINFO(INFO_SET)");
#endif
            if (Read_Write) {
                rc = NO_ERROR;
            } else {
                rc = ERROR_WRITE_PROTECT;
            }
        /*******************************************************************/

        /*******************************************************************/
        /*** Unknown flag                                                ***/
        /*******************************************************************/
        default :
            rc = ERROR_INVALID_PARAMETER;
	    break;
        /*******************************************************************/
    }
    }
    return rc;
}
