//
// $Header: D:/32bits/ext2-os2/fsd32/rcs/fs32_findfirst.c,v 1.1 1996/09/21 22:25:02 Willm Exp $
//

// 32 bits Linux ext2 file system driver for OS/2 WARP - Allows OS/2 to
// access your Linux ext2fs partitions as normal drive letters.
// Copyright (C) 1995, 1996 Matthieu WILLM
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
#ifdef __IBMC__
#pragma strings(readonly)
#endif


#define INCL_DOS
#define INCL_DOSERRORS
#define INCL_NOPMAPI
#include <os2.h>

#include <string.h>

#include <os2/types.h>
#include <os2/StackToFlat.h>
#include <linux/fs.h>
#include <os2/os2proto.h>
#include <os2/fsd32.h>
#include <os2/DevHlp32.h>
#include <os2/log.h>
#include <os2/trace.h>
#include <os2/errors.h>
#include <os2/files.h>
#include <os2/volume.h>
#include <linux/fs_proto.h>
#include <linux/stat.h>
#include <os2/filefind.h>


/*
 * struct fs32_findfirst_parms {
 *     unsigned short  flags;
 *     unsigned short  level;
 *     PTR16           pcMatch;
 *     unsigned short  cbData;
 *     PTR16           pData;
 *     PTR16           pfsfsd;
 *     PTR16           pfsfsi;
 *     unsigned short  attr;
 *     unsigned short  iCurDirEnd;
 *     PTR16           pName;
 *     PTR16           pcdfsd;
 *     PTR16           pcdfsi;
 * };
 */
int FS32ENTRY fs32_findfirst(struct fs32_findfirst_parms *parms) {
    struct fsfsi32 *pfsfsi;
    struct fsfsd32 *pfsfsd;
//    struct cdfsi32 *pcdfsi;
//    union  cdfsd32 *pcdfsd;
    char           *pName;
    char           *pData;
    unsigned short *pcMatch;
    int             rc;
    int             rc2;
    UINT32                   openmode = 0;
    char                    *pNom;
    struct file        *     p_file;
    struct super_block *     p_volume;
//    id_t                     myid;
    char          lock[12];
    int           caseRetensive;
    ULONG PgCount;

    parms = __StackToFlat(parms);

    if ((rc = DevHlp32_VirtToLin(parms->pfsfsi, __StackToFlat(&pfsfsi))) == NO_ERROR) {
        if ((rc = DevHlp32_VirtToLin(parms->pfsfsd, __StackToFlat(&pfsfsd))) == NO_ERROR) {
//            if ((rc = DevHlp32_VirtToLin(parms->pcdfsi, __StackToFlat(&pcdfsi))) == NO_ERROR) {
//                if ((rc = DevHlp32_VirtToLin(parms->pcdfsd, __StackToFlat(&pcdfsd))) == NO_ERROR) {
                    if ((rc = DevHlp32_VirtToLin(parms->pData, __StackToFlat(&pData))) == NO_ERROR) {
                        if ((rc = DevHlp32_VirtToLin(parms->pName, __StackToFlat(&pName))) == NO_ERROR) {
                            if ((rc = DevHlp32_VirtToLin(parms->pcMatch, __StackToFlat(&pcMatch))) == NO_ERROR) {
    if (trace_FS_FINDFIRST) {
        kernel_printf("FS_FINDFIRST pre-invocation : %s , match = %u , level = %u, flag = %u)", pName, *pcMatch, parms->level, parms->flags);
    }

    /*
     * Checks that flags is valid.
     */
    if ((parms->flags == FF_NOPOS) ||
        (parms->flags == FF_GETPOS)) {

        /*
         * Checks that level is valid.
         */
        if ((parms->level == FIL_STANDARD)    ||
            (parms->level == FIL_QUERYEASIZE) ||
            (parms->level == FIL_QUERYEASFROMLIST)) {

            /*
             * Checks that *pcMatch is not 0
             */
            if (*pcMatch) {
                /*
                 * Is it a case retensive search ?
                 */
                openmode = (caseRetensive = is_case_retensive() ? OPENMODE_DOSBOX : 0);

                    /*
                     * Gets the superblock from pfsfsi.
                     */
                    if ((p_volume = getvolume(pfsfsi->fsi_hVPB)) != 0) {

                        /*
                         * Saves the file name to search into pfsfsd
                         */
//                        if ((((p_hfind)pfsfsd)->pName = G_malloc(5 * CCHMAXPATH)) != 0) {
                        if ((rc = DevHlp32_VMAlloc(5 * CCHMAXPATH, VMDHA_NOPHYSADDR, VMDHA_SWAP, (void **)(&(((p_hfind)pfsfsd)->pName)))) == NO_ERROR) {
                            strcpy(((p_hfind)pfsfsd)->pName, pName);
                            pNom = ((p_hfind)pfsfsd)->pName + CCHMAXPATH;

                            /*
                             * Adds MAY_HAVE_READONLY to the attributes to search for (cf doc : this bit is never passed to the IFS)
                             */
                            ((p_hfind)pfsfsd)->attr = parms->attr  | FILE_READONLY;

                            /*
                             * Extracts the name of the parent directory.
                             */
                            ExtractPath(pName, pNom);

                            /*
                             * Tries to open the parent directory.
                             */
                            if ((p_file = _open_by_name(p_volume, pNom, openmode | OPENMODE_READONLY)) != 0) {
                                ((p_hfind)pfsfsd)->p_file = p_file;

                                /*
                                 * Locks the user buffer so that another thread can't free it from under us.
                                 */
//                                if ((rc = LockUserBuffer(pData, cbData, lock, LOCK_WRITE, &lock_lin)) == NO_ERROR) {
                if ((rc = DevHlp32_VMLock(VMDHL_LONG | VMDHL_VERIFY | VMDHL_WRITE, pData, parms->cbData, (void *)-1, __StackToFlat(lock), __StackToFlat(&PgCount))) == NO_ERROR) {

                                   /*
                                    * Do the actual search
                                    */
                                    rc = myfindnext(
                                                    p_volume,
                                                    p_file,
                                                    parms->attr | FILE_READONLY,
                                                    pfsfsi,
                                                    pfsfsd,
                                                    pData,
                                                    parms->cbData,
                                                    pcMatch,
                                                    parms->level,
                                                    parms->flags,
                                                    0,
                                                    1,
                                                    caseRetensive
                                                   );
                                    /*
                                     * Unlocks the user buffer.
                                     */
                                    if ((rc2 = DevHlp32_VMUnlock(__StackToFlat(lock))) == NO_ERROR) {
                                        /* Nothing else to do */
                                    } else {
                                        kernel_printf("FS_READ : VMUnlock() returned %d", rc);
                                        rc = rc2;
                                    } /* VMUnlock failed */
                                } else {
                                    kernel_printf("FS_FINDFIRST - LockUserBuffer returned %d", rc);
                                } /* LockUserBuffer failed */
                            } else {
                                rc = ERROR_PATH_NOT_FOUND;
                            } /* Parent directory not found */
                        } else {
                            kernel_printf("FS_FINDFIRST - No more memory");
                            rc = ERROR_NOT_ENOUGH_MEMORY;
                        } /* G_malloc failed */
                    } else {
                        kernel_printf("FS_FINDFIRST - Couldn't get the superblock from pfsfsi");
                        rc = ERROR_INVALID_PARAMETER;
                    } /* p_volume invalid */
            } else {
                kernel_printf("FS_FINDFIRST - pcMatch = 0");
                rc =  ERROR_INVALID_PARAMETER;
            } /* pcMatch = 0 */
        } else {
            kernel_printf("FS_FINDFIRST - invalid level %d", rc);
            rc =  ERROR_INVALID_PARAMETER;
        }  /* Invalid level */
    } else {
         kernel_printf("FS_FINDFIRST() - invalid flag %d", parms->flags);
         rc = ERROR_INVALID_PARAMETER;
    } /* Invalid flag */

    if (trace_FS_FINDFIRST) {
        kernel_printf("FS_FINDFIRST post-invocation - rc = %d - pcMatch = %d", rc, *pcMatch);
    }

                            }
                        }
                    }
//                }
//            }
        }
    }
    return rc;
}
