//
// $Header: D:/32bits/ext2-os2/fsd32/rcs/fs32_delete.c,v 1.1 1996/09/21 22:24:46 Willm Exp $
//

// 32 bits Linux ext2 file system driver for OS/2 WARP - Allows OS/2 to
// access your Linux ext2fs partitions as normal drive letters.
// Copyright (C) 1995, 1996 Matthieu WILLM
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
#ifdef __IBMC__
#pragma strings(readonly)
#endif


#define INCL_DOS
#define INCL_DOSERRORS
#define INCL_NOPMAPI
#include <os2.h>

#include <string.h>

#include <os2/types.h>
#include <os2/StackToFlat.h>
#include <linux/fs.h>
#include <os2/os2proto.h>
#include <os2/fsd32.h>
#include <os2/DevHlp32.h>
#include <os2/log.h>
#include <os2/trace.h>
#include <os2/errors.h>
#include <os2/files.h>
#include <os2/volume.h>
#include <linux/fs_proto.h>
#include <linux/stat.h>

#define THISFILE FILE_TEST_C	// obsolete
/*
 * struct fs32_delete_parms {
 *     unsigned short      iCurDirEnd;
 *     PTR16               pFile;
 *     PTR16               pcdfsd;
 *     PTR16               pcdfsi;
 * };
 */
int FS32ENTRY fs32_delete(struct fs32_delete_parms *parms) {
    char           *pFile;
    struct cdfsi32 *pcdfsi;
//    union  cdfsd32 *pcdfsd;
    int             rc;
    struct super_block *sb;       /* volume descriptor */
    struct inode       *dir;
    struct file        *filp;
    char                parent[CCHMAXPATH];
    char                name[CCHMAXPATH];
    char                *__name = __StackToFlat(name);
    int                DOSmode;
    umode_t                i_mode;

    parms = __StackToFlat(parms);

    if ((rc = DevHlp32_VirtToLin(parms->pcdfsi, __StackToFlat(&pcdfsi))) == NO_ERROR) {
//        if ((rc = DevHlp32_VirtToLin(parms->pcdfsd, __StackToFlat(&pcdfsd))) == NO_ERROR) {
            if ((rc = DevHlp32_VirtToLin(parms->pFile, __StackToFlat(&pFile))) == NO_ERROR) {
    /*
     * Trace
     */
    if (trace_FS_DELETE) {
        kernel_printf("FS_DELETE(%s)", pFile);
    }

    DOSmode = (is_case_retensive() ? OPENMODE_DOSBOX : 0);

    if (Read_Write) {

    //
    // *** This is UGLY ... but it works !
    //



        sb = getvolume(pcdfsi->cdi_hVPB);

        if ((filp = _open_by_name(sb, pFile, OPENMODE_READONLY | DOSmode)) == NULL) {
#ifdef FS_TRACE
            fs_err(FUNC_FS_DELETE, FUNC_OPEN_BY_NAME, -1, THISFILE, __LINE__);
#endif
            return ERROR_FILE_NOT_FOUND;
        } /* end if */
        i_mode = filp->f_inode->i_mode;
        if ((rc = vfs_close(filp)) != NO_ERROR) {
            fs_err(FUNC_FS_DELETE, FUNC_CLOSE, rc, THISFILE, __LINE__);
            return -1;
        }
        if (!S_ISREG(i_mode)) {
#ifdef FS_TRACE
                kernel_printf("FS_DELETE - %s is not a regular file", pFile);
#endif
            return ERROR_ACCESS_DENIED;
        }
        if ((!(i_mode & S_IWUSR)) &&
            (!(i_mode & S_IWGRP)) &&
            (!(i_mode & S_IWOTH))) {
#ifdef FS_TRACE
            kernel_printf("FS_DELETE - %s is read only", pFile);
#endif
            return ERROR_ACCESS_DENIED;
        }


        ExtractPath(pFile, __StackToFlat(parent));
        ExtractName(pFile, __StackToFlat(name));
        if ((filp = _open_by_name(sb, __StackToFlat(parent), OPENMODE_READONLY | DOSmode)) == NULL) {
#ifdef FS_TRACE
            fs_err(FUNC_FS_DELETE, FUNC_OPEN_BY_NAME, -1, THISFILE, __LINE__);
#endif
            return ERROR_PATH_NOT_FOUND;
        } /* end if */
        dir = filp->f_inode;
        dir->i_count ++;
        if ((rc = vfs_close(filp)) != NO_ERROR) {
            fs_err(FUNC_FS_DELETE, FUNC_CLOSE, rc, THISFILE, __LINE__);
            return -1;
        }

//        dir = iget(sb, ino_no);
        if ((rc = dir->i_op->unlink (dir, __StackToFlat(name), strlen(__name))) != NO_ERROR) {
            kernel_printf("FS_DELETE(%s) : dir->i_op->unlink() - rc = %d", pFile, rc);
        }
//        iput(dir);
        rc = map_err(rc);        // rc is a Linux error code (from linux/errno.h)
    } else {
        rc = ERROR_WRITE_PROTECT;
    }
            }
//        }
    }
    return rc;
}
