//
// $Header: D:/32bits/ext2-os2/fsd32/rcs/fs32_chgfileptr.c,v 1.2 1996/12/12 21:28:30 Willm Exp $
//

// 32 bits Linux ext2 file system driver for OS/2 WARP - Allows OS/2 to
// access your Linux ext2fs partitions as normal drive letters.
// Copyright (C) 1995, 1996 Matthieu WILLM
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
#ifdef __IBMC__
#pragma strings(readonly)
#endif


#define INCL_DOS
#define INCL_DOSERRORS
#define INCL_NOPMAPI
#include <os2.h>

#include <os2/types.h>
#include <os2/StackToFlat.h>
#include <linux/fs.h>
#include <os2/os2proto.h>
#include <os2/fsd32.h>
#include <os2/DevHlp32.h>
#include <os2/log.h>
#include <os2/trace.h>

#ifdef USE_VDH_HELP
extern void * _Pascal VDHQueryLin(PTR16);
#endif


extern unsigned long event;

/*
 * struct fs32_chgfileptr_parms {
 *     unsigned short IOflag;
 *     unsigned short type;
 *     long           offset;
 *     PTR16          psffsd;
 *     PTR16          psffsi;
 * };
 */
int FS32ENTRY fs32_chgfileptr(struct fs32_chgfileptr_parms *parms) {
    off_t           newfileptr;
    struct sffsi32 *psffsi;
    union  sffsd32 *psffsd;
    int             rc;

    parms = __StackToFlat(parms);

#ifndef USE_VDH_HELP
    if ((rc = DevHlp32_VirtToLin(parms->psffsi, __StackToFlat(&psffsi))) == NO_ERROR) {
        if ((rc = DevHlp32_VirtToLin(parms->psffsd, __StackToFlat(&psffsd))) == NO_ERROR) {
#else
    psffsi = VDHQueryLin(parms->psffsi);
    psffsd = VDHQueryLin(parms->psffsd);
#endif

    /*******************************************************************/
    /*** Gets the file structure from psffsd                         ***/
    /*******************************************************************/
    if (psffsd->f == 0) {
        kernel_printf("FS_CHGFILEPTR() - file is NULL");
        return ERROR_INVALID_PARAMETER;
    }
    /*******************************************************************/


    if (trace_FS_CHGFILEPTR) {
        kernel_printf("FS_CHFILEPTR : ino = %lu - type = %d", psffsd->f->f_inode->i_ino, parms->type);
    }
    switch(parms->type) {
        case CFP_RELBEGIN :
            newfileptr = parms->offset;
            break;

        case CFP_RELCUR :
            newfileptr = psffsi->sfi_position + parms->offset;
            break;

        case CFP_RELEND :
            newfileptr = psffsd->f->f_inode->i_size + parms->offset;
            break;

        default :
            kernel_printf("FS_CHFILEPTR( ino = %lu ) : unknown type", psffsd->f->f_inode->i_ino);
            return ERROR_INVALID_PARAMETER;
    }

    //
    // Offsets below 0 should normally be supported for DOS box requests
    //
    if (newfileptr < 0) {
        kernel_printf("FS_CHGFILEPTR - new file pointer is < 0");
        return ERROR_INVALID_PARAMETER;
    }

    psffsd->f->f_pos        = newfileptr;
    psffsd->f->f_reada      = 0;
    psffsd->f->f_version    = ++event;

    psffsi->sfi_position = newfileptr;
    rc =  NO_ERROR;
#ifndef USE_VDH_HELP
        }
    }
#endif
    return rc;
}
