//
// $Header: D:/32bits/ext2-os2/fsd32/rcs/fs32_allocatepagespace.c,v 1.1 1996/09/21 22:23:57 Willm Exp $
//

// 32 bits OS/2 device driver and IFS support driver. Provides 32 bits kernel
// services (DevHelp) and utility functions to 32 bits OS/2 ring 0 code
// (device drivers and installable file system drivers).
// Copyright (C) 1995, 1996 Matthieu WILLM
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

#ifdef __IBMC__
#pragma strings(readonly)
#endif


#define INCL_DOS
#define INCL_DOSERRORS
#define INCL_NOPMAPI
#include <os2.h>

#include <string.h>

#include <os2/types.h>
#include <os2/StackToFlat.h>
#include <os2/fsd32.h>
#include <os2/fsh32.h>
#include <os2/DevHlp32.h>

#include <linux/stat.h>

#include <os2/os2proto.h>
#include <os2/ifsdbg.h>
#include <os2/filefind.h>
#include <os2/errors.h>
#include <os2/log.h>
#include <os2/volume.h>
#include <os2/files.h>
#include <os2/os2misc.h>
#include <os2/trace.h>

#include <linux/fs.h>
#include <linux/fs_proto.h>
#include <linux/ext2_fs.h>
#include <linux/ext2_proto.h>
#include <linux/sched.h>

extern int swap_in_progress;

int do_allocatepagespace(struct sffsi32 *psffsi, union sffsd32 *psffsd, unsigned long ulSize) {
    int                 rc = NO_ERROR;
    struct file        *f;
    struct buffer_head *bh;
    unsigned long       tmp;
    blk_t               start, end, i;
    int                 err;


    if (trace_FS_ALLOCATEPAGESPACE) {
        kernel_printf("FS_ALLOCATEPAGESPACE pre-invocation - size=%lu", ulSize);
    }

    /*
     * Increments the swap flag
     */
    swap_in_progress ++;

    /*
     * Gets the file structure from psffsd
     */
    if ((f = psffsd->f) != 0) {

        /*
         * Updates the I-node
         */
        tmp = f->f_inode->i_size;
        f->f_inode->i_size       = ulSize;
        if (ulSize < tmp) {
            f->f_inode->i_op->truncate(f->f_inode);
        } else {
            start = tmp / f->f_inode->i_sb->s_blocksize;
            end   = (ulSize + f->f_inode->i_sb->s_blocksize - 1) / f->f_inode->i_sb->s_blocksize;
            for (i = start; i < end; i++) {
                bh = ext2_getblk (f->f_inode, i, 1, __StackToFlat(&err));
                if (bh) {
                    bforget(bh);
                } else {
                    ulSize = i * f->f_inode->i_sb->s_blocksize;
                    f->f_inode->i_size = ulSize;
                    rc  = map_err(err);
                    i = end + 1;
                }
            }
        }


        f->f_inode->i_mtime      = CURRENT_TIME;
        f->f_inode->i_dirt       = 1;

        /*
         * Updates the SFT
         */
        psffsi->sfi_size            = ulSize;
        psffsi->sfi_tstamp         |= ST_PWRITE;

        /*
         * Commits changes to disk
         */
        VFS_fsync(f);
    } else {
        rc = ERROR_INVALID_PARAMETER;
    }

    /*
     * Decrements the swap flag
     */
    swap_in_progress --;

    if (trace_FS_ALLOCATEPAGESPACE) {
        kernel_printf("FS_ALLOCATEPAGESPACE post-invocation - rc = %d", rc);
    }
    return rc;
}

/*
 * struct fs32_allocatepagespace_parms {
 *     unsigned long ulWantContig; 
 *     unsigned long ulSize;
 *     PTR16 psffsd;
 *     PTR16 psffsi;
 * };
 */
int FS32ENTRY fs32_allocatepagespace(struct fs32_allocatepagespace_parms *parms) {
    struct sffsi32 *psffsi;
    union  sffsd32 *psffsd;
    int             rc;


    parms = __StackToFlat(parms);

    if ((rc = DevHlp32_VirtToLin(parms->psffsi, __StackToFlat(&psffsi))) == NO_ERROR) {
        if ((rc = DevHlp32_VirtToLin(parms->psffsd, __StackToFlat(&psffsd))) == NO_ERROR) {
            rc = do_allocatepagespace(psffsi, psffsd, parms->ulSize);
        }
    }

    return rc;
}
