#define INCL_DOS
#define INCL_DOSDEVIOCTL
#define INCL_DOSERRORS
#define INCL_NOPMAPI
#include <os2.h>

#include <stdio.h>
#include <string.h>
#include <unistd.h>
#include <stdlib.h>
#include <fcntl.h>
#include <time.h>
#include <errno.h>
#include <linux/stat.h>
#include <os2/types.h>

#include <linux/ext2_fs.h>

#include "ext2fs.h"

#include "et/com_err.h"
#include "ext2_err.h"

#define FLAGS_DASD   1		/* 1 : OPEN_FLAGS_DASD open         0 : normal open */
#define FLAGS_LOCKED 2		/* 1 : IOCtl DSK_LOCKDRIVE called   0 : not called  */
#define FLAGS_FORMAT 4          /* 1 : IOCtl DSK_BEGINFORMAT called 0 : not called  */

struct unix_private_data {
	int	magic;
	int	dev;
	int	flags;
	char	*buf;
	int	buf_block_nr;
#ifdef OS2
	int os2_flags;
#endif
};

static char *fs_name = "ext2";
int os2_open(const char *name, int flags, struct unix_private_data *data) {
    APIRET rc;
    HFILE  f;
    int namelen;
    int open_flags;
    int rw;
    ULONG action;
    ULONG parmio;
    ULONG dataio;
    ULONG pio;
    ULONG dio;

    namelen = strlen(name);
    printf("\tOS2 : os2_open %s %d\n", name, namelen);

    data->os2_flags = 0;
    /*
     * Case where "name" is a drive letter (block device name) : OS/2 has special requirements.
     */
    if ((namelen == 2) && (name[1] == ':') && (((name[0] >= 'A') && (name[0] <= 'Z')) || ((name[0] >= 'a') && (name[0] <= 'z')))) {
        rw = flags & IO_FLAG_RW ? OPEN_ACCESS_READWRITE | OPEN_SHARE_DENYWRITE : OPEN_ACCESS_READONLY | OPEN_SHARE_DENYNONE;

        printf("\tOS2 : opening %s in DASD mode\n", name);
        if ((rc = DosOpen(
                      name, 
                      &f, 
                      &action, 
                      0, 
                      0, 
                      OPEN_ACTION_OPEN_IF_EXISTS, 
                      OPEN_FLAGS_DASD | OPEN_FLAGS_NO_CACHE | OPEN_FLAGS_WRITE_THROUGH  | rw, 
                      NULL
                     )) == NO_ERROR) {
            data->os2_flags = FLAGS_DASD;
            printf("\tOS2 : DosOpen OK\n");
            /*
             * In case the drive is mounted RW, we must lock the drive.
             */
            if (flags & IO_FLAG_RW) {
                parmio = 0;
                dataio = 0;
                pio    = 1;
                dio    = 1;
                if ((rc = DosDevIOCtl(
                                      f,
                                      IOCTL_DISK,
                                      DSK_LOCKDRIVE,
                                      &parmio, 1, &pio,
                                      &dataio, 1, &dio
                                     )) != NO_ERROR) {
                    os2_err(rc);
                    DosClose(f);
                    f = -1;
                    errno = EACCES;                   
                } else {
                    data->os2_flags |= FLAGS_LOCKED;

                    parmio = (ULONG)fs_name;
                    pio    = sizeof(char *);
                    dio    = 1;
                    dataio = 0;
                    if ((rc = DosDevIOCtl(
                                          f,
                                          IOCTL_DISK,
                                          DSK_BEGINFORMAT,
                                          &parmio, pio, &pio,
                                          &dataio, dio, &dio
                                         )) != NO_ERROR) {
                        os2_err(rc);
                        DosClose(f);
                        f = -1;
                        errno = EACCES;
                    } else {
                        data->os2_flags |= FLAGS_FORMAT;
                    }
                }
            }
        } else {
            os2_err(rc);                                              
            f = -1;
            errno = EACCES;
        }
        return f;
    }

    /*
     * Case where "name" is a regular file name or a character device name
     */
    return open(name, ((flags & IO_FLAG_RW) ? O_RDWR : O_RDONLY) | O_BINARY);

}

int os2_close(int fd, struct unix_private_data *data) {
    APIRET rc;
    ULONG parmio;
    ULONG dataio;
    ULONG pio;
    ULONG dio;
    
    if ((data->os2_flags & FLAGS_DASD) && (data->os2_flags & FLAGS_FORMAT)) {
        printf("\n\tOS2 : Redetermining media\n");
        parmio = 0;
        dataio = 0;
        pio = 1;
        dio = 1;
        rc = DosDevIOCtl(
                         fd,
                         IOCTL_DISK,
                         DSK_REDETERMINEMEDIA,
                         &parmio, pio, &pio,
                         &dataio, dio, &dio
                        );
         if (rc != NO_ERROR) {
             os2_err(rc);
         }
    }

    if ((data->os2_flags & FLAGS_DASD) && (data->os2_flags & FLAGS_LOCKED)) {
        printf("\tOS2 : Unlocking drive\n");
        parmio = 0;
        dataio = 0;
        pio = 1;
        dio = 1;
        rc = DosDevIOCtl(
                         fd,
                         IOCTL_DISK,
                         DSK_UNLOCKDRIVE,
                         &parmio, pio, &pio,
                         &dataio, dio, &dio
                        );
         if (rc != NO_ERROR) {
             os2_err(rc);
         }
    }

    printf("\tOS2 : Closing drive\n");
    return close(fd);
}


#pragma pack(1)


// 
// Extended Boot record structure and extended BPB (from the IBM IFS document)
//
struct Extended_BPB {
    unsigned short BytePerSector;
    unsigned char SectorPerCluster;
    unsigned short ReservedSectors;
    unsigned char NumberOfFats;
    unsigned short RootEntries;
    unsigned short TotalSectors;
    unsigned char MediaDescriptor;
    unsigned short SectorsPerFat;
    unsigned short SectorsPerTrack;
    unsigned short Heads;
    unsigned long HiddenSectors;
    unsigned long Ext_TotalSectors;
};

struct Extended_Boot {
    unsigned char Boot_jmp[3];
    unsigned char Boot_OEM[8];
    struct Extended_BPB Boot_BPB;
    unsigned char Boot_DriveNumber;
    unsigned char Boot_CurrentHead;
    unsigned char Boot_Sig;
    unsigned long Boot_Serial;
    unsigned char Boot_Vol_Label[11];
    unsigned char Boot_System_ID[8];
};

struct boot_sector {
    struct Extended_Boot boot;
    char                 pad1[512 - sizeof(struct Extended_Boot) - sizeof(unsigned short)];
    unsigned short       sig;       // 0xAA55
    unsigned char        media;     // media type
    char                 pad2[511]; 
};

struct parm {
    unsigned char command;
    unsigned char drive;
};

struct data {
    BIOSPARAMETERBLOCK bpb;
    unsigned short     nr_cyl;
    unsigned char      devtype;
    unsigned short     devattr;
};
#pragma pack(4)

int make_dos_compatible_boot_sector(ext2_filsys fs) {
    APIRET                    rc;
    struct boot_sector        boot;
    int                       retval;
    struct unix_private_data *data;

    data = (struct unix_private_data *)(fs->io->private_data);


    if (data->os2_flags & FLAGS_DASD) {
        /*
         * This is a drive
         */
        struct parm p;
        struct data d;
        unsigned long plen = sizeof(p);
        unsigned long dlen = sizeof(d);

        p.command = 0;
        p.drive   = 0;
        /*
         * Retrieves the recommended BPB for the drive.
         */
        if ((rc = DosDevIOCtl(
                              (HFILE)(data->dev),
                              IOCTL_DISK,
                              DSK_GETDEVICEPARAMS,
                              &p, plen, &plen,
                              &d, dlen, &dlen
                             )) != NO_ERROR) {
            fprintf(stderr, "DosDevIOCtl failed with rc = %d in file %s at line %d\n", rc, __FILE__, __LINE__);
            os2_err(rc);
            return -1;
        }

        memset(&boot, 0, sizeof(boot));

        /*
         * We put the recommended BPB in sector 0. ext2 doesn't care, but this
         * makes OS/2 happy. (there's a bug in the OS/2 kernel that prevents FLOPPIES
         * with a non DOS boot sector to be mounted by an IFS).
         */

        boot.boot.Boot_BPB.BytePerSector        = d.bpb.usBytesPerSector;
        boot.boot.Boot_BPB.SectorPerCluster     = d.bpb.bSectorsPerCluster;
        boot.boot.Boot_BPB.ReservedSectors      = d.bpb.usReservedSectors;
        boot.boot.Boot_BPB.NumberOfFats         = d.bpb.cFATs;
        boot.boot.Boot_BPB.RootEntries          = d.bpb.cRootEntries;
        boot.boot.Boot_BPB.TotalSectors         = d.bpb.cSectors;
        boot.boot.Boot_BPB.MediaDescriptor      = d.bpb.bMedia;
        boot.boot.Boot_BPB.SectorsPerFat        = d.bpb.usSectorsPerFAT;
        boot.boot.Boot_BPB.SectorsPerTrack      = d.bpb.usSectorsPerTrack;
        boot.boot.Boot_BPB.Heads                = d.bpb.cHeads;
        boot.boot.Boot_BPB.HiddenSectors        = d.bpb.cHiddenSectors;
        boot.boot.Boot_BPB.Ext_TotalSectors     = d.bpb.cLargeSectors;

        strncpy(boot.boot.Boot_System_ID, "ext2    ", 8);
        strncpy(boot.boot.Boot_OEM, "OS2 WARP", 8);
        strncpy(boot.boot.Boot_Vol_Label, "NO LABEL   ", 11);
        boot.boot.Boot_Sig    = 41;
        boot.boot.Boot_Serial = 0xABCDDCBA;
        boot.sig              = 0xAA55;
        boot.media            = d.bpb.bMedia;


        retval = io_channel_write_blk(fs->io, 0, -1024, &boot);
        if (retval)
    	    printf("Warning: could not write boot block 0: %s\n", 
	           error_message(retval));

    } else {
        /*
         * This is NOT a drive -> don't bother.
         */
        retval = 0;
    }
    return retval;

}