//
// $Header: D:/32bits/ext2-os2/RCS/volume.c,v 1.1 1996/09/22 23:14:04 Willm Exp Willm $
//

// Linux ext2 file system driver for OS/2 2.x and WARP - Allows OS/2 to
// access your Linux ext2fs partitions as normal drive letters.
// Copyright (C) 1995, 1996 Matthieu WILLM
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

//
// Will be eventually moved to ext2/super.c, and openvolume will be split into
// ext2_read_super() and its calling VFS routine
//
#ifdef __IBMC__
#pragma strings(readonly)
#endif


#define INCL_DOSERRORS
#define INCL_NOPMAPI
#include <os2.h>
#include <string.h>

#include <os2/errors.h>


#include <os2/types.h>
#include <os2/fsh32.h>
#include <os2/devhlp32.h>
#include <os2/StackToFlat.h>
#include <os2/os2proto.h>
#include <os2/os2misc.h>


#include <linux/fs.h>
#include <linux/ext2_fs.h>
#include <linux/fs_proto.h>
#include <linux/ext2_proto.h>
#include <linux/sched.h>

#include <os2/log.h>         /* Prototypes des fonctions de log.c                      */
#include <os2/volume.h>      /* Prototypes des fonctions de volume.c                   */
#include <os2/minifsd.h>




//
// Called by MFS_TERM to do ring 0 initializations and inherit files and volumes
// opened by the minifsd.
//
int FS32CALLBACK inherit_minifsd_data(PTR16 __mfs_data) {
    struct super_block *sb;
    int db_count;
    int i, j;
    int rc;
    struct minifsd_to_fsd_data *mfs_data;

    if ((rc = DevHlp32_VirtToLin(__mfs_data, __StackToFlat(&mfs_data))) != NO_ERROR)
	return rc;

    /*
     * Ring 0 FSD initializations
     */
//    ring0_ext2_os2_init();

    /*
     * Inherits I-nodes used by the mini FSD
     */
    inherit_minifsd_inodes(mfs_data);

    /*
     * Inherits open files from the mini FSD
     */
    inherit_minifsd_files(mfs_data);

    /*
     * Inherits mounted volumes from the mini FSD
     */
#if 0
    for (i = 0; i < NB_MAX_VOLS; i++) {
        if (mfs_data->volglobdat->listvol[i].status == VOL_STATUS_MOUNTED) {
            sb = mfs_data->volglobdat->listvol[i].sb;
            if (sb) {
                /*
                 * re-reads the buffer containing the superblock itself
                 */
                char *tmp = (char *)((char *)(sb->u.ext2_sb.s_es) - (char *)(sb->u.ext2_sb.s_sbh->b_data));
                sb->u.ext2_sb.s_sbh = bread(sb->s_dev, sb->u.ext2_sb.s_sbh->b_blocknr, sb->s_blocksize);
                sb->u.ext2_sb.s_es = (struct ext2_super_block *)((unsigned long)tmp + (unsigned long)(sb->u.ext2_sb.s_sbh->b_data));


                /*
                 * re-reads the buffers containing group descriptors
                 */
                db_count = (sb->u.ext2_sb.s_groups_count + EXT2_DESC_PER_BLOCK(sb) - 1) /
                            EXT2_DESC_PER_BLOCK(sb);
                for (j = 0; j < db_count; j++) {
                    sb->u.ext2_sb.s_group_desc[j] = bread(sb->s_dev, sb->u.ext2_sb.s_group_desc[j]->b_blocknr,
                                                       sb->s_blocksize);
                }

                /*
                 * updates the superblock operations pointer
                 */
                sb->s_op = &ext2_sops;

                /*
                 * updates the volume table
                 */
                volglobdat.listvol[i].sb     = sb;
                volglobdat.listvol[i].status = VOL_STATUS_MOUNTED;
                volglobdat.listvol[i].hVPB   = mfs_data->volglobdat->listvol[i].hVPB;

                /*
                 * remounts in read/write mode if necessary
                 */
                if (Read_Write) {
                    sb->s_flags &= ~MS_RDONLY;
                    ext2_setup_super (sb, sb->u.ext2_sb.s_es);
                }
            } else {
                ext2_os2_panic(0, "MINIFSD volume mounted but sb = 0 !");
            }
        }
    }
#endif
    return NO_ERROR;
}

extern struct super_block * FSH32ENTRY __getvolume(PTR16 pvpfsd);

struct super_block * getvolume(unsigned short hVPB)
{
    struct super_block *sb;
    int                 rc;
    PTR16               pvpfsi;
    PTR16               pvpfsd;

    sb = 0;
    if (hVPB) {
        if ((rc = fsh32_getvolparm(hVPB, __StackToFlat(&pvpfsi), __StackToFlat(&pvpfsd))) == NO_ERROR) {
            sb = __getvolume(pvpfsd);
        } else {
            kernel_printf("getvolume - rc = %d", rc);
        }
    } else {
        /*
         * This should NEVER occur
         */
        kernel_printf("getvolume called with hVPB = 0");
    }
    return sb;
}


