//
// $Header: D:/32bits/ext2-os2/fsd32/RCS/fs32_close.c,v 1.1 1996/09/21 22:24:05 Willm Exp Willm $
//

// 32 bits Linux ext2 file system driver for OS/2 WARP - Allows OS/2 to
// access your Linux ext2fs partitions as normal drive letters.
// Copyright (C) 1995, 1996 Matthieu WILLM
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
#ifdef __IBMC__
#pragma strings(readonly)
#endif


#define INCL_DOS
#define INCL_DOSERRORS
#define INCL_NOPMAPI
#include <os2.h>

#include <string.h>

#include <os2/types.h>
#include <os2/StackToFlat.h>
#include <linux/fs.h>
#include <os2/os2proto.h>
#include <os2/fsd32.h>
#include <os2/DevHlp32.h>
#include <os2/log.h>
#include <os2/errors.h>
#include <os2/trace.h>
#include <os2/files.h>

/*
 * struct fs32_close_parms {
 *     PTR16 psffsd;
 *     PTR16 psffsi;
 *     unsigned short IOflag;
 *     unsigned short type;
 * };
 */
int FS32ENTRY fs32_close(struct fs32_close_parms *parms) {
    struct sffsi32 *psffsi;
    union  sffsd32 *psffsd;
    int             rc;

    parms = __StackToFlat(parms);

    if ((rc = DevHlp32_VirtToLin(parms->psffsi, __StackToFlat(&psffsi))) == NO_ERROR) {
        if ((rc = DevHlp32_VirtToLin(parms->psffsd, __StackToFlat(&psffsd))) == NO_ERROR) {
            if (trace_FS_CLOSE) {
                kernel_printf("FS_CLOSE(ino = %lu, type = %d)",  psffsd->f->f_inode->i_ino, parms->type);
            }


    //
    // Gets the file structure from psffsd
    //
    if (psffsd->f == 0) {
       ext2_os2_panic(1, "FS_CLOSE - file is NULL");
    }

    //
    // Do the time stamping stuff - We propagate the time stamp to disk if the
    // ST_Pxxx flag is set.
    //
    if (psffsi->sfi_tstamp & ST_PCREAT) {
        psffsd->f->f_inode->i_ctime = date_dos2unix(psffsi->sfi_ctime, psffsi->sfi_cdate);
        psffsd->f->f_inode->i_dirt  = 1;
    }

    if (psffsi->sfi_tstamp & ST_PREAD) {
        psffsd->f->f_inode->i_atime = date_dos2unix(psffsi->sfi_atime, psffsi->sfi_adate);
        psffsd->f->f_inode->i_dirt  = 1;
    }

    if (psffsi->sfi_tstamp & ST_PWRITE) {
        psffsd->f->f_inode->i_mtime = date_dos2unix(psffsi->sfi_mtime, psffsi->sfi_mdate);
        psffsd->f->f_inode->i_dirt  = 1;
    }


    //
    // The doc isn't clear about the role of the 'type' parameter. It seems we must
    // only free the resources (file structure in sffsd) at FS_CL_FORSYS time. Otherwise
    // we'' receive an empty sffsd somewhere else !
    // For other 'type' values, maybe we could do a flush ...
    //
    if (parms->type != FS_CL_FORSYS) {
#ifdef FS_TRACE
        kernel_printf("***** Non final system close **** - sffsi->sfi_type = %d - Type = %d", psffsi->sfi_type, type);
#endif
        return NO_ERROR;
    } /* endif */

    //
    // Final close for the system
    //
    if ((parms->type == FS_CL_FORSYS) && (Read_Write) && (psffsd->f->f_inode->i_ino != INODE_DASD)) {
        if (psffsd->f->f_op) {
            if (psffsd->f->f_op->release) {          
                psffsd->f->f_op->release(psffsd->f->f_inode, psffsd->f);            
            } else {
                ext2_os2_panic(1, "FS_CLOSE - psffsd->f->f_op->release == NULL : shouldn't occur in this release");
            }
        } else {
            ext2_os2_panic(1, "FS_CLOSE - psffsd->f->f_op == NULL : shouldn't occur in this release");
        }
    }

    //
    // Closes the file
    //
    if ((rc = vfs_close(psffsd->f)) != NO_ERROR) {
        fs_err(FUNC_FS_CLOSE, FUNC_CLOSE, rc, FILE_TEST_C, __LINE__);
        return rc;
    }

    //
    // Clean up of sffsd (safety purposes ...)
    //
    memset(psffsd, 0, sizeof(union sffsd32));

    rc = NO_ERROR;
        }
    }
    return rc;
}
