//
// $Header: D:/32bits/ext2-os2/fsd32/RCS/fs32_chdir.c,v 1.1 1996/09/21 22:24:00 Willm Exp Willm $
//

// 32 bits Linux ext2 file system driver for OS/2 WARP - Allows OS/2 to
// access your Linux ext2fs partitions as normal drive letters.
// Copyright (C) 1995, 1996 Matthieu WILLM
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
#ifdef __IBMC__
#pragma strings(readonly)
#endif


#define INCL_DOS
#define INCL_DOSERRORS
#define INCL_NOPMAPI
#include <os2.h>

#include <os2/types.h>
#include <os2/StackToFlat.h>
#include <os2/fsd32.h>
#include <os2/fsh32.h>
#include <os2/DevHlp32.h>

#include <linux/stat.h>

#include <os2/os2proto.h>
#include <os2/ifsdbg.h>
#include <os2/filefind.h>
#include <os2/errors.h>
#include <os2/log.h>         /* Prototypes des fonctions de log.c                      */
#include <os2/volume.h>      /* Prototypes des fonctions de volume.c                   */
#include <os2/files.h>       /* Prototypes des fonctions de files.c                    */
#include <os2/os2misc.h>
#include <os2/trace.h>

#include <linux/fs.h>
#include <linux/fs_proto.h>
#include <linux/ext2_fs.h>
#include <linux/ext2_proto.h>
#include <linux/sched.h>

#define THISFILE FILE_FS_DIR_C

/*
 * struct fs32_chdir_parms {
 *     unsigned short      iCurDirEnd;
 *     PTR16               pDir;
 *     PTR16               pcdfsd;
 *     PTR16               pcdfsi;
 *     unsigned short      flag;
 * };
 */
int FS32ENTRY fs32_chdir(struct fs32_chdir_parms *parms) {
    char           *pDir;
    struct cdfsi32 *pcdfsi;
    union  cdfsd32 *pcdfsd;
    int             rc;
    int             DOSmode;
    struct file        *p_file;
    struct super_block *p_volume;
    int                 valid;

    parms = __StackToFlat(parms);

    if ((rc = DevHlp32_VirtToLin(parms->pcdfsd, __StackToFlat(&pcdfsd))) == NO_ERROR) {


    DOSmode = (is_case_retensive() ? OPENMODE_DOSBOX : 0);

    switch(parms->flag) {
        case CD_EXPLICIT :
            if ((rc = DevHlp32_VirtToLin(parms->pDir, __StackToFlat(&pDir))) == NO_ERROR) {
                if ((rc = DevHlp32_VirtToLin(parms->pcdfsi, __StackToFlat(&pcdfsi))) == NO_ERROR) {
            if (trace_FS_CHDIR) {
                kernel_printf("FS_CHDIR( CD_EXPLICIT, %s )", pDir);
            }

            if (parms->iCurDirEnd != ~0) {
                kernel_printf("\tOld CDS is %s", pcdfsi->cdi_curdir);
            }

            //
            // Gets the superblock from pcdfsi
            //
            p_volume = getvolume(pcdfsi->cdi_hVPB);

            if ((p_file = _open_by_name(p_volume, pDir, OPENMODE_READONLY | DOSmode)) == 0) {
                fs_err(FUNC_FS_CHDIR, FUNC_OPEN_BY_NAME, ERROR_PATH_NOT_FOUND, THISFILE, __LINE__);
                return ERROR_PATH_NOT_FOUND;
            } else {
                if (!S_ISDIR(p_file->f_inode->i_mode)) {
                    kernel_printf("FS_CHDIR( %s ) Not a directory", pDir);
                    vfs_close(p_file);
                    return ERROR_ACCESS_DENIED;
                }
                pcdfsd->u.is_valid = 1;
                pcdfsd->u.p_file   = p_file;

                return NO_ERROR;
            } /* end if */
                }
            }
            break;

        case CD_VERIFY   :
            if ((rc = DevHlp32_VirtToLin(parms->pcdfsi, __StackToFlat(&pcdfsi))) == NO_ERROR) {
            if (trace_FS_CHDIR) {
                kernel_printf("FS_CHDIR : flag = CD_VERIFY hVPB=0x%04X", pcdfsi->cdi_hVPB);
            }

            //
            // Gets the superblock from pcdfsi
            //
            p_volume = getvolume(pcdfsi->cdi_hVPB);
            kernel_printf("\tsb->s_status = %d",p_volume->s_status);
            valid    = 1;
            if ((p_file = _open_by_name(p_volume, pcdfsi->cdi_curdir, OPENMODE_READONLY | DOSmode)) == 0) {
                fs_err(FUNC_FS_CHDIR, FUNC_OPEN_BY_NAME, ERROR_PATH_NOT_FOUND, THISFILE, __LINE__);
                valid = 0;
            } else {
            if (!S_ISDIR(p_file->f_inode->i_mode)) {
                kernel_printf("FS_CHDIR( %s ) Not a directory", pDir);
                vfs_close(p_file);
                valid = 0;
            }

            if (pcdfsi->cdi_flags & CDI_ISVALID) {
                vfs_close(pcdfsd->u.p_file);
            }
            if (valid) {
                pcdfsd->u.is_valid = 1;
                pcdfsd->u.p_file   = p_file;
                return NO_ERROR;
            } else {
                vfs_close(p_file);
                return ERROR_PATH_NOT_FOUND;
            }
            }
            }
            break;

        case CD_FREE :
            if (trace_FS_CHDIR) {
                kernel_printf("FS_CHDIR( CD_FREE )");
            }


            if (pcdfsd->u.is_valid == 1) {
                pcdfsd->u.is_valid = 0;
                if ((rc = vfs_close(pcdfsd->u.p_file)) != NO_ERROR) {
                    fs_err(FUNC_FS_CHDIR, FUNC_CLOSE, rc, THISFILE, __LINE__);
                }
//                return rc;
            } else {
                rc = NO_ERROR;
            }
            break;

        default :
            fs_log("FS_CHDIR : invalid flag");
            rc = ERROR_INVALID_PARAMETER;

    }

    }
    return rc;
}
