//
// $Header: D:/ext2-os2/vfs/RCS/f_table.c,v 6.0 1996/01/24 00:00:15 Willm Exp Willm $
//

// Linux ext2 file system driver for OS/2 2.x and WARP - Allows OS/2 to
// access your Linux ext2fs partitions as normal drive letters.
// Copyright (C) 1995, 1996 Matthieu WILLM
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

/*
 *  linux/fs/file_table.c
 *
 *  Copyright (C) 1991, 1992  Linus Torvalds
 */

#ifndef OS2
#include <linux/fs.h>
#include <linux/string.h>
#include <linux/mm.h>
#else
#define INCL_DOSERRORS
#define INCL_NOPMAPI
#include <os2.h>

#include <os2/types.h>
#include <linux/fs.h>
#include <os2/os2proto.h>
#include <os2/files.h>

#if 0
#include <string.h>
#define PAGE_SIZE 61440L                                 // 65536 - 4096 ... to avoid end of segments
#define NR_FILE (PAGE_SIZE / sizeof(struct file))        // As much files as a segment can contain
extern unsigned long event;
#endif

struct file * first_file;
int nr_files = 0;
#endif

long nhfiles     = 0;
long nfreehfiles = 0;
long nusedhfiles = 0;

static struct file *freehfiles   = 0;
static struct file *usedhfiles   = 0;

extern unsigned long event;

#if 0
static void insert_file_free(struct file *file)
{
        file->f_next = first_file;
        file->f_prev = first_file->f_prev;
        file->f_next->f_prev = file;
        file->f_prev->f_next = file;
        first_file = file;
}

static void remove_file_free(struct file *file)
{
        if (first_file == file)
                first_file = first_file->f_next;
        if (file->f_next)
                file->f_next->f_prev = file->f_prev;
        if (file->f_prev)
                file->f_prev->f_next = file->f_next;
        file->f_next = file->f_prev = NULL;
}

static void put_last_free(struct file *file)
{
        remove_file_free(file);
        file->f_prev = first_file->f_prev;
        file->f_prev->f_next = file;
        file->f_next = first_file;
        file->f_next->f_prev = file;
}

void grow_files(void)
{
        struct file * file;
        int i;

#ifndef OS2
        file = (struct file *) get_free_page(GFP_KERNEL);
#else
        file = (struct file *) G_malloc(PAGE_SIZE);
#endif
        if (!file)
                return;

        nr_files+=i= PAGE_SIZE/sizeof(struct file);

        if (!first_file)
                file->f_next = file->f_prev = first_file = file++, i--;

        for (; i ; i--)
                insert_file_free(file++);
}

unsigned long file_table_init(unsigned long start, unsigned long end)
{
        first_file = NULL;
        return start;
}

struct file * get_empty_filp(void)
{
        int i;
        struct file * f;

        if (!first_file)
                grow_files();
repeat:
        for (f = first_file, i=0; i < nr_files; i++, f = f->f_next)
                if (!f->f_count) {
                        remove_file_free(f);
                        memset(f,0,sizeof(*f));
                        put_last_free(f);
                        f->f_count = 1;
                        f->f_version = ++event;
                        return f;
                }
        if (nr_files < NR_FILE) {
                grow_files();
                goto repeat;
        }
        return NULL;
}


#endif

unsigned long file_table_init(unsigned long start, unsigned long end) {
    long i;
    int  rc;

    nhfiles     = 61440 / sizeof(struct file);
    nfreehfiles = nhfiles;
    nusedhfiles = 0;

    if ((freehfiles = (struct file *)G_malloc(nhfiles * sizeof(struct file))) != 0) {
        for (i = 0 ; i < nhfiles ; i++) {
            freehfiles[i].f_next = (i == nhfiles - 1 ? 0 : freehfiles + i + 1);
            freehfiles[i].f_prev = (i == 0 ? 0 : freehfiles + i - 1);
            freehfiles[i].f_status  = STATUS_HFILE_FREE;
            freehfiles[i].f_magic   = FILE_MAGIC;
            freehfiles[i].f_mode    = 0;
            freehfiles[i].f_pos     = 0;
            freehfiles[i].f_count   = 0;
            freehfiles[i].f_reada   = 0;
            freehfiles[i].f_inode   = 0;
            freehfiles[i].f_version = 0;
            freehfiles[i].f_flags   = 0;
            freehfiles[i].f_op      = 0;
        }
        rc = NO_ERROR;
    } else {
        ext2_os2_panic(1, "Couldn't allocate file table");
    } /* end if */

    return rc;
}

struct file *get_empty_filp(void) {

    pfile curfree, nextfree, previousfree, curused, nextused, previousused;
/*
    fs_log("alloc_hfile()");
*/
    if (nfreehfiles == 0) {
        kernel_printf("alloc_hfile() : No mre files");
        return 0;
    }

    _disable();
    curfree      = freehfiles;
    curused      = usedhfiles;
    nextfree     = (curfree == 0 ? 0 : freehfiles->f_next);
    nextused     = (curused == 0 ? 0 : usedhfiles->f_next);
    previousfree = (curfree == 0 ? 0 : freehfiles->f_prev);
    previousused = (curused == 0 ? 0 : usedhfiles->f_prev);

    /*********************************************************/
    /*** Connects buf to used buffer list and disconnects  ***/
    /*** it from free buffer list                          ***/
    /*********************************************************/
    usedhfiles            = curfree;
    usedhfiles->f_next     = curused;
    usedhfiles->f_prev = 0;
    freehfiles            = nextfree;
    if (nextfree != 0) {
        freehfiles->f_prev = 0;
    } /* endif */
    if (curused != 0) {
        curused->f_prev = curfree;           /* (5) */
    } /* endif */
    /*********************************************************/

    usedhfiles->f_status    = STATUS_HFILE_USED;
    usedhfiles->f_count   ++;
    usedhfiles->f_version   = ++event;
    nusedhfiles++;
    nfreehfiles--;
    _enable();
    return usedhfiles;
}


int put_filp(struct file *p_file) {

    pfile curfree, nextfree, previousfree, curused, nextused, previousused;

    if (!p_file) {
        ext2_os2_panic(1, "freehfiles - p_file is NULL");
    }
    if (p_file->f_magic != FILE_MAGIC) {
        ext2_os2_panic(1, "freehfiles - invalid magic number");
    }

    _disable();
    curfree      = freehfiles;
    curused      = p_file;
    nextfree     = (curfree == 0 ? 0 : freehfiles->f_next);
    nextused     = (curused == 0 ? 0 : p_file->f_next);
    previousfree = (curfree == 0 ? 0 : freehfiles->f_prev);
    previousused = (curused == 0 ? 0 : p_file->f_prev);

    /*********************************************************/
    /*** Connects buf to free buffer list and disconnects  ***/
    /*** it from used buffer list                          ***/
    /*********************************************************/
    freehfiles        = curused;
    freehfiles->f_next = curfree;
    freehfiles->f_prev = 0;
    if (previousused != 0) {
        previousused->f_next = nextused;
    } else {
        usedhfiles = nextused;                 /* (7) */
    }
    if (nextused != 0) {
        nextused->f_prev = previousused;
    }
    if (curfree != 0) {
        curfree->f_prev = curused;            /* (6) */
    }
    /*********************************************************/

    freehfiles->f_count --;
    freehfiles->f_mode    = 0;
    freehfiles->f_pos     = 0;
    freehfiles->f_reada   = 0;
    freehfiles->f_inode   = 0;
    freehfiles->f_flags   = 0;
    freehfiles->f_op      = 0;
    freehfiles->f_version = 0;
    freehfiles->f_status  = STATUS_HFILE_FREE;

    nusedhfiles--;
    nfreehfiles++;
    _enable();
    return NO_ERROR;
}


void invalidate_files(struct super_block *sb) {
    struct file *f, *next;
    int found = 1;
    int pass  = 0;

    while (found) {
       pass ++;
       found = 0;
       f     = usedhfiles;
       while(f) {
           next = f->f_next;
            if (f->f_inode->i_sb == sb) {
                kernel_printf("Found file in use for device %d", sb->s_dev);
                vfs_close(f);
                found ++;
            }
            f = next;
        }
        kernel_printf("invalidate_files pass %d - found %d open files", pass, found);
    }
}

void invalidate_all_files(void) {
    while(usedhfiles) {
       kernel_printf("\tinvalidate_all_files() - Found file in use");
       vfs_close(usedhfiles);
    }
}
