//
// $Header: D:/ext2-os2/include/os2/RCS/types.h,v 6.0 1996/01/24 00:02:44 Willm Exp Willm $
//

// Linux ext2 file system driver for OS/2 2.x and WARP - Allows OS/2 to
// access your Linux ext2fs partitions as normal drive letters.
// Copyright (C) 1995, 1996 Matthieu WILLM 
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.



#ifndef __types_h
#define __types_h

#if defined (__IBMC__) || defined (__IBMCPP__)          // 32 bits IBM Cset++ types
    #define _FS_ENTRY _System
    #define _FS_PTR   *
    #define _FS_RET   int

    typedef char           INT8;
    typedef char _FS_PTR   pchar;
    typedef unsigned char  UINT8;
    typedef short          INT16;
    typedef unsigned short UINT16;
    typedef int            INT32;
    typedef unsigned int   UINT32;
    typedef UINT32        *PUINT32;
    typedef INT32         *PINT32;
#else                                                   // 16 bits MS Visual C++ types
/*    #define _FS_ENTRY far  pascal _loadds */
    #define _FS_ENTRY far  pascal

    #define _FS_PTR   far *             // This is no longer necessary with MSVC : -Gx- assumes data is FAR, I'll cleanup this later !
    #define _FS_RET   int

    typedef char           INT8;      /* signed 8 bits integer    */
    typedef INT8           int8;

    typedef unsigned char  UINT8;     /* unsigned 8 bits integer  */
    typedef int            INT16;     /* signed 16 bits integer   */
    typedef unsigned int   UINT16;    /* unsigned 16 bits integer */
    typedef long           INT32;     /* signed 32 bits integer   */

    typedef unsigned long  UINT32;    /* unsigned 32 bits integer */
    typedef UINT32 _FS_PTR PUINT32;   /* pointer to unsigned 32 bits integer */
    typedef INT32 _FS_PTR PINT32;   /* pointer to unsigned 32 bits integer */
    typedef char _FS_PTR   pchar;
#endif

typedef UINT32  blk_t;
typedef PUINT32 pblk_t;

// typedef UINT32 fileptr_t;
typedef INT32 fileptr_t;
// typedef PUINT32 pfileptr_t;
typedef PINT32 pfileptr_t;

typedef UINT32 ino_t;
typedef PUINT32 pino_t;

typedef UINT16 dev_t;           /* for hVPB */

typedef UINT32 __u32;           /* Linux unsigned 32 bits integer */
typedef UINT32   u32;           /* Linux unsigned 32 bits integer */
typedef UINT16 __u16;           /* Linux unsigned 16 bits integer */
typedef UINT8  __u8;            /* Linux unsigned  8 bits integer */

typedef INT32  __s32;
typedef INT16  __s16;
typedef INT8   __s8;

typedef UINT32 sem_t;           // RAM semaphore
typedef PUINT32 psem_t;         // pointer to RAM semaphore

//
// From /usr/src/linux-1.2.1/include/linux/types.h
//
// typedef int pid_t;
typedef unsigned short uid_t;
typedef unsigned short gid_t;
// typedef unsigned short dev_t;
// typedef __u32 ino_t;
// typedef unsigned short mode_t;
typedef unsigned short umode_t;
typedef unsigned short nlink_t;
//typedef int daddr_t;
typedef long off_t;
typedef long loff_t;
typedef unsigned long mode_t;

typedef long time_t;
// end from

typedef unsigned short pid_t;

#define asmlinkage

#endif /* __types_h */
