//
// $Header: D:/ext2-os2/RCS/fs_unsup.c,v 6.0 1996/01/23 23:55:14 Willm Exp Willm $
//

// Linux ext2 file system driver for OS/2 2.x and WARP - Allows OS/2 to     
// access your Linux ext2fs partitions as normal drive letters.
// Copyright (C) 1995, 1996 Matthieu WILLM 
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.



#define INCL_DOSERRORS
#define INCL_NOPMAPI
#include <os2.h>                // From the "Developer Connection Device Driver Kit" version 2.0

#include <fsd.h>
#include <fsh.h>

#include <os2/errors.h>
#include <os2/log.h>

#if 0
/*********************************************************************/
/***             Pager not yet supported                           ***/
/*********************************************************************/
_FS_RET _FS_ENTRY FS_ALLOCATEPAGESPACE(
                                    struct sffsi _FS_PTR psffsi,       /* ptr to fs independent SFT */
                                    struct sffsd _FS_PTR psffsd,       /* ptr to fs dependent SFT         */
                                    unsigned long        ulSize,       /* new size                         */
                                    unsigned long        ulWantContig  /* contiguous chunk size         */
                                   )
{
    int rc;

    if ((rc = fs_log("FS_ALLOCATEPAGESPACE()")) != NO_ERROR) {
        return rc;
    } /* end if */

    return ERROR_NOT_SUPPORTED;
}
/*********************************************************************/


/*********************************************************************/
/***             Pager not yet supported                           ***/
/*********************************************************************/
_FS_RET _FS_ENTRY FS_DOPAGEIO(
                              struct sffsi         _FS_PTR psffsi,
                              struct sffsd         _FS_PTR psffsd,
                              struct PageCmdHeader _FS_PTR pPageCmdList
                             )
{
    int rc;

    if ((rc = fs_log("FS_DOPAGEIO")) != NO_ERROR) {
        return rc;
    } /* end if */
    return ERROR_NOT_SUPPORTED;
}
/*********************************************************************/


/*********************************************************************/
/***             Pager not yet supported                           ***/
/*********************************************************************/
_FS_RET _FS_ENTRY FS_OPENPAGEFILE(
                                  unsigned long _FS_PTR pFlags,
                                  unsigned long _FS_PTR pcMaxReq,
                                  char          _FS_PTR pName,
                                  struct sffsi  _FS_PTR psffsi,
                                  struct sffsd  _FS_PTR psffsd,
                                  unsigned short        usOpenMode,
                                  unsigned short        usOpenFlag,
                                  unsigned short        usAttr,
                                  unsigned long         Reserved
                                 )
{
    int rc;

    if ((rc = fs_log("FS_OPENPAGEFILE")) != NO_ERROR) {
        return rc;
    } /* end if */
    return ERROR_NOT_SUPPORTED;
}
/*********************************************************************/

#endif

/*********************************************************************/
/***             Pager not yet supported                           ***/
/*********************************************************************/
_FS_RET _FS_ENTRY FS_SETSWAP(
                             struct sffsi _FS_PTR psffsi,
                             struct sffsd _FS_PTR psffsd
                            )
{
    int rc;

    if ((rc = fs_log("FS_SETSWAP")) != NO_ERROR) {
        return rc;
    } /* end if */
    return ERROR_NOT_SUPPORTED;
}
/*********************************************************************/

#if 0
/*********************************************************************/
/***             N/A : this is a local FSD                         ***/
/*********************************************************************/
_FS_RET _FS_ENTRY FS_VERIFYUNCNAME(
                                   unsigned short         flag,
                                   char           _FS_PTR pName
                                  )
{
    int rc;

    if ((rc = fs_log("FS_VERIFYUNCNAME")) != NO_ERROR) {
        return rc;
    } /* end if */
    return ERROR_NOT_SUPPORTED;
}
/*********************************************************************/
#endif

/*********************************************************************/
/***             File locks not yet supported                      ***/
/*********************************************************************/
_FS_RET _FS_ENTRY FS_CANCELLOCKREQUEST(
                                   struct sffsi    _FS_PTR psffsi,        /* psffsi        */
                                   struct sffsd    _FS_PTR psffsd,        /* psffsd        */
                                   struct filelock _FS_PTR pLockRange        /* pLockRang        */
                                  )
{
    int rc;

    if ((rc = fs_log("FS_CANCELLOCKREQUEST")) != NO_ERROR) {
        return rc;
    } /* end if */
    return ERROR_NOT_SUPPORTED;
}
/*********************************************************************/

/*********************************************************************/
/***             File locks not yet supported                      ***/
/*********************************************************************/
_FS_RET _FS_ENTRY FS_FILELOCKS(
                               struct sffsi    _FS_PTR psffsi,
                               struct sffsd    _FS_PTR psffsd,
                               struct filelock _FS_PTR pUnLockRange,
                               struct filelock _FS_PTR pLockRange,
                               unsigned long           timeout,
                               unsigned long           flags
                              )
{
    int rc;

    if ((rc = fs_log("FS_FILELOCKS() : Not supported (not yet implemented) !")) != NO_ERROR) {
        return rc;
    } /* end if */
    return ERROR_NOT_SUPPORTED;
}
/*********************************************************************/


/*********************************************************************/
/***         Combined file I/O not yet supported                   ***/
/*********************************************************************/
_FS_RET _FS_ENTRY FS_FILEIO(
                            struct sffsi   _FS_PTR psffsi,
                            struct sffsd   _FS_PTR psffsd,
                            char           _FS_PTR cbCmdList,
                            unsigned short         pCmdLen,
                            unsigned short _FS_PTR poError,
                            unsigned short         IOflag
                           )
{
    int rc;

    if ((rc = fs_log("FS_FILEIO")) != NO_ERROR) {
        return rc;
    } /* end if */
    return ERROR_NOT_SUPPORTED;
}
/*********************************************************************/


/*********************************************************************/
/***             N/A : this is a local FSD                         ***/
/*********************************************************************/
_FS_RET _FS_ENTRY FS_ATTACH(
                         unsigned short       flag,        /* flag                */
                         char           _FS_PTR pDev,        /* pDev                */
                         struct vpfsd   _FS_PTR pvpfsd, /* if remote drive
                                                           struct vpfsd far *
                                                           else if remote device
                                                                  null ptr (0L)    */
                         struct cdfsd   _FS_PTR pcdfsd,        /* if remote drive
                                                           struct cdfsd far *
                                                          else
                                                          struct devfsd far * */
                         char           _FS_PTR pParm,        /* pParm        */
                         unsigned short _FS_PTR pLen        /* pLen                */
                        )
{
    int rc;

    if ((rc = fs_log("FS_ATTACH")) != NO_ERROR) {
        return rc;
    } /* end if */
    return ERROR_NOT_SUPPORTED;
}
/*********************************************************************/


/*********************************************************************/
/***             N/A : this is a local FSD                         ***/
/*********************************************************************/
_FS_RET _FS_ENTRY FS_NMPIPE(
                            struct sffsi   _FS_PTR psffsi,
                            struct sffsd   _FS_PTR psffsd,
                            unsigned short         OpType,
                            union npoper   _FS_PTR pOpRec,
                            char           _FS_PTR pData,
                            char           _FS_PTR pName
                           )
{
    int rc;

    if ((rc = fs_log("FS_NMPIPE")) != NO_ERROR) {
        return rc;
    } /* end if */
    return ERROR_NOT_SUPPORTED;
}
/*********************************************************************/


/*********************************************************************/
/***            Obsolete entry point in OS/2 WARP                  ***/
/*********************************************************************/
_FS_RET _FS_ENTRY FS_FINDNOTIFYCLOSE(
                                     unsigned short handle
                                    )
{
    int rc;

    if ((rc = fs_log("FS_FINDNOTIFYCLOSE")) != NO_ERROR) {
        return rc;
    } /* end if */
    return ERROR_NOT_SUPPORTED;
}
/*********************************************************************/


/*********************************************************************/
/***            Obsolete entry point in OS/2 WARP                  ***/
/*********************************************************************/
_FS_RET _FS_ENTRY FS_FINDNOTIFYFIRST(
                                     struct cdfsi   _FS_PTR pcdfsi,
                                     struct cdfsd   _FS_PTR pcdfsd,
                                     char           _FS_PTR pName,
                                     unsigned short         iCurDirEnd,
                                     unsigned short         attr,
                                     unsigned short _FS_PTR pHandle,
                                     char           _FS_PTR pData,
                                     unsigned short         cbData,
                                     unsigned short _FS_PTR pcMatch,
                                     unsigned short         level,
                                     unsigned long          timeout
                                    )
{
    int rc;

    if ((rc = fs_log("FS_FINDNOTIFYFIRST")) != NO_ERROR) {
        return rc;
    } /* end if */
    return ERROR_NOT_SUPPORTED;
}
/*********************************************************************/

/*********************************************************************/
/***            Obsolete entry point in OS/2 WARP                  ***/
/*********************************************************************/
_FS_RET _FS_ENTRY FS_FINDNOTIFYNEXT(
                                    unsigned short         handle,
                                    char           _FS_PTR pData,
                                    unsigned short         cbData,
                                    unsigned short _FS_PTR pcMatch,
                                    unsigned short         infolevel,
                                    unsigned long          timeout
                                   )
{
    int rc;

    if ((rc = fs_log("FS_FINDNOTIFYNEXT")) != NO_ERROR) {
        return rc;
    } /* end if */
    return ERROR_NOT_SUPPORTED;
}
/*********************************************************************/
