//
// $Header: D:/ext2-os2/RCS/devhelp.c,v 6.0 1996/01/23 23:54:37 Willm Exp Willm $
//

// Linux ext2 file system driver for OS/2 2.x and WARP - Allows OS/2 to     
// access your Linux ext2fs partitions as normal drive letters.
// Copyright (C) 1995, 1996 Matthieu WILLM 
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.


#define INCL_DOSERRORS
#define INCL_NOPMAPI
#include <os2.h>           // From the "Developer Connection Device Driver Kit" version 2.0
#include <dhcalls.h>       // From the "Developer Connection Device Driver Kit" version 2.0

#include <os2/types.h>
#include <os2/os2misc.h>
#include <os2/os2proto.h>


/*
 * This routine is used in place of FSH_PROBEBUF to verify and lock user buffers passed to the IFS.
 * Contrarily to FSH_PROBEBUF, this one is valid across yields. It uses a verify-lock. (VMLock)
 */

int LockUserBuffer(void *buf, unsigned long size, void *lock, int write, unsigned long *plock_lin) {
    unsigned long buf_lin;
    unsigned long PgCount;
    unsigned long flags;
    int           rc;

    flags = VMDHL_NOBLOCK | VMDHL_LONG | VMDHL_VERIFY;
    if (write) {
        flags |= VMDHL_WRITE;
    }

    /*
     * FLAT address of user buffer
     */
    if ((rc = VirtToLin(buf, &buf_lin)) == NO_ERROR) {
        /*
         * FLAT address of lock handle
         */
        if ((rc = VirtToLin(lock, plock_lin)) == NO_ERROR) {
            /*
             * Requests a Verify-Lock on the user buffer.
             */
            if ((rc = VMLock(flags, buf_lin, size, -1, *plock_lin, &PgCount)) == NO_ERROR) {
                /*
                 * Nothing to do ...
                 */
            } else {
                kernel_printf("VMLock returned %d", rc);
            }
        } else {
            kernel_printf("LockUserBuffer : VirtToLin() returned %d", rc);
        }
    } else {
        kernel_printf("LockUserBuffer : VirtToLin() returned %d", rc);
    }

    return rc;
}


#if 0
char *G_malloc_fixed(unsigned long size) {
    char          lock[12];
    unsigned long buf_lin;
    unsigned long lock_lin;
    unsigned long PgCount;
    unsigned short seg;
    unsigned long  ptr;
    int            rc, rc2;


    ptr = 0;
    if ((rc = FSH_SEGALLOC(SA_FRING0 | SA_FSWAP, size, &seg)) == NO_ERROR) {
        /*
         * FLAT address of buffer
         */
        if ((rc2 = VirtToLin((void *)MAKEP(seg, 0), &buf_lin)) == NO_ERROR) {
            /*
             * FLAT address of lock handle
             */
            if ((rc2 = VirtToLin(lock, &lock_lin)) == NO_ERROR) {
                /*
                 * Requests a long term lock.
                 */
                if ((rc2 = VMLock(VMDHL_LONG | VMDHL_WRITE, buf_lin, size, -1, lock_lin, &PgCount)) == NO_ERROR) {
                    /*
                     * Returns the pointer.
                     */
                    ptr = (((unsigned long)seg) << 16);
                } else {
                    kernel_printf("VMLock returned %d", rc);
                }
            } else {
                kernel_printf("VirtToLin() returned %d", rc);
            }
        } else {
            kernel_printf("VirtToLin() returned %d", rc);
        }
        if (rc2 != NO_ERROR) {
           FSH_SEGFREE(seg);
        }
    } else {
        kernel_printf("FSH_SEGALLOC failed with rc = %d", rc);
    } /* FSH_SEGALLOC failed */

    return (char *)ptr;

}

#endif
