#define INCL_DOS
#define INCL_DOSERRORS
#include <os2.h>

#include <stdio.h>

#include <os2/vfsapi.h>


int main(int argc, char **argv) {
    struct vfs_stat s;
    HFILE hf;
    int   rc;
    ULONG action;

    if (argc < 2) {
        fprintf(stderr, "Usage : test <file name>\n");
        return -1;
    }
    printf("===> %s\n", argv[1]);

    if ((rc = DosOpen(argv[1], &hf, &action, 0, 0, OPEN_ACTION_OPEN_IF_EXISTS | OPEN_ACTION_FAIL_IF_NEW, OPEN_SHARE_DENYNONE, NULL)) != NO_ERROR) {
        printf("DosOpen returned %d\n", rc);
        return -1;
    }



    rc = vfs_fstat((int)hf, &s);
    printf("\tfstat returned : %d\n", rc);
    DosClose(hf);

    rc = vfs_stat(argv[1], &s);
    printf("\tstat returned  : %d\n", rc);

    return 0;
}
