//
// $Header: D:/ext2-os2/vfsapi/RCS/stat.c,v 1.3 1995/12/10 15:03:47 Willm Exp Willm $
//

// Linux ext2 file system driver for OS/2 2.x and WARP - Allows OS/2 to     
// access your Linux ext2fs partitions as normal drive letters.
// OS/2 implementation : Copyright (C) 1995  Matthieu WILLM
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

#define INCL_DOS
#define INCL_DOSERRORS
#include <os2.h>

#include <string.h>

#include <os2/vfsapi.h>

static struct fsctl_msg ext2_os2_magic   = {sizeof(magic_msg), magic_msg};


int VFSENTRY vfs_fstat(int fd, struct vfs_stat *s) {
    APIRET rc;
    ULONG  dataio, parmio;
    short  err;
    struct fsctl_msg  sig;

    //
    // We first check that the file descriptor refers to a file located on a file system
    // managed by ext2-os2.ifs
    //
    err    = NO_ERROR;
    dataio = 0;
    parmio = sizeof(short);
    if ((rc = DosFSCtl(
                       &sig,  sizeof(struct fsctl_msg), &dataio,
                       &err,  sizeof(short), &parmio,
                       FSCTL_ERROR_INFO,  NULL,
                       (HFILE)fd,  FSCTL_HANDLE)) != NO_ERROR) {
        return rc;
    }
    if (memcmp(&sig, &ext2_os2_magic, sizeof(struct fsctl_msg)) != 0) {
        return ERROR_INVALID_PARAMETER;
    } 


    //
    // We then ask ext2-os2.ifs to do the fstat() call
    //
    dataio = 0;
    parmio = 0;
    if ((rc = DosFSCtl(
                       s,  sizeof(struct vfs_stat), &dataio, 
                       NULL,  0, &parmio,
                       EXT2_OS2_FSTAT,  NULL,
                       (HFILE)fd,  FSCTL_HANDLE)) != NO_ERROR) {
        return rc;
    }

    return 0;
}

int VFSENTRY vfs_stat(const char *pathname, struct vfs_stat *s) {
    APIRET rc;
    ULONG  dataio, parmio;
    short  err;
    struct fsctl_msg  sig;

    //
    // We first check that the file descriptor refers to a file located on a file system
    // managed by ext2-os2.ifs
    //
    err    = NO_ERROR;
    dataio = 0;
    parmio = sizeof(short);
    if ((rc = DosFSCtl(
                       &sig,  sizeof(struct fsctl_msg), &dataio,
                       &err,  sizeof(short), &parmio,
                       FSCTL_ERROR_INFO,  (PSZ)pathname,
                       (HFILE)(-1),  FSCTL_PATHNAME)) != NO_ERROR) {
        return rc;
    }
    if (memcmp(&sig, &ext2_os2_magic, sizeof(struct fsctl_msg)) != 0) {
        return ERROR_INVALID_PARAMETER;
    } 

    //
    // We then ask ext2-os2.ifs to do the stat() call
    //
    dataio = sizeof(struct vfs_stat);
    parmio = 0;
    if ((rc = DosFSCtl(
                       s,  sizeof(struct vfs_stat), &dataio, 
                       NULL,  0, &parmio, 
                       EXT2_OS2_STAT,  (PSZ)pathname,
                       (HFILE)(-1),  FSCTL_PATHNAME)) != NO_ERROR) {
        return rc;
    }

    return 0;
}
