#ifndef __VFSAPI_H
#define __VFSAPI_H

#include <linux/stat.h>

/*
 * DosFsCtl function range 0x8000 - 0xBFFF is reserved for local FSD use
 */
#define EXT2_OS2_STAT         0xA000                // vfs_stat()
#define EXT2_OS2_FSTAT        0xA001                // vfs_fstat()
#define EXT2_OS2_SYNC         0xA002                // vfs_sync()
#define EXT2_OS2_GETDATA      0xA003                // (private)
#define EXT2_OS2_BDFLUSH      0xA004                // vfs_bdflush()
#define EXT2_OS2_SHRINK_CACHE 0xA005                // (private)

/*
 * DosFsCtl FSCTL_ERROR_INFO messages
 */
#define MAX_MSG        256
#define magic_msg   "EXT2-OS2 (Linux ext2fs IFS for OS/2) - The error code is NO ERROR"
#define default_msg "EXT2-OS2 (Linux ext2fs IFS for OS/2) - The error code is UNKNOWN"
struct fsctl_msg {
    short  length;
    char   msg[MAX_MSG];
};


/*
 * EXT2_OS2_GETDATA data structures
 */

struct buffer_data {
    long buffer_mem;
    long cache_size;
    long nr_buffer_heads;

    long nr_buffers_type[6];
    long nr_free[4];

};
#ifdef __KERNEL__
extern long buffermem;                // in vfs/buffer.c
extern long cache_size;               // in vfs/buffer.c
extern long nr_buffer_heads;          // in vfs/buffer.c
extern long nr_free[4];               // in vfs/buffer.c
extern long nr_buffers_type[6]; // in vfs/buffer.c
#endif

struct inode_data {
    long nr_inodes;
    long nr_free_inodes;
};


#ifdef __KERNEL__
extern long nr_inodes;         // in vfs/inode.c
extern long nr_free_inodes;    // in vfs/inode.c
#endif

struct file_data {
    long nhfiles;
    long nfreehfiles;
    long nusedhfiles;
};

#ifdef __KERNEL__
extern long nhfiles;         // vfs/f_table.c
extern long nfreehfiles;     // vfs/f_table.c
extern long nusedhfiles;     // vfs/f_table.c
#endif

struct ext2_os2_data {
    struct buffer_data b;
    struct inode_data  i;
    struct file_data   f;
};

#ifndef __KERNEL__

#ifdef __IBMC__
#define VFSENTRY _System
#else
#define VFSENTRY
#endif

struct vfs_stat {
        unsigned short st_dev;
        unsigned short __pad1;
        unsigned long st_ino;
        unsigned short st_mode;
        unsigned short st_nlink;
        unsigned short st_uid;
        unsigned short st_gid;
        unsigned short st_rdev;
        unsigned short __pad2;
        unsigned long  st_size;
        unsigned long  st_blksize;
        unsigned long  st_blocks;
        unsigned long  st_atime;
        unsigned long  __unused1;
        unsigned long  st_mtime;
        unsigned long  __unused2;
        unsigned long  st_ctime;
        unsigned long  __unused3;
        unsigned long  __unused4;
        unsigned long  __unused5;
};

int VFSENTRY vfs_fstat(int fd, struct vfs_stat *s);
int VFSENTRY vfs_stat(const char *pathname, struct vfs_stat *s);
int VFSENTRY vfs_sync(void);

#endif

#endif
