//
// $Header: D:/ext2-os2/include/os2/RCS/os2proto.h,v 4.1 1995/12/10 15:02:28 Willm Exp Willm $
//

// Linux ext2 file system driver for OS/2 2.x and WARP - Allows OS/2 to
// access your Linux ext2fs partitions as normal drive letters.
// OS/2 implementation : Copyright (C) 1995  Matthieu WILLM
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.



#ifndef __OS2PROTO_H
#define __OS2PROTO_H

#include <fsh.h>
#include <os2/types.h>
#include <stdarg.h>

//
// From isfat.c
//
int isfat(pchar component);

//
// From pathutil.c
//
pchar DecoupePath(pchar path, pchar component);
void ExtractPath(pchar Name, pchar Path);
void ExtractName(pchar Name, pchar Nom);


//
// From log.c
//
#ifdef FS_DEBUG
int kernel_printf(const char *fmt, ...);
#else
extern _inline int kernel_printf(const char *fmt, ...) {return 0;}
#endif
#define printk kernel_printf

//
// From devhelp.c and devhelp2.asm
//
int FS_DevHelp_VMAlloc(unsigned long taille, unsigned long PhysAddr, unsigned long Flags, PUINT32 LinAddr);
int FS_DevHelp_VMFree(unsigned long LinAddr);
int FS_DevHelp_GetDOSVar(unsigned char index, char _FS_PTR _FS_PTR value);
extern int ProcRun(unsigned long event_id);
extern int ProcBlock(unsigned long event_id, long timeout, unsigned short flag);
extern int Beep(int frequency, int duration);
extern int VirtToPhys(ULONG virt, PULONG phys);
extern int VirtToLin(void *virt, unsigned long *plin);
int VMLock(
           unsigned long  flags,
           unsigned long  lin,            // FLAT pointer
           unsigned long  length,
           unsigned long  pPageList,      // FLAT pointer
           unsigned long  pLockHandle,    // FLAT pointer
           unsigned long *pPageListCount
          );
int VMUnlock(
             unsigned long plock_lin      // FLAT pointer
            );

#define LOCK_WRITE 1
#define LOCK_READ  0
int LockUserBuffer(void *buf, unsigned long size, void *lock, int write, unsigned long *plock_lin);


extern unsigned short getuid(void);
extern void setuid(unsigned short uid);

//
// From util.c
//
unsigned long updcrc(unsigned char *s, unsigned n);

//
// From fs_find.c
//
extern void date_unix2dos(long unix_date,unsigned short *time, unsigned short *date);
extern long date_dos2unix(unsigned short time, unsigned short date);

//
// From attr.c
//
void DOS_To_Linux_Attrs(struct inode *inode, unsigned short DOS_attrs);
unsigned short Linux_To_DOS_Attrs(struct inode *inode, char *component);

//
// From volume.c
//
extern int Check_Ext2fs_magic(struct vpfsi *pvpfsi, unsigned short hVPB);
extern int lazy_write(struct super_block *sb);
extern int ring0_ext2_os2_init(void);

#if 0
//
// cli/sti Now obsolete and replaced with _enable() and _disable()
//
void _inline sti(void) {
    __asm {
        sti
    }
}

void _inline cli(void) {
    __asm {
        cli
    }
}
#endif

//
// from maperr.c
//
extern int map_err(int err);


//
// Memory allocation routines
//
extern __inline char *G_malloc(unsigned long cbSize) {
    unsigned long  ptr;
    unsigned short seg;
    int            rc;

    ptr = 0;
    if ((rc = FSH_SEGALLOC(SA_FRING0 | SA_FSWAP, cbSize, &seg)) == NO_ERROR) {
        ptr = ((unsigned long)seg) << 16;
    } else {
        kernel_printf("FSH_SEGALLOC failed with rc = %d", rc);
    }

    return (char *)ptr;
}

#if 1
extern __inline void *G_malloc_fixed(unsigned long cbSize) {
    unsigned short seg;
    unsigned long  ptr;
    int            rc;

    ptr = 0;
    if ((rc = FSH_SEGALLOC(SA_FRING0, cbSize, &seg)) == NO_ERROR) {
        ptr = ((unsigned long)seg) << 16;
    } else {
        kernel_printf("FSH_SEGALLOC failed with rc = %d", rc);
    }
    return (void *)ptr;
}
#else
extern char *G_malloc_fixed(unsigned long cbSize);
#endif
extern __inline int G_free(char *ptr) {
    int rc;

//    if ((rc = FSH_SEGFREE((unsigned short)(((unsigned long) ptr) >> 16))) != NO_ERROR) {
    if ((rc = FSH_SEGFREE((__segment)ptr)) != NO_ERROR) {
        kernel_printf("FSH_SEGFREE failed with rc = %d", rc);
    }
    return rc;

}

//
// Dumb panic macro - initiates a system halt
//
#define os2_panic(panicmsg) FSH_INTERR(("EXT2-fs panic : "panicmsg), sizeof("EXT2-fs panic : "panicmsg))



//
// From vsprintf.c
//
int vsprintf(char *buf, const char *fmt, va_list args);
int sprintf(char * buf, const char *fmt, ...);

//
// From vfs/f_table.c
//
void invalidate_files(struct super_block *sb);
void invalidate_all_files(void);

//
// From case.c
//
int is_case_retensive(void);


#endif
