//
// $Header: D:/ext2-os2/rcs/ext2_lw.c,v 5.0 1995/12/29 23:07:25 Willm Exp Willm $
//

// Linux ext2 file system driver for OS/2 2.x and WARP - Allows OS/2 to
// access your Linux ext2fs partitions as normal drive letters.
// OS/2 implementation : Copyright (C) 1995  Matthieu WILLM
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

#define INCL_DOS
#define INCL_DOSERRORS
#define INCL_NOPMAPI
#include <os2.h>
#include <stdio.h>
#include  <stdlib.h>

#include <os2/vfsapi.h>

void shrink_cache_thread(void *parm) {
    ULONG  parmio;
    ULONG  dataio;
    APIRET rc;

    if ((rc = DosSetPriority(PRTYS_THREAD, PRTYC_IDLETIME, -30, 0)) == NO_ERROR) {
        while(1) {
            parmio = 0;
            dataio = 0;
            /*
             * cache shrink captive thread - We should normally never return from DosFsCtl.
             */
            if ((rc = DosFSCtl (
                                NULL,  0, &dataio,
                                NULL,  0, &parmio,
                                EXT2_OS2_SHRINK_CACHE,  "ext2",
                                -1,  FSCTL_FSDNAME)) != NO_ERROR) {
                fprintf(stderr, "DosFSCtl failed with rc = %d\n", rc);
            }
        }
    } else {
        fprintf(stderr, "DosSetPriority failed with rc = %d\n", rc);
    }

}

int main(int argc, char **argv) {
    ULONG  parmio;
    ULONG  dataio;
    APIRET rc;

    if ((rc = DosSetPriority(PRTYS_THREAD, PRTYC_IDLETIME, -30, 0)) == NO_ERROR) {
    if (_beginthread(shrink_cache_thread, 0, 16384, 0) != -1) {
        while(1) {
            parmio = 0;
            dataio = 0;
            /*
             * bdflush captive thread - We should normally never return from DosFsCtl.
             */
            if ((rc = DosFSCtl (
                                NULL,  0, &dataio,
                                NULL,  0, &parmio,
                                EXT2_OS2_BDFLUSH,  "ext2",
                                -1,  FSCTL_FSDNAME)) != NO_ERROR) {
                fprintf(stderr, "DosFSCtl failed with rc = %d\n", rc);
            } /* end if */
        }
    }
    } else {
        fprintf(stderr, "DosSetPriority failed with rc = %d\n", rc);
    }

}
