//
// $Header: D:/ext2-os2/rcs/case.c,v 5.0 1995/12/29 23:07:18 Willm Exp Willm $
//

// Linux ext2 file system driver for OS/2 2.x and WARP - Allows OS/2 to
// access your Linux ext2fs partitions as normal drive letters.
// OS/2 implementation : Copyright (C) 1995  Matthieu WILLM
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

#define INCL_DOSERRORS
#define INCL_NOPMAPI
#include <os2.h>		// From the "Developer Connection Device Driver Kit" version 2.0
#include <fsh.h>

#include <os2/types.h>
#include <os2/os2proto.h>
#include <os2/os2misc.h>

extern char Case_Retensive;

int is_case_retensive(void) {
    id_t myid;
    int  retval;

    retval = 0;
    if (Case_Retensive) {
        /*
         * Case retensivity set on the IFS command line
         */
        retval = 1;
    } else {
        /*
         * Case retensivity not set on the IFS command line, then is it a DOS box request ?
         * (DOS box are always case retensive)
         */
        if (FSH_QSYSINFO(2, (char *)&myid, sizeof(id_t)) == NO_ERROR) {
            if (myid.pdb) {
                retval = 1;
            }
        } else {
            os2_panic("FSH_QSYSINFO failed");
        }
    }

    return retval;
}