;
; $Header: D:/ext2-os2/RCS/devhelp2.asm,v 1.7 1995/08/08 21:18:44 Willm Exp Willm $
;

; Linux ext2 file system driver for OS/2 2.x and WARP - Allows OS/2 to     
; access your Linux ext2fs partitions as normal drive letters.
; OS/2 implementation : Copyright (C) 1995  Matthieu WILLM
;
; This program is free software; you can redistribute it and/or modify
; it under the terms of the GNU General Public License as published by
; the Free Software Foundation; either version 2 of the License, or
; (at your option) any later version.
;
; This program is distributed in the hope that it will be useful,
; but WITHOUT ANY WARRANTY; without even the implied warranty of
; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
; GNU General Public License for more details.
;
; You should have received a copy of the GNU General Public License
; along with this program; if not, write to the Free Software
; Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.


;
; These are *LARGE MEMORY MODEL* DevHelp C bindings
;
        .286p
	.model large

	INCL_DOSERRORS  EQU     1
	include os2.inc				; From the "Developer Connection Device Driver Kit" version 2.0
	include devhlp.inc      		; From the "Developer Connection Device Driver Kit" version 2.0
	include sas.inc      			; From the "Developer Connection Device Driver Kit" version 2.0

	.data

extrn   TCB_USER_ID : abs			; Offset to uid field in TCB
extrn	SAS_SEL     : abs			; System Anchor Segment selector

	public _Device_Help
	_Device_Help dd (?)

	sas_ptr      dd (?)
	.code

;
; int FS_DevHelp_VMAlloc(
;                        unsigned long Taille,		/* bp + 6  */
;                        unsigned long PhysAddr,        /* bp + 10 */
;                        unsigned long Flags,           /* bp + 14 */
;                        PUINT32 LinAddr                /* bp + 18 */
;                       );
;
;
public _FS_DevHelp_VMAlloc
_FS_DevHelp_VMAlloc proc far
	push bp
	mov  bp, sp
	push ds
	push di
	mov ax, DGROUP
	mov ds, ax
	ASSUME DS: DGROUP

.386p
	mov   ecx, dword ptr[bp + 6]		; Taille
	mov   edi, dword ptr[bp + 10]		; PhysAddr
	mov   eax, dword ptr[bp + 14]		; Flags
	mov   dl, DevHlp_VMAlloc
	call  [_Device_Help]
	jc    VMAlloc_error

	les   bx, dword ptr[bp + 18]		; LinAddr
	mov   es:[bx], eax
	mov   ax, NO_ERROR
	jmp VMAlloc_out
.286p
VMAlloc_error:
	mov ax, -1

VMAlloc_out:
	pop di
	pop ds
	leave
	ret
_FS_DevHelp_VMAlloc endp

; 
; int FS_DevHelp_VMFree(
;                       unsigned long LinAddr	/* bp + 6 */
;                      );
;
public _FS_DevHelp_VMFree
_FS_DevHelp_VMFree proc far
;ARG @@LinAddr:DWORD
	push bp
	mov  bp, sp
	push ds
	mov ax, DGROUP
	mov ds, ax
	ASSUME DS: DGROUP
.386p
    mov   eax, dword ptr[bp + 6]                ; LinAddr
    mov   dl, DevHlp_VMFree
    call  [_Device_Help]
    jc    VMFree_error
    mov   ax, NO_ERROR
    jmp VMFree_out
.286p
VMFree_error:
    mov ax, -1

VMFree_out:
	pop ds
        leave
        ret
_FS_DevHelp_VMFree endp

;
; int FS_DevHelp_GetDOSVar(
;                          unsigned char index,	/* bp + 6  */
;                          ppchar value		/* bp + 8  */
;                         );
;
public _FS_DevHelp_GetDOSVar
_FS_DevHelp_GetDOSVar proc far
	push bp
	mov  bp, sp
	push ds
;	push es
	mov ax, DGROUP
	mov ds, ax
	ASSUME DS: DGROUP

        mov al, byte ptr[bp + 6]                    ; index
        mov dl, DevHlp_GetDOSVar
        call [_Device_Help]
        jc GetDOSVar_error
        les di, dword ptr[bp + 8]                  ; value
        mov es:[di], bx
        mov es:[di + 2], ax
        mov ax, NO_ERROR
        jmp GetDOSVar_out

GetDOSVar_error:
        mov ax, -1

GetDOSVar_out:
;	pop es
	pop ds
        leave
        ret
_FS_DevHelp_GetDOSVar endp 


;
; void FS_DevHelp_ProcBlock(
;                          unsigned short event_id_low,  /* bp + 6  */
;                          unsigned short event_id_high  /* bp + 8  */
;                         );
;
public _FS_DevHelp_ProcBlock
_FS_DevHelp_ProcBlock proc far
	push bp
	mov  bp, sp
	push ds
	push es
	push di
	mov ax, DGROUP
	mov ds, ax
	ASSUME DS: DGROUP

        mov bx, [bp + 6]
        mov ax, [bp + 8]
        mov di, -1
        mov cx, -1
        mov dh, 1
        mov dl, DevHlp_ProcBlock
        call [_Device_Help]
	pop di
	pop es
	pop ds
        leave
        ret
_FS_DevHelp_ProcBlock endp 


;
; void FS_DevHelp_ProcRun(
;                          unsigned short event_id_low,  /* bp + 6  */
;                          unsigned short event_id_high  /* bp + 8  */
;                         );
;
public _FS_DevHelp_ProcRun
_FS_DevHelp_ProcRun proc far
	push bp
	mov  bp, sp
	push ds
	mov ax, DGROUP
	mov ds, ax
	ASSUME DS: DGROUP

        mov bx, [bp + 6]
        mov ax, [bp + 8]
        mov dl, DevHlp_ProcRun
        call [_Device_Help]
	pop ds
        leave
        ret
_FS_DevHelp_ProcRun endp 


;
; unsigned short getuid(void)
;
public _getuid
_getuid proc far
	push bp
	mov  bp, sp
	push ds
	push es	
	mov ax, DGROUP
	mov ds, ax
	ASSUME DS: DGROUP


	mov ax, SAS_SEL			; System Anchor Segment selector
	mov es, ax
	mov bx, 0			; now es:bx points to the SAS base


	mov ax, es:[bx].SAS_flat_sel	; Flat kernel Data segment
	mov ds, ax			; ds now is the FLAT ring 0 selector
	assume ds:nothing
	mov cx, es:[bx].SAS_task_data	; task section offset in SAS
	add bx, cx			; now es:bx points to the task section of SAS
.386p
	
	mov ecx, es:[bx].SAS_task_threadptrs ; FLAT address of address of TCB address array
	mov ecx, [ecx]			     ; FLAT address of TCB address array
	mov ebx, es:[bx].SAS_task_tasknumber ; FLAT address of FLAT address of current TCB
	mov ebx, [ebx]                       ; FLAT address of current TCB number
	mov ebx, [ecx + 4 * ebx]	     ; FLAT address of current TCB
	xor eax, eax
	mov ax, word ptr [ebx + TCB_USER_ID] ; user id
.286p
	pop es
	pop ds
	leave
	ret
_getuid endp

;
; unsigned short setuid(unsigned short uid);
;
public _setuid
_setuid proc far
	push bp
	mov  bp, sp
	push ds
	push es	
	mov ax, DGROUP
	mov ds, ax
	ASSUME DS: DGROUP

	push si
	push di
	mov si, [bp + 6]		; uid

	mov ax, SAS_SEL			; System Anchor Segment selector
	mov es, ax
	mov bx, 0			; now es:bx points to the SAS base


	mov ax, es:[bx].SAS_flat_sel	; Flat kernel Data segment
	mov ds, ax			; ds now is the FLAT ring 0 selector
	assume ds:nothing
	mov cx, es:[bx].SAS_task_data	; task section offset in SAS
	add bx, cx			; now es:bx points to the task section of SAS
.386p
	
	mov ecx, es:[bx].SAS_task_threadptrs ; FLAT address of address of TCB address array
	mov ecx, [ecx]			     ; FLAT address of TCB address array
	mov ebx, es:[bx].SAS_task_tasknumber ; FLAT address of FLAT address of current TCB
	mov ebx, [ebx]                       ; FLAT address of current TCB number
	mov ebx, [ecx + 4 * ebx]	     ; FLAT address of current TCB
	mov word ptr [ebx + TCB_USER_ID], si ; user id
.286p
	pop di
	pop si
	pop es
	pop ds
	leave
	ret
_setuid endp

        end

