#include <afx.h>
#include <stdio.h>

DWORD dwlName, dwlData, dwType;
char szName[1024];
char cbData[16384], *p;
FILETIME fTime;

void TraverseKey (HKEY hKey, FILE *fo, CString keyName)
{
	HKEY hSubKey;
	LONG lErr;
	int nLine, ixVal;
	DWORD dwX;
	
	fprintf (fo, "\n[%s]\n", (LPCSTR)keyName);

	// Enumerate values
	for (ixVal=0;;ixVal++) {
		dwlName = sizeof szName;
		dwlData = sizeof cbData;
		if ((lErr = RegEnumValue (hKey, ixVal, szName, &dwlName, NULL, &dwType, (LPBYTE)cbData, &dwlData)) != ERROR_SUCCESS)
			break;
		
		fprintf (fo, "\"%s\"=", szName);
		switch (dwType) {
		case REG_DWORD:
			fprintf (fo, "dword:%08X\n", *((DWORD*)cbData));
			break;
		case REG_SZ:
			fprintf (fo, "\"%s\"\n", cbData);
			break;
		case REG_MULTI_SZ:
		case REG_BINARY:
		
			fprintf (fo, "hex:");
			nLine = 20;
			for (dwX=0;dwX<dwlData;dwX++) {
				fprintf (fo, "%02x", (BYTE)cbData[dwX]);
				if (dwX<dwlData-1) fprintf (fo, ",");
				if (--nLine == 0) {
					nLine = 25;
					if (dwX<dwlData-1) fprintf (fo, "\\\n"); } }
			fprintf (fo, "\n");
			break;
		default:
			printf ("%s: vasue type %08X is unsupported\n", (LPCSTR)keyName, dwType); } }

	// Enumerate subkeys
	for (ixVal=0;;ixVal++) {
		dwlName = sizeof szName;
		dwlData = sizeof cbData;
		if ((lErr = RegEnumKeyEx (hKey, ixVal, szName, &dwlName, NULL, cbData, &dwlData, &fTime)) != ERROR_SUCCESS)
			break;
		
		if (RegOpenKeyEx (hKey, szName, NULL, GENERIC_READ, &hSubKey) == ERROR_SUCCESS) {
			TraverseKey (hSubKey, fo, keyName + '\\' + szName);
			CloseHandle (hSubKey); }
		else																					 
			printf ("Unable to open key %s for reading\n", keyName + '\\' + szName); }
}	

HKEY OpenKey (LPCSTR szKey)
{
	CString strKey (szKey), strTopKey, strSubKey;
	HKEY hKey, hSubKey;

	int ix = strKey.Find('\\');
	if (ix > 0) {
		strTopKey = strKey.Left (ix);
		if (ix < strKey.GetLength()-1)
			strSubKey = strKey.Mid (ix+1);
		else
			strSubKey.Empty (); }
	else
		return NULL;

	strTopKey.MakeUpper ();

	if (strTopKey == "HKEY_CLASSES_ROOT")
		hKey = HKEY_CLASSES_ROOT;
	else if (strTopKey == "HKEY_LOCAL_MACHINE")
		hKey = HKEY_LOCAL_MACHINE;
	else if (strTopKey == "HKEY_USERS")
		hKey = HKEY_USERS;
	else if (strTopKey == "HKEY_CURRENT_USER")
		hKey = HKEY_CURRENT_USER;
	else
		return NULL;

	if (strSubKey.IsEmpty())
		return hKey;
	else if (RegOpenKeyEx (hKey, strSubKey, 0, GENERIC_READ, &hSubKey) == NO_ERROR)
		return hSubKey;
	else
		return NULL;
}

void usage (void)
{
	printf ("EXPREG4 utility exports given registry subtree on NT machine into an ASCII\n");
	printf ("file suitable to export into Windows 95 registry by regedit utility\n\n");
	printf ("Usage: expreg4 <key-name> [<output-file>]\n\n");
	printf ("Give <key-name> in form <root-name>{/<subkey-name>}\n");
	printf ("where <root-name> can be one of HKEY_LOCAL_MACHINE, HKEY_USERS,\n");
	printf ("      HKEY_CURRENT_USER or HKEY_CLASSES_ROOT. Curly braces mean repetition\n");
	printf ("      of enclosed expression 0 or more times. When <output-file> is not given,\n");
	printf ("      then output goes to console.");
}

void main (int argc, char **argv)
{
	HKEY hKey;
	FILE *fo;
	
	printf ("EXPREG4: NT -> Windows 95 registry tree transfer utility\n");
	printf ("Copyright (c) Elipromm Priv Co, 1995\n\n");

	if (argc < 2 || argc > 4) {
		usage ();
		printf ("usage: EXPREG4 <reg-key> [<output file>]\n");
		return; }

	hKey = OpenKey (argv[1]);
	if (hKey == NULL) {
		printf ("Unable to open registry key %s\n", argv[1]);
		return; }

	if (argc == 2)
		fo = stdout;
	else {
		fo = fopen (argv[2], "w+");
		if (fo == NULL) {
			printf ("Unable to open outout file %s\n", argv[2]);
			return; } }

	fprintf (fo, "REGEDIT4\n");

	TraverseKey (hKey, fo, CString(argv[1]));
}
