unit Main;

interface

uses
  WinTypes, WinProcs, Classes, Messages,
  Forms, Menus, Dialogs, Buttons, IniFiles, Controls, ExtCtrls, StdCtrls, About;

type
  TBar = class(TForm)
    pbMain: TPopupMenu;
    peClose: TMenuItem;
    peStayOnTop: TMenuItem;
    Reboot: TBitBtn;
    pnClose: TPanel;
    Restart: TBitBtn;
    ExitWin: TBitBtn;
    peConfirmExit: TMenuItem;
    Bevel1: TBevel;
    Bevel2: TBevel;
    peAbout: TMenuItem;
    N1: TMenuItem;
    procedure peCloseClick(Sender: TObject);
    procedure RestartClick(Sender: TObject);
    procedure RebootClick(Sender: TObject);
    procedure ExitWinClick(Sender: TObject);
    procedure peStayOnTopClick(Sender: TObject);
    procedure pnCloseClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure peConfirmExitClick(Sender: TObject);
    procedure FormShow(Sender: TObject);
    procedure peAboutClick(Sender: TObject);
  private
    procedure WMNCHitTest(var M: TWMNCHitTest); message wm_NCHitTest;
  public
    { Public declarations }
  end;

var
  Bar: TBar;
  IniFile: TIniFile;
implementation

{$R *.DFM}

procedure TBar.peCloseClick(Sender: TObject);
begin
     If MessageDlg('Close Exiter?', mtConfirmation, mbOkCancel, 0) = mrOk Then
     Halt;
end;

procedure TBar.RestartClick(Sender: TObject);
var
   rc: bool;
begin
   If (MessageDlg('Restart Windows?', mtConfirmation, mbOkCancel, 0) = mrOk)
      and (peConfirmExit.Checked = True) Then
     rc := ExitWindows(ew_restartwindows, 0);
end;

procedure TBar.RebootClick(Sender: TObject);
var
   rc: bool;
begin
   If (MessageDlg('Reboot?', mtConfirmation, mbOkCancel, 0) = mrOk)
      and (peConfirmExit.Checked = True) Then
     rc := ExitWindows(ew_rebootsystem, 0);
end;

procedure TBar.ExitWinClick(Sender: TObject);
var
   rc: bool;
begin
   If (MessageDlg('Exit Windows?', mtConfirmation, mbOkCancel, 0) = mrOk)
      and (peConfirmExit.Checked = True) Then
     rc := ExitWindows(0, 0);
end;

procedure TBar.WMNCHitTest(var M: TWMNCHitTest);
begin
  inherited;                    { call the inherited message handler }
  if  M.Result = htClient then  { is the click in the client area?   }
    M.Result := htCaption;      { if so, make Windows think it's     }
                                { on the caption bar.                }
     IniFile.WriteInteger('exiter', 'Left', Bar.Left);
     IniFile.WriteInteger('exiter', 'Top', Bar.Top);
end;


procedure TBar.peStayOnTopClick(Sender: TObject);
begin
     If peStayOnTop.Checked = True then
     begin
        Bar.FormStyle := fsNormal;
        peStayOnTop.Checked := False;
        IniFile.WriteBool('exiter', 'StayOnTop', False);
     end
     else
     begin
        Bar.FormStyle := fsStayOnTop;
        peStayOnTop.Checked := True;
        IniFile.WriteBool('exiter', 'StayOnTop', True);
     end;
end;

procedure TBar.pnCloseClick(Sender: TObject);
begin
     If MessageDlg('Close Exiter?', mtConfirmation, mbOkCancel, 0) = mrOk Then
        Halt;
end;

procedure TBar.FormCreate(Sender: TObject);
var
rc: bool;
pstr: string;
const
hr = #10;
begin
     if paramcount > 0 then
     begin
        pstr := ParamStr(1);
        If (pstr = '/b') or (pstr = '/B') then
           rc := ExitWindows(ew_rebootsystem, 0)
        Else
           If (pstr = '/x') or (pstr = '/X') then
              rc := ExitWindows(0, 0)
           Else
              If (pstr = '/r') or (pstr = '/R') then
                 rc := ExitWindows(ew_restartwindows, 0)
              else
                 ShowMessage('Invalid command line argument.' + hr +
                 'Can be one of:' + hr +
                 '/B: reBoot' + hr +
                 '/X: eXit' + hr +
                 '/R: Restart Windows.');
     end;
     IniFile := TiniFile.Create('exiter');
     peConfirmExit.Checked := IniFile.ReadBool('exiter', 'ConfirmExit', True);
     peStayOnTop.Checked := IniFile.ReadBool('exiter', 'StayOnTop', True);
end;

procedure TBar.peConfirmExitClick(Sender: TObject);
begin
   If peConfirmExit.Checked = False then
   begin
     IniFile.WriteBool('exiter', 'ConfirmExit', True);
     peConfirmExit.Checked := True;
   end
   else begin
     IniFile.WriteBool('exiter', 'ConfirmExit', False);
     peConfirmExit.Checked := False;
   end;
end;

procedure TBar.FormShow(Sender: TObject);
begin
     Bar.Left := IniFile.ReadInteger('exiter', 'Left', 0);
     Bar.Top := IniFile.ReadInteger('exiter', 'Top', 0);
end;

procedure TBar.peAboutClick(Sender: TObject);
begin
     AboutBox.Show;
end;

end.
