Option Explicit

Sub Main ()

' This sample program shows you how to interface VB with the API of E!.
' It is a very simple program printing the text that has been selected
' in the current Editor window. No attempt is made to change the current
' printer settings. You can add code to open the common Printer dialog box.
' Be aware that VB will use its own settings and not those of E!.
'
' The program flow is very easy to understand. First it gets the current
' selection in E! if any. Then it retrieves each line of the selection and
' prints it.
'
' To use this VB program, first compile it to an .EXE. Then add it to your user
' menu in E!. Each time you will launch it, the current selection will be printed.
' The program doesn't use any form and only has one main procedure. Just don't
' forget to add EWCONST.TXT and WIN30API.TXT to your project. You must also
' Modify the default options in the Options|Project menu and use "Sub Main" as
' Start Up Form. This will be a common practice when adding function to E! using
' Visual Basic.

	Dim lpString As Long		' Used to retrieve line pointers
	Dim Buffer$			' Working buffer
	Dim Selection As TSelStruct	' Structure used to retrieve the selection
	Dim I As Long			' Index

	On Error GoTo PrintErrHandler

	' Retrieve current selection
	EWGetSelection Selection

	' Exit if none
	If Selection.SelType = EWSelection_None Then
	  MsgBox "No text has been selected", MB_OK + MB_ICONSTOP, "Error"
	  End
	End If

	' Printer setup
	Printer.ScaleMode = 7
	Printer.CurrentX = 1
	Printer.CurrentY = 1

	' Enter loop
	For I = Selection.FirstSelLine To Selection.LastSelLine
	  ' Prepare buffer
	  Buffer$ = Space$(255)
	  ' Get line
	  lpString = EWGetLineAt(I)
	  lpString = lstrcpy(Buffer$, lpString)
	  ' Trim only right spaces
	  Buffer$ = RTrim$(Buffer$)

	  ' Check for selection type
	  If (I = Selection.FirstSelLine) And (Selection.SelType = EWSelection_Stream) Then
	    Buffer$ = Space$(Selection.FirstSelCol) + Right$(Buffer$, Len(Buffer$) - Selection.FirstSelCol)
	  ElseIf (I = Selection.LastSelLine) And (Selection.SelType = EWSelection_Stream) Then
	    Buffer$ = Left$(Buffer$, Selection.LastSelCol)
	  ElseIf Selection.SelType = EWSelection_Block Then
	    Buffer$ = Mid$(Buffer$, Selection.FirstSelCol + 1, Selection.LastSelCol - Selection.FirstSelCol)
	  End If
	  ' Print resulting buffer
	  Printer.Print Buffer$

	  ' Jump to new page if necessary
	  If Printer.CurrentY >= Printer.ScaleHeight - 1 Then
	    Printer.NewPage
	    Printer.CurrentY = 1
	    Printer.CurrentX = 1
	  End If
	  Printer.CurrentX = 1
	Next

	' Terminate print
	Printer.EndDoc

PrintErrHandler:
  '-- User possibly clicked on the Cancel button
  Exit Sub

End Sub

